/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoPermissionsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoChannelMembershipDao_Impl
extends EkoChannelMembershipDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChannelMembershipEntity> __insertionAdapterOfChannelMembershipEntity;
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoPermissionsTypeConverter __ekoPermissionsTypeConverter = new EkoPermissionsTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<ChannelMembershipEntity> __deletionAdapterOfChannelMembershipEntity;
    private final EntityDeletionOrUpdateAdapter<ChannelMembershipEntity> __updateAdapterOfChannelMembershipEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMembership;
    private final SharedSQLiteStatement __preparedStmtOfUpdateReadToSegment;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllFromChannel;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUserImpl;

    public EkoChannelMembershipDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChannelMembershipEntity = new EntityInsertionAdapter<ChannelMembershipEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_membership` (`channelId`,`userId`,`readToSegment`,`membership`,`isMuted`,`isBanned`,`roles`,`permissions`,`displayName`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelMembershipEntity value) {
                Integer _tmp_1;
                Integer _tmp;
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                stmt.bindLong(3, (long)value.getReadToSegment());
                if (value.getMembership() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getMembership());
                }
                Integer n = value.isMuted() == null ? null : (_tmp = Integer.valueOf(value.isMuted() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, (long)_tmp.intValue());
                }
                Integer n2 = value.isBanned() == null ? null : (_tmp_1 = Integer.valueOf(value.isBanned() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)_tmp_1.intValue());
                }
                String _tmp_2 = EkoChannelMembershipDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                String _tmp_3 = EkoChannelMembershipDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_3 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_3);
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getDisplayName());
                }
                String _tmp_4 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                String _tmp_5 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
            }
        };
        this.__deletionAdapterOfChannelMembershipEntity = new EntityDeletionOrUpdateAdapter<ChannelMembershipEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `channel_membership` WHERE `channelId` = ? AND `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelMembershipEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfChannelMembershipEntity = new EntityDeletionOrUpdateAdapter<ChannelMembershipEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `channel_membership` SET `channelId` = ?,`userId` = ?,`readToSegment` = ?,`membership` = ?,`isMuted` = ?,`isBanned` = ?,`roles` = ?,`permissions` = ?,`displayName` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `channelId` = ? AND `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ChannelMembershipEntity value) {
                Integer _tmp_1;
                Integer _tmp;
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                stmt.bindLong(3, (long)value.getReadToSegment());
                if (value.getMembership() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getMembership());
                }
                Integer n = value.isMuted() == null ? null : (_tmp = Integer.valueOf(value.isMuted() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, (long)_tmp.intValue());
                }
                Integer n2 = value.isBanned() == null ? null : (_tmp_1 = Integer.valueOf(value.isBanned() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)_tmp_1.intValue());
                }
                String _tmp_2 = EkoChannelMembershipDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                String _tmp_3 = EkoChannelMembershipDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_3 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_3);
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getDisplayName());
                }
                String _tmp_4 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                String _tmp_5 = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfUpdateMembership = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel_membership set membership = ? where channelId = ? and userId = ?";
                return "UPDATE channel_membership set membership = ? where channelId = ? and userId = ?";
            }
        };
        this.__preparedStmtOfUpdateReadToSegment = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel_membership set readToSegment = ? where channelId = ? and userId = ? and readToSegment < ?";
                return "UPDATE channel_membership set readToSegment = ? where channelId = ? and userId = ? and readToSegment < ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_membership";
                return "DELETE from channel_membership";
            }
        };
        this.__preparedStmtOfDeleteAllFromChannel = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_membership where channelId = ?";
                return "DELETE from channel_membership where channelId = ?";
            }
        };
        this.__preparedStmtOfUpdateUserImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel_membership set userId = ? where userId = ?";
                return "UPDATE channel_membership set userId = ? where userId = ?";
            }
        };
    }

    @Override
    void insertImpl(ChannelMembershipEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelMembershipEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<ChannelMembershipEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfChannelMembershipEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ChannelMembershipEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelMembershipEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<ChannelMembershipEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfChannelMembershipEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(ChannelMembershipEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfChannelMembershipEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(ChannelMembershipEntity membership) {
        this.__db.beginTransaction();
        try {
            EkoChannelMembershipDao_Impl.super.insert(membership);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<ChannelMembershipEntity> memberships) {
        this.__db.beginTransaction();
        try {
            EkoChannelMembershipDao_Impl.super.insert(memberships);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateUser(String userId) {
        this.__db.beginTransaction();
        try {
            EkoChannelMembershipDao_Impl.super.updateUser(userId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMembership(String channelId, String userId, String membership) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateMembership.acquire();
        int _argIndex = 1;
        if (membership == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, membership);
        }
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        _argIndex = 3;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateMembership.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReadToSegment(String channelId, String userId, int readToSegment) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateReadToSegment.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)readToSegment);
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        _argIndex = 3;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        _argIndex = 4;
        _stmt.bindLong(_argIndex, (long)readToSegment);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateReadToSegment.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllFromChannel(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllFromChannel.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllFromChannel.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateUserImpl(String userId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUserImpl.acquire();
        int _argIndex = 1;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUserImpl.release(_stmt);
        }
    }

    @Override
    Flowable<ChannelMembershipEntity> getByIdWithUserIdImpl(String channelId, String userId) {
        String _sql = "SELECT * from channel_membership where channelId = ? and userId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_membership where channelId = ? and userId = ? LIMIT 1", (int)2);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel_membership"}, (Callable)new Callable<ChannelMembershipEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelMembershipEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelMembershipDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ChannelMembershipEntity _result;
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readToSegment");
                    int _cursorIndexOfMembership = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership");
                    int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
                    int _cursorIndexOfIsBanned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isBanned");
                    int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"roles");
                    int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new ChannelMembershipEntity();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                        _result.setReadToSegment(_tmpReadToSegment);
                        String _tmpMembership = _cursor.isNull(_cursorIndexOfMembership) ? null : _cursor.getString(_cursorIndexOfMembership);
                        _result.setMembership(_tmpMembership);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfIsMuted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsMuted));
                        Boolean _tmpIsMuted = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        _result.setMuted(_tmpIsMuted);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsBanned));
                        Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        _result.setBanned(_tmpIsBanned);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfRoles) ? null : _cursor.getString(_cursorIndexOfRoles);
                        AmityRoles _tmpRoles = EkoChannelMembershipDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                        _result.setRoles(_tmpRoles);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                        AmityPermissions _tmpPermissions = EkoChannelMembershipDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                        _result.setPermissions(_tmpPermissions);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        _result.setDisplayName(_tmpDisplayName);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    ChannelMembershipEntity channelMembershipEntity = _result;
                    return channelMembershipEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    DataSource.Factory<Integer, ChannelMembershipEntity> getDataSource(String channelId, boolean isFilterByRoles, List<String> roles, List<String> memberships, Boolean isMuted, boolean isSortByDisplayName, boolean isSortByCreatedACS) {
        Integer _tmp;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from channel_membership where channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and membership in (");
        int _inputSize = memberships.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and isMuted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then userId in (SELECT userId from channel_role where channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and roleName in (");
        int _inputSize_1 = roles.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else userId is not null end order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then channel_membership.displayName end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then channel_membership.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then channel_membership.createdAt end desc");
        String _sql = _stringBuilder.toString();
        int _argCount = 9 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        for (String _item : memberships) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        Integer n = isMuted == null ? null : (_tmp = Integer.valueOf(isMuted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3 + _inputSize;
        int _tmp_1 = isFilterByRoles ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 4 + _inputSize;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 5 + _inputSize;
        for (String _item_1 : roles) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 5 + _inputSize + _inputSize_1;
        int _tmp_2 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 6 + _inputSize + _inputSize_1;
        int _tmp_3 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 7 + _inputSize + _inputSize_1;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 8 + _inputSize + _inputSize_1;
        int _tmp_5 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 9 + _inputSize + _inputSize_1;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return new DataSource.Factory<Integer, ChannelMembershipEntity>(){

            public LimitOffsetDataSource<ChannelMembershipEntity> create() {
                return new LimitOffsetDataSource<ChannelMembershipEntity>(EkoChannelMembershipDao_Impl.this.__db, _statement, false, true, new String[]{"channel_membership", "channel_role"}){

                    protected List<ChannelMembershipEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"channelId");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"readToSegment");
                        int _cursorIndexOfMembership = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"membership");
                        int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isMuted");
                        int _cursorIndexOfIsBanned = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isBanned");
                        int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"roles");
                        int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"permissions");
                        int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"displayName");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<ChannelMembershipEntity> _res = new ArrayList<ChannelMembershipEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            ChannelMembershipEntity _item_2 = new ChannelMembershipEntity();
                            String _tmpChannelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
                            _item_2.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            _item_2.setUserId(_tmpUserId);
                            int _tmpReadToSegment = cursor.getInt(_cursorIndexOfReadToSegment);
                            _item_2.setReadToSegment(_tmpReadToSegment);
                            String _tmpMembership = cursor.isNull(_cursorIndexOfMembership) ? null : cursor.getString(_cursorIndexOfMembership);
                            _item_2.setMembership(_tmpMembership);
                            Integer _tmp_7 = cursor.isNull(_cursorIndexOfIsMuted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsMuted));
                            Boolean _tmpIsMuted = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                            _item_2.setMuted(_tmpIsMuted);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsBanned));
                            Boolean _tmpIsBanned = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item_2.setBanned(_tmpIsBanned);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfRoles) ? null : cursor.getString(_cursorIndexOfRoles);
                            AmityRoles _tmpRoles = EkoChannelMembershipDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_9);
                            _item_2.setRoles(_tmpRoles);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfPermissions) ? null : cursor.getString(_cursorIndexOfPermissions);
                            AmityPermissions _tmpPermissions = EkoChannelMembershipDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_10);
                            _item_2.setPermissions(_tmpPermissions);
                            String _tmpDisplayName = cursor.isNull(_cursorIndexOfDisplayName) ? null : cursor.getString(_cursorIndexOfDisplayName);
                            _item_2.setDisplayName(_tmpDisplayName);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item_2.setCreatedAt(_tmpCreatedAt);
                            String _tmp_12 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                            _item_2.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item_2);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    PagingSource<Integer, ChannelMembershipEntity> getPagingSource(String channelId, boolean isFilterByRoles, List<String> roles, List<String> memberships, Boolean isMuted, boolean isSortByDisplayName, boolean isSortByCreatedACS) {
        Integer _tmp;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from channel_membership where channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and membership in (");
        int _inputSize = memberships.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and isMuted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then userId in (SELECT userId from channel_role where channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and roleName in (");
        int _inputSize_1 = roles.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else userId is not null end order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then channel_membership.displayName end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then channel_membership.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then channel_membership.createdAt end desc");
        String _sql = _stringBuilder.toString();
        int _argCount = 9 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        for (String _item : memberships) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        Integer n = isMuted == null ? null : (_tmp = Integer.valueOf(isMuted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3 + _inputSize;
        int _tmp_1 = isFilterByRoles ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 4 + _inputSize;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 5 + _inputSize;
        for (String _item_1 : roles) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 5 + _inputSize + _inputSize_1;
        int _tmp_2 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 6 + _inputSize + _inputSize_1;
        int _tmp_3 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 7 + _inputSize + _inputSize_1;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 8 + _inputSize + _inputSize_1;
        int _tmp_5 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 9 + _inputSize + _inputSize_1;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return (PagingSource)new DataSource.Factory<Integer, ChannelMembershipEntity>(){

            public LimitOffsetDataSource<ChannelMembershipEntity> create() {
                return new LimitOffsetDataSource<ChannelMembershipEntity>(EkoChannelMembershipDao_Impl.this.__db, _statement, false, false, new String[]{"channel_membership", "channel_role"}){

                    protected List<ChannelMembershipEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"channelId");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"readToSegment");
                        int _cursorIndexOfMembership = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"membership");
                        int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isMuted");
                        int _cursorIndexOfIsBanned = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isBanned");
                        int _cursorIndexOfRoles = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"roles");
                        int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"permissions");
                        int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"displayName");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<ChannelMembershipEntity> _res = new ArrayList<ChannelMembershipEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            ChannelMembershipEntity _item_2 = new ChannelMembershipEntity();
                            String _tmpChannelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
                            _item_2.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            _item_2.setUserId(_tmpUserId);
                            int _tmpReadToSegment = cursor.getInt(_cursorIndexOfReadToSegment);
                            _item_2.setReadToSegment(_tmpReadToSegment);
                            String _tmpMembership = cursor.isNull(_cursorIndexOfMembership) ? null : cursor.getString(_cursorIndexOfMembership);
                            _item_2.setMembership(_tmpMembership);
                            Integer _tmp_7 = cursor.isNull(_cursorIndexOfIsMuted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsMuted));
                            Boolean _tmpIsMuted = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                            _item_2.setMuted(_tmpIsMuted);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsBanned) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsBanned));
                            Boolean _tmpIsBanned = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item_2.setBanned(_tmpIsBanned);
                            String _tmp_9 = cursor.isNull(_cursorIndexOfRoles) ? null : cursor.getString(_cursorIndexOfRoles);
                            AmityRoles _tmpRoles = EkoChannelMembershipDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_9);
                            _item_2.setRoles(_tmpRoles);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfPermissions) ? null : cursor.getString(_cursorIndexOfPermissions);
                            AmityPermissions _tmpPermissions = EkoChannelMembershipDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_10);
                            _item_2.setPermissions(_tmpPermissions);
                            String _tmpDisplayName = cursor.isNull(_cursorIndexOfDisplayName) ? null : cursor.getString(_cursorIndexOfDisplayName);
                            _item_2.setDisplayName(_tmpDisplayName);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item_2.setCreatedAt(_tmpCreatedAt);
                            String _tmp_12 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoChannelMembershipDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                            _item_2.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item_2);
                        }
                        return _res;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

