/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Transaction;
import androidx.room.Update;
import com.ekoapp.ekosdk.EkoObject;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;

public abstract class EkoObjectDao<EntityType extends EkoObject> {
    public EntityType getByIdNow(String id) {
        String error = String.format("%s not implemented getByIdNow() yet.", this.getClass().getName());
        throw new NotImplementedException(error);
    }

    public List<EntityType> getByIdsNow(List<String> ids) {
        return Collections.emptyList();
    }

    @Insert(onConflict=1)
    abstract void insertImpl(EntityType var1);

    @Insert(onConflict=1)
    abstract void insertImpl(List<EntityType> var1);

    @Update
    abstract void updateImpl(EntityType var1);

    @Transaction
    public void insert(EntityType object) {
        this.insertImpl(object);
    }

    @Transaction
    public void insert(List<EntityType> objects) {
        this.insertImpl(objects);
    }

    @Transaction
    public void update(EntityType object) {
        this.updateImpl(object);
    }

    public void update(List<EntityType> objects) {
        for (EkoObject object : objects) {
            this.update(object);
        }
    }

    @Delete
    public abstract void delete(EntityType var1);

    @Delete
    public abstract void delete(List<EntityType> var1);

    public abstract void deleteAll();
}

