/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk;

import com.amity.socialcloud.sdk.socket.model.SocketRequest;
import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.amity.socialcloud.sdk.streamapi.PartialStreamData;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.usecase.stream.CreateStreamSessionUseCase;
import com.ekoapp.ekosdk.internal.usecase.stream.SyncPendingSessionUseCase;
import com.ekoapp.ekosdk.internal.usecase.stream.UpdateStreamSessionUseCase;
import com.ekoapp.ekosdk.internal.usecase.stream.getStreamData;
import io.reactivex.Completable;
import io.reactivex.Single;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

public class StreamFunction
implements StreamFunctionInterface {
    @NotNull
    public Single<SocketResponse> rpc(@NotNull SocketRequest socketRequest) {
        return EkoSocket.rpc(socketRequest);
    }

    public Single<String> createStreamSession(@NotNull String streamId, @NotNull String title, @NotNull DateTime startedAt, @NotNull String resolution) {
        return new CreateStreamSessionUseCase().execute(streamId, title, startedAt, resolution);
    }

    @NotNull
    public Completable updateStreamSession(@NotNull String sessionId, @Nullable Long duration, @Nullable DateTime endedAt) {
        return new UpdateStreamSessionUseCase().execute(sessionId, duration, endedAt);
    }

    public void syncPendingSession() {
        new SyncPendingSessionUseCase().execute();
    }

    @NotNull
    public Single<PartialStreamData> getStreamData(@NotNull String streamId) {
        return new getStreamData().execute(streamId);
    }
}

