/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.GlobalPostDao;
import com.ekoapp.ekosdk.internal.entity.GlobalPostEntity;
import java.util.Collections;
import java.util.List;

public final class GlobalPostDao_Impl
extends GlobalPostDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<GlobalPostEntity> __insertionAdapterOfGlobalPostEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<GlobalPostEntity> __deletionAdapterOfGlobalPostEntity;
    private final EntityDeletionOrUpdateAdapter<GlobalPostEntity> __updateAdapterOfGlobalPostEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public GlobalPostDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGlobalPostEntity = new EntityInsertionAdapter<GlobalPostEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `global_post` (`postId`,`pageNumber`,`rank`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, GlobalPostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                stmt.bindLong(2, (long)value.getPageNumber());
                stmt.bindLong(3, (long)value.getRank());
                String _tmp = GlobalPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = GlobalPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
            }
        };
        this.__deletionAdapterOfGlobalPostEntity = new EntityDeletionOrUpdateAdapter<GlobalPostEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `global_post` WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, GlobalPostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
            }
        };
        this.__updateAdapterOfGlobalPostEntity = new EntityDeletionOrUpdateAdapter<GlobalPostEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `global_post` SET `postId` = ?,`pageNumber` = ?,`rank` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, GlobalPostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                stmt.bindLong(2, (long)value.getPageNumber());
                stmt.bindLong(3, (long)value.getRank());
                String _tmp = GlobalPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = GlobalPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                if (value.getPostId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPostId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from global_post";
                return "DELETE from global_post";
            }
        };
    }

    @Override
    public void insertImpl(GlobalPostEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGlobalPostEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends GlobalPostEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGlobalPostEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(GlobalPostEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfGlobalPostEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends GlobalPostEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfGlobalPostEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(GlobalPostEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfGlobalPostEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(GlobalPostEntity object) {
        this.__db.beginTransaction();
        try {
            GlobalPostDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends GlobalPostEntity> objects) {
        this.__db.beginTransaction();
        try {
            GlobalPostDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(GlobalPostEntity object) {
        this.__db.beginTransaction();
        try {
            GlobalPostDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHighestRank() {
        String _sql = "SELECT rank from global_post where pageNumber = 1 order by rank DESC LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT rank from global_post where pageNumber = 1 order by rank DESC LIMIT 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

