/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.converter.EkoFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoLocalFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoUserFlagDao_Impl
extends EkoUserFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoUserFlag> __insertionAdapterOfEkoUserFlag;
    private final EkoFlagTypeConverter __ekoFlagTypeConverter = new EkoFlagTypeConverter();
    private final EkoLocalFlagTypeConverter __ekoLocalFlagTypeConverter = new EkoLocalFlagTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoUserFlag> __deletionAdapterOfEkoUserFlag;
    private final EntityDeletionOrUpdateAdapter<EkoUserFlag> __updateAdapterOfEkoUserFlag;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoUserFlagDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoUserFlag = new EntityInsertionAdapter<EkoUserFlag>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user_flag` (`userId`,`flag`,`localFlag`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoUserFlag value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                String _tmp = EkoUserFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoUserFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfEkoUserFlag = new EntityDeletionOrUpdateAdapter<EkoUserFlag>(__db){

            public String createQuery() {
                return "DELETE FROM `user_flag` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoUserFlag value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfEkoUserFlag = new EntityDeletionOrUpdateAdapter<EkoUserFlag>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user_flag` SET `userId` = ?,`flag` = ?,`localFlag` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoUserFlag value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                String _tmp = EkoUserFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoUserFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user_flag";
                return "DELETE from user_flag";
            }
        };
    }

    @Override
    public void insertImpl(EkoUserFlag object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoUserFlag.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends EkoUserFlag> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoUserFlag.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoUserFlag object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoUserFlag.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends EkoUserFlag> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoUserFlag.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(EkoUserFlag object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoUserFlag.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoUserFlag object) {
        this.__db.beginTransaction();
        try {
            EkoUserFlagDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends EkoUserFlag> objects) {
        this.__db.beginTransaction();
        try {
            EkoUserFlagDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoUserFlag object) {
        this.__db.beginTransaction();
        try {
            EkoUserFlagDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoUserFlag getByIdNowImpl(String userId) {
        String _sql = "SELECT * from user_flag where userId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_flag where userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoUserFlag _result;
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flag");
            int _cursorIndexOfLocalFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localFlag");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoUserFlag();
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmp = _cursor.isNull(_cursorIndexOfFlag) ? null : _cursor.getString(_cursorIndexOfFlag);
                EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                _result.setFlag(_tmpFlag);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLocalFlag) ? null : _cursor.getString(_cursorIndexOfLocalFlag);
                EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                _result.setLocalFlag(_tmpLocalFlag);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            EkoUserFlag ekoUserFlag = _result;
            return ekoUserFlag;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<EkoUserFlag> getByIdImpl(String userId) {
        String _sql = "SELECT * from user_flag where userId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from user_flag where userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_flag"}, (Callable)new Callable<EkoUserFlag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoUserFlag call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoUserFlagDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoUserFlag _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flag");
                    int _cursorIndexOfLocalFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localFlag");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoUserFlag();
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmp = _cursor.isNull(_cursorIndexOfFlag) ? null : _cursor.getString(_cursorIndexOfFlag);
                        EkoFlag _tmpFlag = EkoUserFlagDao_Impl.this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                        _result.setFlag(_tmpFlag);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfLocalFlag) ? null : _cursor.getString(_cursorIndexOfLocalFlag);
                        EkoLocalFlag _tmpLocalFlag = EkoUserFlagDao_Impl.this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                        _result.setLocalFlag(_tmpLocalFlag);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoUserFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoUserFlag ekoUserFlag = _result;
                    return ekoUserFlag;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

