/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoFeedDao;
import com.ekoapp.ekosdk.internal.entity.FeedEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoFeedDao_Impl
extends EkoFeedDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<FeedEntity> __insertionAdapterOfFeedEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<FeedEntity> __deletionAdapterOfFeedEntity;
    private final EntityDeletionOrUpdateAdapter<FeedEntity> __updateAdapterOfFeedEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoFeedDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfFeedEntity = new EntityInsertionAdapter<FeedEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `feed` (`feedId`,`feedType`,`targetId`,`targetType`,`postCount`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, FeedEntity value) {
                if (value.getFeedId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFeedId());
                }
                if (value.getFeedType() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFeedType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTargetType());
                }
                stmt.bindLong(5, (long)value.getPostCount());
                String _tmp = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                String _tmp_1 = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
            }
        };
        this.__deletionAdapterOfFeedEntity = new EntityDeletionOrUpdateAdapter<FeedEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `feed` WHERE `feedId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FeedEntity value) {
                if (value.getFeedId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFeedId());
                }
            }
        };
        this.__updateAdapterOfFeedEntity = new EntityDeletionOrUpdateAdapter<FeedEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `feed` SET `feedId` = ?,`feedType` = ?,`targetId` = ?,`targetType` = ?,`postCount` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `feedId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, FeedEntity value) {
                if (value.getFeedId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFeedId());
                }
                if (value.getFeedType() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFeedType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTargetType());
                }
                stmt.bindLong(5, (long)value.getPostCount());
                String _tmp = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                String _tmp_1 = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                if (value.getFeedId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getFeedId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from feed";
                return "DELETE from feed";
            }
        };
    }

    @Override
    public void insertImpl(FeedEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfFeedEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends FeedEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfFeedEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(FeedEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFeedEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends FeedEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFeedEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(FeedEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfFeedEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(FeedEntity object) {
        this.__db.beginTransaction();
        try {
            EkoFeedDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends FeedEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoFeedDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(FeedEntity object) {
        this.__db.beginTransaction();
        try {
            EkoFeedDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    FeedEntity getByIdNowImpl(String feedId) {
        String _sql = "SELECT * from feed where feed.feedId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from feed where feed.feedId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (feedId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            FeedEntity _result;
            int _cursorIndexOfFeedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedId");
            int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfPostCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postCount");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new FeedEntity();
                String _tmpFeedId = _cursor.isNull(_cursorIndexOfFeedId) ? null : _cursor.getString(_cursorIndexOfFeedId);
                _result.setFeedId(_tmpFeedId);
                String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                _result.setFeedType(_tmpFeedType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                int _tmpPostCount = _cursor.getInt(_cursorIndexOfPostCount);
                _result.setPostCount(_tmpPostCount);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            FeedEntity feedEntity = _result;
            return feedEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<FeedEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from feed where feed.feedId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfFeedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedId");
            int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfPostCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postCount");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            ArrayList<FeedEntity> _result = new ArrayList<FeedEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                FeedEntity _item_1 = new FeedEntity();
                String _tmpFeedId = _cursor.isNull(_cursorIndexOfFeedId) ? null : _cursor.getString(_cursorIndexOfFeedId);
                _item_1.setFeedId(_tmpFeedId);
                String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                _item_1.setFeedType(_tmpFeedType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _item_1.setTargetId(_tmpTargetId);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _item_1.setTargetType(_tmpTargetType);
                int _tmpPostCount = _cursor.getInt(_cursorIndexOfPostCount);
                _item_1.setPostCount(_tmpPostCount);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item_1);
            }
            ArrayList<FeedEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<FeedEntity> getCommunityFeedImpl(String targetId, String feedType) {
        String _sql = "SELECT * from feed where feed.targetId = ? and feed.feedType = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from feed where feed.targetId = ? and feed.feedType = ?", (int)2);
        int _argIndex = 1;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        _argIndex = 2;
        if (feedType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, feedType);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"feed"}, (Callable)new Callable<FeedEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FeedEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoFeedDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    FeedEntity _result;
                    int _cursorIndexOfFeedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedId");
                    int _cursorIndexOfFeedType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"feedType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfPostCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"postCount");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new FeedEntity();
                        String _tmpFeedId = _cursor.isNull(_cursorIndexOfFeedId) ? null : _cursor.getString(_cursorIndexOfFeedId);
                        _result.setFeedId(_tmpFeedId);
                        String _tmpFeedType = _cursor.isNull(_cursorIndexOfFeedType) ? null : _cursor.getString(_cursorIndexOfFeedType);
                        _result.setFeedType(_tmpFeedType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        int _tmpPostCount = _cursor.getInt(_cursorIndexOfPostCount);
                        _result.setPostCount(_tmpPostCount);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoFeedDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoFeedDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    FeedEntity feedEntity = _result;
                    return feedEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

