/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.notification;

import com.amity.socialcloud.sdk.socket.AmitySocketException;
import com.amity.socialcloud.sdk.socket.model.SocketRequest;
import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.ekoapp.core.utils.UtilsKt;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.ResponseConverter;
import com.ekoapp.ekosdk.internal.repository.notification.NotificationContract;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import io.reactivex.Completable;
import io.reactivex.Single;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/notification/BaseNotificationRepository;", "Lcom/ekoapp/ekosdk/internal/repository/notification/NotificationContract;", "()V", "isAllowed", "Lio/reactivex/Single;", "", "request", "Lcom/amity/socialcloud/sdk/socket/model/SocketRequest;", "channelId", "", "setAllowed", "Lio/reactivex/Completable;", "allowed", "LEVEL", "amity-sdk_release"})
public abstract class BaseNotificationRepository
implements NotificationContract {
    @Override
    @NotNull
    public Single<Boolean> isAllowed() {
        String string = "default implementation";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Single<Boolean> isAllowed(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String string = "default implementation";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Completable setAllowed(boolean allowed) {
        String string = "default implementation";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Completable setAllowed(@NotNull String channelId, boolean allowed) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String string = "default implementation";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public final Completable setAllowed(@NotNull SocketRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Completable completable = EkoSocket.rpc(request2).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.rpc(request)\n \u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Single<Boolean> isAllowed(@NotNull SocketRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Single single = EkoSocket.call(Call.create(request2, new ResponseConverter<Boolean>(request2){
            final /* synthetic */ SocketRequest $request;

            public final Boolean convert(@NotNull SocketResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.isSuccess()) {
                    JsonElement jsonElement = response.getData().get("isPushNotifiable");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"response.data[\"isPushNotifiable\"]");
                    return jsonElement.getAsBoolean();
                }
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "error: request %s response: %s";
                Object[] objectArray = new Object[]{this.$request, response};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                String error = string2;
                AmitySocketException e = AmitySocketException.Companion.create(error, response);
                Timber.e((String)UtilsKt.getCurrentClassAndMethodNames(), (Object[])new Object[]{e});
                throw (Throwable)new IOException(e);
            }
            {
                this.$request = socketRequest;
            }
        }));
        Intrinsics.checkNotNullExpressionValue(single, (String)"EkoSocket.call(Call.crea\u2026\n            }\n        })");
        return single;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/notification/BaseNotificationRepository$LEVEL;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "CHANNEL", "COMMUNITY", "USER", "amity-sdk_release"})
    public static final class LEVEL
    extends Enum<LEVEL> {
        @SerializedName(value="channel")
        public static final /* enum */ LEVEL CHANNEL;
        @SerializedName(value="community")
        public static final /* enum */ LEVEL COMMUNITY;
        @SerializedName(value="user")
        public static final /* enum */ LEVEL USER;
        private static final /* synthetic */ LEVEL[] $VALUES;
        @NotNull
        private final String value;

        static {
            LEVEL[] lEVELArray = new LEVEL[3];
            LEVEL[] lEVELArray2 = lEVELArray;
            lEVELArray[0] = CHANNEL = new LEVEL("channel");
            lEVELArray[1] = COMMUNITY = new LEVEL("community");
            lEVELArray[2] = USER = new LEVEL("user");
            $VALUES = lEVELArray;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        private LEVEL(String value) {
            this.value = value;
        }

        public static LEVEL[] values() {
            return (LEVEL[])$VALUES.clone();
        }

        public static LEVEL valueOf(String string) {
            return Enum.valueOf(LEVEL.class, string);
        }
    }
}

