/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.user;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatus;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoAccountCache;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\u0006J\u0014\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\tJ\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\tJ\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\t\u00a8\u0006 "}, d2={"Lcom/amity/socialcloud/sdk/core/data/user/UserLocalDataStore;", "", "()V", "getFollowCountByIdNow", "Lcom/ekoapp/ekosdk/internal/data/model/EkoFollowCountEntity;", "userId", "", "getFollowersPagingSource", "Landroidx/paging/PagingSource;", "", "Lcom/ekoapp/ekosdk/internal/data/model/EkoUserFollowStatusEntity;", "filter", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowStatusFilter;", "getFollowingsPagingSource", "getLatestFollower", "Lio/reactivex/Flowable;", "getLatestFollowing", "getMyUserId", "saveUsers", "Lio/reactivex/Completable;", "users", "", "Lcom/ekoapp/ekosdk/UserEntity;", "updateFollower", "", "status", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowStatus;", "updateFollowerCount", "followerCount", "updateFollowing", "updateFollowingCount", "updatePendingCount", "amity-sdk_release"})
public final class UserLocalDataStore {
    @NotNull
    public final Completable saveUsers(@NotNull List<? extends UserEntity> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Completable completable = Completable.fromAction((Action)new Action(users){
            final /* synthetic */ List $users;

            public final void run() {
                UserDatabase.get().userDao().save(this.$users);
            }
            {
                this.$users = list;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026).userDao().save(users) }");
        return completable;
    }

    @NotNull
    public final String getMyUserId() {
        Object object = EkoAccountCache.getMyUserId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EkoAccountCache.getMyUserId().get()");
        return (String)object;
    }

    @NotNull
    public final PagingSource<Integer, EkoUserFollowStatusEntity> getFollowingsPagingSource(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        return UserDatabase.get().followingPagingDao().getFollowingPagingSource(userId, filter);
    }

    @NotNull
    public final PagingSource<Integer, EkoUserFollowStatusEntity> getFollowersPagingSource(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        return UserDatabase.get().followingPagingDao().getFollowerPagingSource(userId, filter);
    }

    @NotNull
    public final Flowable<EkoUserFollowStatusEntity> getLatestFollowing(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable<EkoUserFollowStatusEntity> flowable = UserDatabase.get().followDao().getLatestFollowing(userId, filter.getStatuses());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"UserDatabase.get().follo\u2026(userId, filter.statuses)");
        return flowable;
    }

    @NotNull
    public final Flowable<EkoUserFollowStatusEntity> getLatestFollower(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable<EkoUserFollowStatusEntity> flowable = UserDatabase.get().followDao().getLatestFollower(userId, filter.getStatuses());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"UserDatabase.get().follo\u2026(userId, filter.statuses)");
        return flowable;
    }

    public final void updateFollower(@NotNull String userId, @NotNull AmityFollowStatus status) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        UserDatabase.get().followDao().updateFollower(userId, status.getApiKey());
    }

    public final void updateFollowing(@NotNull String userId, @NotNull AmityFollowStatus status) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        UserDatabase.get().followDao().updateFollowing(userId, status.getApiKey());
    }

    @NotNull
    public final EkoFollowCountEntity getFollowCountByIdNow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        EkoFollowCountEntity ekoFollowCountEntity = UserDatabase.get().followCountDao().getByIdNow(userId);
        Intrinsics.checkNotNullExpressionValue((Object)ekoFollowCountEntity, (String)"UserDatabase.get().follo\u2026tDao().getByIdNow(userId)");
        return ekoFollowCountEntity;
    }

    public final void updateFollowerCount(@NotNull String userId, int followerCount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followCountDao().updateFollowerCount(userId, followerCount);
    }

    public final void updatePendingCount(@NotNull String userId, int followerCount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followCountDao().updatePendingCount(userId, followerCount);
    }

    public final void updateFollowingCount(@NotNull String userId, int followerCount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followCountDao().updateFollowingCount(userId, followerCount);
    }
}

