/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.channel.membership;

import androidx.paging.DataSource;
import androidx.paging.PagedList;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.chat.channel.AmityChannel;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMember;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipFilter;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipPrivileges;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipSortOption;
import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipComposerFunction;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipMediator;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipModelMapper;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipQueryPersister;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository;
import com.amity.socialcloud.sdk.chat.data.channel.reader.ChannelReaderLocalDataStore;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.core.user.AmityMembershipType;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.ChannelMembershipQueryDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoChannelMembershipBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Duration;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u001c\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ2\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J2\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00190\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u001a\u001a\u00020\u001bH\u0002J>\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010#\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007J\u0016\u0010%\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'J$\u0010(\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b/J\"\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ2\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00190\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0007J$\u00102\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u001c\u00103\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u000e\u00104\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u00105\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a8\u00066"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/channel/membership/ChannelMembershipRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "addChannelMembers", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannel;", "channelId", "", "userIds", "", "assignChannelRole", "Lio/reactivex/rxjava3/core/Completable;", "role", "banChannelUsers", "getChannelMembershipPagedList", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagedList;", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMember;", "roles", "Lcom/amity/socialcloud/sdk/core/permission/AmityRoles;", "filter", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMembershipFilter;", "sortOption", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMembershipSortOption;", "getChannelMembershipPagingData", "Landroidx/paging/PagingData;", "getDefaultPageSize", "", "getLatestChannel", "keyword", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "getPrivileges", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMembershipPrivileges;", "handleMembershipBanned", "userId", "muteChannel", "timeout", "Lorg/joda/time/Duration;", "muteChannelUsers", "observeChannelMember", "persistAndReturnChannel", "dto", "Lcom/ekoapp/ekosdk/internal/api/dto/ChannelMembershipQueryDto;", "persistAndReturnChannel$amity_sdk_release", "persistChannelMemberships", "persistChannelMemberships$amity_sdk_release", "removeChannelMembers", "searchChannelMembershipPagingData", "unassignChannelRole", "unbanChannelUsers", "unmuteChannel", "unmuteChannelUsers", "amity-sdk_release"})
public final class ChannelMembershipRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<AmityChannelMember> observeChannelMember(@NotNull String channelId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Flowable flowable = new ChannelMembershipLocalDataStore().observeChannelMember(channelId, userId).map((Function)observeChannelMember.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ChannelMembershipLocalDa\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Single<AmityChannel> addChannelMembers(@NotNull String channelId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Single single = new ChannelMembershipRemoteDataStore().addChannelMembers(channelId, userIds).flatMap((Function)new Function<ChannelMembershipQueryDto, SingleSource<? extends AmityChannel>>(this){
            final /* synthetic */ ChannelMembershipRepository this$0;

            public final SingleSource<? extends AmityChannel> apply(ChannelMembershipQueryDto it) {
                ChannelMembershipQueryDto channelMembershipQueryDto = it;
                Intrinsics.checkNotNullExpressionValue((Object)channelMembershipQueryDto, (String)"it");
                return (SingleSource)this.this$0.persistAndReturnChannel$amity_sdk_release(channelMembershipQueryDto);
            }
            {
                this.this$0 = channelMembershipRepository;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"ChannelMembershipRemoteD\u2026Channel(it)\n            }");
        return single;
    }

    @NotNull
    public final Single<AmityChannel> removeChannelMembers(@NotNull String channelId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Single single = new ChannelMembershipRemoteDataStore().removeChannelMembers(channelId, userIds).flatMap((Function)new Function<ChannelMembershipQueryDto, SingleSource<? extends AmityChannel>>(this){
            final /* synthetic */ ChannelMembershipRepository this$0;

            public final SingleSource<? extends AmityChannel> apply(ChannelMembershipQueryDto it) {
                ChannelMembershipQueryDto channelMembershipQueryDto = it;
                Intrinsics.checkNotNullExpressionValue((Object)channelMembershipQueryDto, (String)"it");
                return (SingleSource)this.this$0.persistAndReturnChannel$amity_sdk_release(channelMembershipQueryDto);
            }
            {
                this.this$0 = channelMembershipRepository;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"ChannelMembershipRemoteD\u2026Channel(it)\n            }");
        return single;
    }

    @NotNull
    public final Flowable<PagedList<AmityChannelMember>> getChannelMembershipPagedList(@NotNull String channelId, @NotNull AmityRoles roles, @NotNull AmityChannelMembershipFilter filter, @NotNull AmityChannelMembershipSortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        EkoChannelMembershipDao channelMembershipDao = UserDatabase.get().channelMembershipDao();
        DataSource.Factory<Integer, ChannelMembershipEntity> factory2 = channelMembershipDao.getDataSource(channelId, roles, filter.getMemberships(), filter.isMuted(), sortOption);
        int n = 15;
        AmityChannelMembershipFilter amityChannelMembershipFilter = filter;
        AmityChannelMembershipSortOption amityChannelMembershipSortOption = sortOption;
        return RxJava3BridgeExtensionsKt.toV3(this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)new ChannelMembershipComposerFunction()), new EkoChannelMembershipBoundaryCallback(channelId, roles, amityChannelMembershipFilter, amityChannelMembershipSortOption, n)));
    }

    @NotNull
    public final Flowable<PagingData<AmityChannelMember>> getChannelMembershipPagingData(@NotNull String channelId, @NotNull AmityChannelMembershipFilter filter, @NotNull AmityRoles roles, @NotNull AmityChannelMembershipSortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        AmityChannelMembershipSortOption amityChannelMembershipSortOption = sortOption;
        AmityChannelMembershipFilter amityChannelMembershipFilter = filter;
        AmityRoles amityRoles = roles;
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, true, 0, 0, 0, 58, null), null, new ChannelMembershipMediator(channelId, null, amityChannelMembershipFilter, amityRoles, amityChannelMembershipSortOption), (Function0)new Function0<PagingSource<Integer, ChannelMembershipEntity>>(channelId, roles, filter, sortOption){
            final /* synthetic */ String $channelId;
            final /* synthetic */ AmityRoles $roles;
            final /* synthetic */ AmityChannelMembershipFilter $filter;
            final /* synthetic */ AmityChannelMembershipSortOption $sortOption;

            @NotNull
            public final PagingSource<Integer, ChannelMembershipEntity> invoke() {
                return new ChannelMembershipLocalDataStore().getChannelMembershipPagingSource(this.$channelId, null, this.$roles, this.$filter, this.$sortOption);
            }
            {
                this.$channelId = string;
                this.$roles = amityRoles;
                this.$filter = amityChannelMembershipFilter;
                this.$sortOption = amityChannelMembershipSortOption;
                super(0);
            }
        }, (ModelMapper)new ChannelMembershipModelMapper(), 2, null);
        return RxJava3BridgeExtensionsKt.toV3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<PagingData<AmityChannelMember>> searchChannelMembershipPagingData(@NotNull String channelId, @NotNull AmityChannelMembershipFilter filter, @NotNull AmityRoles roles, @NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        AmityChannelMembershipSortOption amityChannelMembershipSortOption = null;
        AmityChannelMembershipFilter amityChannelMembershipFilter = filter;
        AmityRoles amityRoles = roles;
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, true, 0, 0, 0, 58, null), null, new ChannelMembershipMediator(channelId, keyword, amityChannelMembershipFilter, amityRoles, amityChannelMembershipSortOption), (Function0)new Function0<PagingSource<Integer, ChannelMembershipEntity>>(channelId, keyword, roles, filter){
            final /* synthetic */ String $channelId;
            final /* synthetic */ String $keyword;
            final /* synthetic */ AmityRoles $roles;
            final /* synthetic */ AmityChannelMembershipFilter $filter;

            @NotNull
            public final PagingSource<Integer, ChannelMembershipEntity> invoke() {
                return new ChannelMembershipLocalDataStore().getChannelMembershipPagingSource(this.$channelId, this.$keyword, this.$roles, this.$filter, null);
            }
            {
                this.$channelId = string;
                this.$keyword = string2;
                this.$roles = amityRoles;
                this.$filter = amityChannelMembershipFilter;
                super(0);
            }
        }, (ModelMapper)new ChannelMembershipModelMapper(), 2, null);
        return RxJava3BridgeExtensionsKt.toV3(pagerCreator2.create());
    }

    @NotNull
    public final Completable assignChannelRole(@NotNull String channelId, @NotNull String role, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Completable completable = new ChannelMembershipRemoteDataStore().assignChannelRole(channelId, role, userIds).flatMapCompletable((Function)new Function<ChannelMembershipQueryDto, CompletableSource>(this){
            final /* synthetic */ ChannelMembershipRepository this$0;

            public final CompletableSource apply(ChannelMembershipQueryDto it) {
                ChannelMembershipQueryDto channelMembershipQueryDto = it;
                Intrinsics.checkNotNullExpressionValue((Object)channelMembershipQueryDto, (String)"it");
                return (CompletableSource)this.this$0.persistChannelMemberships$amity_sdk_release(channelMembershipQueryDto);
            }
            {
                this.this$0 = channelMembershipRepository;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ChannelMembershipRemoteD\u2026erships(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable unassignChannelRole(@NotNull String channelId, @NotNull String role, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Completable completable = new ChannelMembershipRemoteDataStore().unassignChannelRole(channelId, role, userIds).flatMapCompletable((Function)new Function<ChannelMembershipQueryDto, CompletableSource>(this){
            final /* synthetic */ ChannelMembershipRepository this$0;

            public final CompletableSource apply(ChannelMembershipQueryDto it) {
                ChannelMembershipQueryDto channelMembershipQueryDto = it;
                Intrinsics.checkNotNullExpressionValue((Object)channelMembershipQueryDto, (String)"it");
                return (CompletableSource)this.this$0.persistChannelMemberships$amity_sdk_release(channelMembershipQueryDto);
            }
            {
                this.this$0 = channelMembershipRepository;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ChannelMembershipRemoteD\u2026erships(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable banChannelUsers(@NotNull String channelId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Completable completable = new ChannelMembershipRemoteDataStore().banChannelMembers(channelId, userIds).flatMapCompletable((Function)new Function<ChannelMembershipQueryDto, CompletableSource>(this){
            final /* synthetic */ ChannelMembershipRepository this$0;

            public final CompletableSource apply(ChannelMembershipQueryDto it) {
                ChannelMembershipQueryDto channelMembershipQueryDto = it;
                Intrinsics.checkNotNullExpressionValue((Object)channelMembershipQueryDto, (String)"it");
                return (CompletableSource)this.this$0.persistChannelMemberships$amity_sdk_release(channelMembershipQueryDto);
            }
            {
                this.this$0 = channelMembershipRepository;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ChannelMembershipRemoteD\u2026erships(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable unbanChannelUsers(@NotNull String channelId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Completable completable = new ChannelMembershipRemoteDataStore().unbanChannelMembers(channelId, userIds).flatMapCompletable((Function)new Function<ChannelMembershipQueryDto, CompletableSource>(this){
            final /* synthetic */ ChannelMembershipRepository this$0;

            public final CompletableSource apply(ChannelMembershipQueryDto it) {
                ChannelMembershipQueryDto channelMembershipQueryDto = it;
                Intrinsics.checkNotNullExpressionValue((Object)channelMembershipQueryDto, (String)"it");
                return (CompletableSource)this.this$0.persistChannelMemberships$amity_sdk_release(channelMembershipQueryDto);
            }
            {
                this.this$0 = channelMembershipRepository;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ChannelMembershipRemoteD\u2026erships(it)\n            }");
        return completable;
    }

    @NotNull
    public final Completable muteChannelUsers(@NotNull String channelId, @NotNull Duration timeout, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new ChannelMembershipRemoteDataStore().muteChannelMembers(channelId, timeout, userIds);
    }

    @NotNull
    public final Completable unmuteChannelUsers(@NotNull String channelId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ZERO");
        return this.muteChannelUsers(channelId, duration, userIds);
    }

    @NotNull
    public final Completable muteChannel(@NotNull String channelId, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        return new ChannelMembershipRemoteDataStore().muteChannel(channelId, timeout);
    }

    @NotNull
    public final Completable unmuteChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ZERO");
        return this.muteChannel(channelId, duration);
    }

    @NotNull
    public final Completable handleMembershipBanned(@NotNull String channelId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(userId, channelId){
            final /* synthetic */ String $userId;
            final /* synthetic */ String $channelId;

            public final void run() {
                if (Intrinsics.areEqual((Object)new UserLocalDataStore().getMyUserId(), (Object)this.$userId)) {
                    new ChannelReaderLocalDataStore().stopReading(this.$channelId);
                }
                new ChannelMembershipLocalDataStore().updateMembership(this.$channelId, this.$userId, AmityMembershipType.BANNED);
                UserDatabase.get().messageDao().softDeleteFromChannelByUserId(this.$channelId, this.$userId);
            }
            {
                this.$userId = string;
                this.$channelId = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026nnelId, userId)\n        }");
        return completable;
    }

    @NotNull
    public final Single<AmityChannelMembershipPrivileges> getPrivileges(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Single single = new ChannelMembershipRemoteDataStore().getPrivileges(channelId).map((Function)getPrivileges.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"ChannelMembershipRemoteD\u2026 it.results\n            }");
        return single;
    }

    @NotNull
    public final Flowable<AmityChannelMember> getLatestChannel(@NotNull String channelId, @Nullable String keyword, @NotNull AmityChannelMembershipFilter filter, @NotNull AmityRoles roles, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        int n = nonce;
        DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator2 = dynamicQueryStreamKeyCreator;
        AmityChannelMembershipFilter amityChannelMembershipFilter = filter;
        AmityRoles amityRoles = roles;
        Flowable flowable = new ChannelMembershipLocalDataStore().getLatestChannel(channelId, keyword, amityChannelMembershipFilter, amityRoles, dynamicQueryStreamKeyCreator2, n).map((Function)getLatestChannel.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ChannelMembershipLocalDa\u2026r().map(it)\n            }");
        return flowable;
    }

    @NotNull
    public final Completable persistChannelMemberships$amity_sdk_release(@NotNull ChannelMembershipQueryDto dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        return new ChannelMembershipQueryPersister().persist(dto);
    }

    @NotNull
    public final Single<AmityChannel> persistAndReturnChannel$amity_sdk_release(@NotNull ChannelMembershipQueryDto dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Completable completable = this.persistChannelMemberships$amity_sdk_release(dto);
        ChannelRepository channelRepository = new ChannelRepository();
        List<EkoChannelDto> list = dto.getChannelDtoList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"dto.channelDtoList");
        Object object = CollectionsKt.first(list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dto.channelDtoList.first()");
        String string = ((EkoChannelDto)object).getChannelId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dto.channelDtoList.first().channelId");
        Single single = completable.andThen((SingleSource)channelRepository.getChannel$amity_sdk_release(string));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"persistChannelMembership\u2026oList.first().channelId))");
        return single;
    }
}

