/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommentMapper;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectPersister;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.google.common.collect.FluentIterable;
import java.util.List;

class EkoCommentListPersister
extends EkoObjectPersister {
    EkoCommentListPersister() {
    }

    static void persist(List<EkoCommentDto> dtoList) {
        UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(() -> {
            EkoCommentListPersister.persistChanges(dtoList, EkoCommentMapper.MAPPER, userDatabase.commentDao());
            EkoCommentFlagDao flagDao = userDatabase.commentFlagDao();
            for (EkoCommentDto commentDto : dtoList) {
                if (commentDto.getMyReactions() != null) {
                    EkoReactionDao reactionDao = userDatabase.reactionDao();
                    reactionDao.deleteByReferenceIdAndUserId(commentDto.getCommentId(), ReactionReferenceType.COMMENT.getValue(), AmityCoreClient.INSTANCE.getUserId());
                    reactionDao.insert(FluentIterable.from(commentDto.getMyReactions()).transform(reactionName -> EkoReactionEntity.createMyReaction(ReactionReferenceType.COMMENT, commentDto.getCommentId(), reactionName)).toList());
                }
                EkoCommentFlagEntity commentFlag = new EkoCommentFlagEntity();
                commentFlag.setCommentId(commentDto.getCommentId());
                commentFlag.setFlag(commentDto.getFlag());
                EkoCommentFlagEntity diskFlag = flagDao.getByIdNow(commentDto.getCommentId());
                if (diskFlag != null) {
                    commentFlag.setLocalFlag(diskFlag.getLocalFlag());
                    flagDao.update(commentFlag);
                    continue;
                }
                flagDao.insert(commentFlag);
            }
        });
    }
}

