/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.file;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import co.amity.rxupload.FileProperties;
import co.amity.rxupload.extension.UriKt;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.core.file.AmityFileInfo;
import com.amity.socialcloud.sdk.core.file.AmityImage;
import com.amity.socialcloud.sdk.core.file.AmityImageUploadService;
import com.amity.socialcloud.sdk.core.file.AmityUploadInfo;
import com.amity.socialcloud.sdk.core.file.AmityUploadResult;
import com.amity.socialcloud.sdk.core.file.AmityUploadService;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.ekoapp.ekosdk.internal.util.AppContext;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import timber.log.Timber;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001eB!\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0014\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0014H\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/amity/socialcloud/sdk/core/file/AmityImageUploadService;", "Lcom/amity/socialcloud/sdk/core/file/AmityUploadService;", "Lcom/amity/socialcloud/sdk/core/file/AmityUploadResult;", "Lcom/amity/socialcloud/sdk/core/file/AmityImage;", "uri", "Landroid/net/Uri;", "uploadId", "", "isFullImage", "", "(Landroid/net/Uri;Ljava/lang/String;Z)V", "deleteFile", "", "file", "Ljava/io/File;", "getUploadHeaders", "", "", "getUploadParams", "makeUploadServiceRequest", "Lio/reactivex/Flowable;", "rewriteImageFile", "Lio/reactivex/Single;", "context", "Landroid/content/Context;", "fileUri", "saveMediaToCache", "bitmap", "Landroid/graphics/Bitmap;", "uploadContentUri", "Builder", "amity-sdk_release"})
public final class AmityImageUploadService
extends AmityUploadService<AmityUploadResult<? extends AmityImage>> {
    private final Uri uri;
    private final String uploadId;
    private final boolean isFullImage;

    @Override
    @NotNull
    public Map<String, Object> getUploadParams() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"isFullImage", (Object)this.isFullImage));
    }

    @Override
    @NotNull
    public Map<String, Object> getUploadHeaders() {
        boolean bl = false;
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    protected Flowable<AmityUploadResult<AmityImage>> makeUploadServiceRequest() {
        return this.uploadContentUri(this.uri);
    }

    private final Flowable<AmityUploadResult<AmityImage>> uploadContentUri(Uri uri) {
        Context context = AppContext.get();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"AppContext.get()");
        Flowable flowable = this.rewriteImageFile(context, uri).flatMapPublisher((Function)new Function<File, Publisher<? extends AmityUploadResult<? extends AmityImage>>>(this){
            final /* synthetic */ AmityImageUploadService this$0;

            public final Publisher<? extends AmityUploadResult<AmityImage>> apply(@NotNull File file) {
                Uri bitmapUri;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Uri uri = bitmapUri = Uri.fromFile((File)file);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"bitmapUri");
                Context context = AppContext.get();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"AppContext.get()");
                String string = null;
                String string2 = AmityImageUploadService.access$getUploadId$p(this.this$0);
                Map<String, Object> map = this.this$0.getUploadHeaders();
                Map<String, Object> map2 = this.this$0.getUploadParams();
                return (Publisher)UriKt.upload$default((Uri)uri, (Context)context, (String)"api/v3/files", map, map2, (String)string2, string, (int)32, null).flatMap((Function)new Function<FileProperties, Publisher<? extends AmityUploadResult<? extends AmityImage>>>(this, file){
                    final /* synthetic */ uploadContentUri.1 this$0;
                    final /* synthetic */ File $file;

                    public final Publisher<? extends AmityUploadResult<AmityImage>> apply(@NotNull FileProperties it) {
                        Flowable flowable;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (it.getProgress() == 100) {
                            AmityImageUploadService amityImageUploadService = this.this$0.this$0;
                            File file = this.$file;
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                            AmityImageUploadService.access$deleteFile(amityImageUploadService, file);
                            Flowable flowable2 = Completable.fromCallable((Callable)new Callable<Object>(this, it){
                                final /* synthetic */ uploadContentUri.1 this$0;
                                final /* synthetic */ FileProperties $it;

                                public final void call() {
                                    EkoFileEntity fileEntity = this.this$0.this$0.this$0.parseEkoFileEntity(this.$it.getResponseBody());
                                    EkoFileDao fileDao = UserDatabase.get().fileDao();
                                    fileEntity.setFilePath(this.$it.getUri().getPath());
                                    fileDao.insert((EkoObject)fileEntity);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$it = fileProperties;
                                }
                            }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).andThen((Publisher)Flowable.just(new AmityUploadResult.COMPLETE<AmityFileInfo>(new AmityImage(it))));
                            flowable = flowable2;
                            Intrinsics.checkNotNullExpressionValue((Object)flowable2, (String)"Completable.fromCallable\u2026OMPLETE(AmityImage(it))))");
                        } else {
                            Flowable flowable3 = Flowable.just((Object)new AmityUploadResult.PROGRESS(new AmityUploadInfo(it)));
                            flowable = flowable3;
                            Intrinsics.checkNotNullExpressionValue((Object)flowable3, (String)"Flowable.just(AmityUploa\u2026ESS(AmityUploadInfo(it)))");
                        }
                        return (Publisher)flowable;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$file = file;
                    }
                }).onErrorReturn((Function)new Function<Throwable, AmityUploadResult<? extends AmityImage>>(this, file){
                    final /* synthetic */ uploadContentUri.1 this$0;
                    final /* synthetic */ File $file;

                    public final AmityUploadResult<AmityImage> apply(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        AmityException exception = this.this$0.this$0.parseErrorResponse(it.getMessage());
                        AmityImageUploadService amityImageUploadService = this.this$0.this$0;
                        File file = this.$file;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                        AmityImageUploadService.access$deleteFile(amityImageUploadService, file);
                        return new AmityUploadResult.ERROR(exception);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$file = file;
                    }
                });
            }
            {
                this.this$0 = amityImageUploadService;
            }
        }).onErrorReturn((Function)uploadContentUri.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"rewriteImageFile(AppCont\u2026(exception)\n            }");
        return flowable;
    }

    private final Single<File> rewriteImageFile(Context context, Uri fileUri) {
        Single single = Single.create((SingleOnSubscribe)((SingleOnSubscribe)new SingleOnSubscribe<File>(fileUri, context){
            final /* synthetic */ Uri $fileUri;
            final /* synthetic */ Context $context;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void subscribe(@NotNull SingleEmitter<File> emitter) {
                Intrinsics.checkNotNullParameter(emitter, (String)"emitter");
                Uri uri = this.$fileUri;
                if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content") ^ true) {
                    File file = new File(uri.getPath());
                    Context context = AppContext.get();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"AppContext.get()");
                    ContentResolver cr = context.getContentResolver();
                    String imagePath = file.getAbsolutePath();
                    try {
                        String uriString = MediaStore.Images.Media.insertImage((ContentResolver)cr, (String)imagePath, null, null);
                        Uri uri2 = Uri.parse((String)uriString);
                        Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"Uri.parse(uriString)");
                        uri = uri2;
                    }
                    catch (FileNotFoundException exception) {
                        emitter.onError((Throwable)exception);
                    }
                }
                Cursor cursor = this.$context.getContentResolver().query(uri, null, null, null, null);
                if (cursor != null) {
                    Cursor cursor2 = cursor;
                    boolean bl = false;
                    boolean bl2 = false;
                    Cursor returnCursor = cursor2;
                    boolean bl3 = false;
                    int nameIndex = returnCursor.getColumnIndex("_display_name");
                    returnCursor.moveToFirst();
                    String name = returnCursor.getString(nameIndex);
                    File file = new File(this.$context.getFilesDir(), name);
                    try {
                        InputStream inputStream = this.$context.getContentResolver().openInputStream(uri);
                        if (inputStream != null) {
                            InputStream inputStream2 = inputStream;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            InputStream inputStream3 = inputStream2;
                            boolean bl6 = false;
                            FileOutputStream outputStream = new FileOutputStream(file);
                            int read = 0;
                            int maxBufferSize = 0x100000;
                            int bytesAvailable = inputStream3.available();
                            int bufferSize = RangesKt.coerceAtMost((int)bytesAvailable, (int)maxBufferSize);
                            byte[] buffers = new byte[bufferSize];
                            while (true) {
                                int n = inputStream3.read(buffers);
                                boolean bl7 = false;
                                boolean bl8 = false;
                                int it = n;
                                boolean bl9 = false;
                                read = it;
                                if (n == -1) break;
                                outputStream.write(buffers, 0, read);
                            }
                            inputStream3.close();
                            outputStream.close();
                            emitter.onSuccess((Object)file);
                        }
                    }
                    catch (Throwable e) {
                        Timber.e((String)("Exception " + e.getMessage()), (Object[])new Object[0]);
                        emitter.onError(e);
                    }
                    finally {
                        returnCursor.close();
                    }
                }
            }
            {
                this.$fileUri = uri;
                this.$context = context;
            }
        })).flatMap((Function)new Function<File, SingleSource<? extends File>>(this, context){
            final /* synthetic */ AmityImageUploadService this$0;
            final /* synthetic */ Context $context;

            public final SingleSource<? extends File> apply(@NotNull File it) {
                Bitmap bitmap;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Bitmap bitmap2 = bitmap = BitmapFactory.decodeFile((String)it.getAbsolutePath());
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
                return (SingleSource)AmityImageUploadService.access$saveMediaToCache(this.this$0, this.$context, bitmap2);
            }
            {
                this.this$0 = amityImageUploadService;
                this.$context = context;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.create<File> { em\u2026ontext, bitmap)\n        }");
        return single;
    }

    private final Single<File> saveMediaToCache(Context context, Bitmap bitmap) {
        Single single = Single.create((SingleOnSubscribe)((SingleOnSubscribe)new SingleOnSubscribe<File>(context, bitmap){
            final /* synthetic */ Context $context;
            final /* synthetic */ Bitmap $bitmap;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void subscribe(@NotNull SingleEmitter<File> emitter) {
                Intrinsics.checkNotNullParameter(emitter, (String)"emitter");
                try {
                    File file;
                    String filename = "img_cache_" + System.currentTimeMillis() + ".jpg";
                    if (Build.VERSION.SDK_INT > 28) {
                        StringBuilder stringBuilder = new StringBuilder();
                        File file2 = this.$context.getCacheDir();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"context.cacheDir");
                        file = new File(stringBuilder.append(file2.getAbsolutePath()).append(File.separator).append(filename).toString());
                    } else {
                        file = new File(this.$context.getCacheDir(), filename);
                    }
                    File file3 = file;
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    boolean bl = false;
                    boolean bl2 = false;
                    FileOutputStream $this$apply = fileOutputStream;
                    boolean bl3 = false;
                    Closeable closeable = $this$apply;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Throwable throwable = null;
                    try {
                        FileOutputStream it = (FileOutputStream)closeable;
                        boolean bl6 = false;
                        boolean bl7 = this.$bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    $this$apply.close();
                    emitter.onSuccess((Object)file3);
                }
                catch (Throwable e) {
                    Timber.e((String)("error: " + e), (Object[])new Object[0]);
                    emitter.onError(e);
                }
            }
            {
                this.$context = context;
                this.$bitmap = bitmap;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.create<File> { em\u2026)\n            }\n        }");
        return single;
    }

    private final void deleteFile(File file) {
        if (file.exists()) {
            boolean bl = file.delete();
        }
    }

    private AmityImageUploadService(Uri uri, String uploadId, boolean isFullImage) {
        this.uri = uri;
        this.uploadId = uploadId;
        this.isFullImage = isFullImage;
    }

    public /* synthetic */ AmityImageUploadService(Uri uri, String uploadId, boolean isFullImage, DefaultConstructorMarker $constructor_marker) {
        this(uri, uploadId, isFullImage);
    }

    public static final /* synthetic */ String access$getUploadId$p(AmityImageUploadService $this) {
        return $this.uploadId;
    }

    public static final /* synthetic */ void access$deleteFile(AmityImageUploadService $this, File file) {
        $this.deleteFile(file);
    }

    public static final /* synthetic */ Single access$saveMediaToCache(AmityImageUploadService $this, Context context, Bitmap bitmap) {
        return $this.saveMediaToCache(context, bitmap);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/core/file/AmityImageUploadService$Builder;", "", "()V", "isFullImage", "", "uploadId", "", "uri", "Landroid/net/Uri;", "build", "Lcom/amity/socialcloud/sdk/core/file/AmityImageUploadService;", "fileUri", "fileUri$amity_sdk_release", "amity-sdk_release"})
    public static final class Builder {
        private Uri uri;
        private String uploadId;
        private boolean isFullImage;

        @NotNull
        public final Builder fileUri$amity_sdk_release(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
            return this;
        }

        @NotNull
        public final Builder uploadId(@NotNull String uploadId) {
            Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
            this.uploadId = uploadId;
            return this;
        }

        @NotNull
        public final Builder isFullImage(boolean isFullImage) {
            this.isFullImage = isFullImage;
            return this;
        }

        @NotNull
        public final AmityImageUploadService build() {
            Uri uri = this.uri;
            if (uri == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
            }
            return new AmityImageUploadService(uri, this.uploadId, this.isFullImage, null);
        }
    }
}

