/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.AmityChannelTypesConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoChannelQueryFilterTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.EkoChannelQueryToken;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoChannelQueryTokenDao_Impl
extends EkoChannelQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoChannelQueryToken> __insertionAdapterOfEkoChannelQueryToken;
    private final AmityChannelTypesConverter __amityChannelTypesConverter = new AmityChannelTypesConverter();
    private final EkoChannelQueryFilterTypeConverter __ekoChannelQueryFilterTypeConverter = new EkoChannelQueryFilterTypeConverter();
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public EkoChannelQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoChannelQueryToken = new EntityInsertionAdapter<EkoChannelQueryToken>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_query_token` (`types`,`filter`,`includingTags`,`excludingTags`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelQueryToken value) {
                String _tmp = EkoChannelQueryTokenDao_Impl.this.__amityChannelTypesConverter.typeToJson(value.types);
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = EkoChannelQueryTokenDao_Impl.this.__ekoChannelQueryFilterTypeConverter.filterToApiKey(value.filter);
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                String _tmp_2 = EkoChannelQueryTokenDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.includingTags);
                if (_tmp_2 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_2);
                }
                String _tmp_3 = EkoChannelQueryTokenDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.excludingTags);
                if (_tmp_3 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_3);
                }
                if (value.getPrevious() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getNext());
                }
                stmt.bindLong(7, (long)value.getPageNumber());
                String _tmp_4 = EkoChannelQueryTokenDao_Impl.this.__stringListConverter.stringListToString(value.getIds());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
                String _tmp_5 = EkoChannelQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_5);
                }
            }
        };
    }

    @Override
    public Completable insertToken(final EkoChannelQueryToken token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EkoChannelQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    EkoChannelQueryTokenDao_Impl.this.__insertionAdapterOfEkoChannelQueryToken.insert((Object)token);
                    EkoChannelQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoChannelQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public Maybe<EkoChannelQueryToken> queryToken(SimpleSQLiteQuery query) {
        SimpleSQLiteQuery _internalQuery = query;
        return Maybe.fromCallable((Callable)new Callable<EkoChannelQueryToken>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoChannelQueryToken call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)this.val$_internalQuery, (boolean)false, null);){
                    EkoChannelQueryToken _result = _cursor.moveToFirst() ? EkoChannelQueryTokenDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalDataModelEkoChannelQueryToken(_cursor) : null;
                    EkoChannelQueryToken ekoChannelQueryToken = _result;
                    return ekoChannelQueryToken;
                }
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private EkoChannelQueryToken __entityCursorConverter_comEkoappEkosdkInternalDataModelEkoChannelQueryToken(Cursor cursor) {
        int _cursorIndexOfTypes = cursor.getColumnIndex("types");
        int _cursorIndexOfFilter = cursor.getColumnIndex("filter");
        int _cursorIndexOfIncludingTags = cursor.getColumnIndex("includingTags");
        int _cursorIndexOfExcludingTags = cursor.getColumnIndex("excludingTags");
        int _cursorIndexOfPrevious = cursor.getColumnIndex("previous");
        int _cursorIndexOfNext = cursor.getColumnIndex("next");
        int _cursorIndexOfPageNumber = cursor.getColumnIndex("pageNumber");
        int _cursorIndexOfIds = cursor.getColumnIndex("ids");
        int _cursorIndexOfUpdatedAt = cursor.getColumnIndex("updatedAt");
        EkoChannelQueryToken _entity = new EkoChannelQueryToken();
        if (_cursorIndexOfTypes != -1) {
            String _tmp = cursor.isNull(_cursorIndexOfTypes) ? null : cursor.getString(_cursorIndexOfTypes);
            _entity.types = this.__amityChannelTypesConverter.jsonToType(_tmp);
        }
        if (_cursorIndexOfFilter != -1) {
            String _tmp_1 = cursor.isNull(_cursorIndexOfFilter) ? null : cursor.getString(_cursorIndexOfFilter);
            _entity.filter = this.__ekoChannelQueryFilterTypeConverter.apiKeyToFilter(_tmp_1);
        }
        if (_cursorIndexOfIncludingTags != -1) {
            String _tmp_2 = cursor.isNull(_cursorIndexOfIncludingTags) ? null : cursor.getString(_cursorIndexOfIncludingTags);
            _entity.includingTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
        }
        if (_cursorIndexOfExcludingTags != -1) {
            String _tmp_3 = cursor.isNull(_cursorIndexOfExcludingTags) ? null : cursor.getString(_cursorIndexOfExcludingTags);
            _entity.excludingTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
        }
        if (_cursorIndexOfPrevious != -1) {
            String _tmpPrevious = cursor.isNull(_cursorIndexOfPrevious) ? null : cursor.getString(_cursorIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_cursorIndexOfNext != -1) {
            String _tmpNext = cursor.isNull(_cursorIndexOfNext) ? null : cursor.getString(_cursorIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_cursorIndexOfPageNumber != -1) {
            int _tmpPageNumber = cursor.getInt(_cursorIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_cursorIndexOfIds != -1) {
            String _tmp_4 = cursor.isNull(_cursorIndexOfIds) ? null : cursor.getString(_cursorIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp_4);
            _entity.setIds(_tmpIds);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_5 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

