/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.socket.call;

import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import com.ekoapp.ekosdk.internal.api.socket.call.ResponseConverter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.dao.PostDao;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.google.common.base.Objects;

public class CommentDeleteConverter
implements ResponseConverter<EkoDeletionDto> {
    private final String commentId;
    private final boolean hardDelete;

    public CommentDeleteConverter(String commentId, boolean hardDelete) {
        this.commentId = commentId;
        this.hardDelete = hardDelete;
    }

    @Override
    public EkoDeletionDto convert(SocketResponse response) {
        UserDatabase database;
        EkoCommentDao commentDao;
        CommentEntity commentEntity;
        EkoDeletionDto dto = (EkoDeletionDto)response.getData(EkoDeletionDto.class);
        if (dto.isSuccess() && (commentEntity = (commentDao = (database = UserDatabase.get()).commentDao()).getByIdNow(this.commentId)) != null) {
            if (this.hardDelete) {
                commentDao.deleteById(this.commentId);
            } else {
                commentDao.softDeleteById(this.commentId);
            }
            if (Objects.equal((Object)commentEntity.getReferenceType(), (Object)"post")) {
                PostDao postDao = database.postDao();
                postDao.decrementCommentCount(commentEntity.getReferenceId());
            }
        }
        return dto;
    }
}

