/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.post;

import com.amity.socialcloud.sdk.core.reaction.AmityPostReactionQuery;
import com.amity.socialcloud.sdk.social.AmitySocialClient;
import com.amity.socialcloud.sdk.social.comment.AmityCommentQuery;
import com.amity.socialcloud.sdk.social.feed.AmityPost;
import com.amity.socialcloud.sdk.social.feed.AmityPostCreateTargetSelector;
import com.amity.socialcloud.sdk.social.post.AmityPostQueryTargetSelector;
import com.ekoapp.ekosdk.feed.review.AmityPostReviewer;
import com.ekoapp.ekosdk.internal.usecase.post.PostDeleteUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.SinglePostUseCase;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"Lcom/amity/socialcloud/sdk/social/post/AmityPostRepository;", "", "()V", "createPost", "Lcom/amity/socialcloud/sdk/social/feed/AmityPostCreateTargetSelector;", "deletePost", "Lio/reactivex/Completable;", "postId", "", "hardDelete", "", "getComments", "Lcom/amity/socialcloud/sdk/social/comment/AmityCommentQuery$Builder;", "getPost", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/social/feed/AmityPost;", "getPosts", "Lcom/amity/socialcloud/sdk/social/post/AmityPostQueryTargetSelector;", "getReactions", "Lcom/amity/socialcloud/sdk/core/reaction/AmityPostReactionQuery$Builder;", "reviewPost", "Lcom/ekoapp/ekosdk/feed/review/AmityPostReviewer;", "amity-sdk_release"})
public final class AmityPostRepository {
    @NotNull
    public final Flowable<AmityPost> getPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new SinglePostUseCase().execute(postId);
    }

    @NotNull
    public final AmityPostQueryTargetSelector getPosts() {
        return new AmityPostQueryTargetSelector();
    }

    @NotNull
    public final AmityPostCreateTargetSelector createPost() {
        return new AmityPostCreateTargetSelector();
    }

    @NotNull
    public final Completable deletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.deletePost(postId, false);
    }

    @NotNull
    public final Completable deletePost(@NotNull String postId, boolean hardDelete) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new PostDeleteUseCase().execute(postId, hardDelete);
    }

    @NotNull
    public final AmityPostReviewer reviewPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReviewer(postId);
    }

    @NotNull
    public final AmityPostReactionQuery.Builder getReactions(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReactionQuery.Builder(postId);
    }

    @NotNull
    public final AmityCommentQuery.Builder getComments(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return AmitySocialClient.INSTANCE.newCommentRepository().getComments().post(postId);
    }
}

