/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.user;

import androidx.paging.DataSource;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.amity.socialcloud.sdk.core.user.AmityUserSortOption;
import com.ekoapp.ekosdk.EkoInternalUser;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.SocketConnectionEvent;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.UserQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.UserGetRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.UserUpdateRequest;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoUserBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag;
import com.ekoapp.ekosdk.internal.repository.user.UserRepository;
import com.ekoapp.ekosdk.internal.repository.user.UserRepository$sam$io_reactivex_functions_Function$0;
import com.ekoapp.ekosdk.internal.repository.user.UserUpdateOption;
import com.ekoapp.ekosdk.internal.repository.user.helper.MapToUserModelHelper;
import com.ekoapp.ekosdk.internal.repository.user.helper.RegisterDeviceManager;
import com.ekoapp.ekosdk.internal.repository.user.helper.UserRepositoryHelper;
import com.ekoapp.ekosdk.internal.util.RxEko;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.CompletableSubject;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000b0\u00062\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\b\u001a\u00020\tJ\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\tJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/user/UserRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "getDefaultPageSize", "", "getUser", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/core/user/AmityUser;", "userId", "", "getUserCollection", "Landroidx/paging/PagedList;", "keyword", "sortBy", "Lcom/amity/socialcloud/sdk/core/user/AmityUserSortOption;", "getUserFlag", "Lcom/ekoapp/ekosdk/internal/data/model/EkoUserFlag;", "registerDevice", "Lio/reactivex/Completable;", "displayName", "authToken", "updateUser", "Lio/reactivex/Single;", "option", "Lcom/ekoapp/ekosdk/internal/repository/user/UserUpdateOption;", "amity-sdk_release"})
public final class UserRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagedList<AmityUser>> getUserCollection(@NotNull String keyword, @NotNull AmityUserSortOption sortBy) {
        Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortBy), (String)"sortBy");
        EkoUserDao ekoUserDao = UserDatabase.get().userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoUserDao, (String)"UserDatabase.get().userDao()");
        EkoUserDao userDao = ekoUserDao;
        CharSequence charSequence = keyword;
        boolean bl = false;
        DataSource.Factory<Integer, EkoInternalUser> localFactory = charSequence.length() == 0 ? userDao.getAll(sortBy) : userDao.searchAll(keyword, sortBy);
        DataSource.Factory factory2 = localFactory.map((androidx.arch.core.util.Function)new MapToUserModelHelper());
        Intrinsics.checkExpressionValueIsNotNull((Object)factory2, (String)"localFactory\n           \u2026p(MapToUserModelHelper())");
        DataSource.Factory factory3 = factory2;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoUserBoundaryCallback boundaryCallback = new EkoUserBoundaryCallback(keyword, sortBy, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        DataSource.Factory factory4 = factory3.map((androidx.arch.core.util.Function)boundaryCallback);
        Intrinsics.checkExpressionValueIsNotNull((Object)factory4, (String)"factory.map(boundaryCallback)");
        return this.createRxCollectionWithBoundaryCallback(factory4, boundaryCallback);
    }

    @NotNull
    public final Flowable<AmityUser> getUser(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        EkoUserDao ekoUserDao = UserDatabase.get().userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoUserDao, (String)"UserDatabase.get().userDao()");
        EkoUserDao userDao = ekoUserDao;
        UserGetRequest request = new UserGetRequest(CollectionsKt.listOf((Object)userId));
        UserQueryConverter converter2 = new UserQueryConverter();
        EkoSocket.call(Call.create(request, converter2));
        Function1 function1 = (Function1)new Function1<EkoInternalUser, AmityUser>(new UserRepositoryHelper()){

            @NotNull
            public final AmityUser invoke(@NotNull EkoInternalUser p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((UserRepositoryHelper)this.receiver).attachDataAndMapToExternal(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(UserRepositoryHelper.class);
            }

            public final String getName() {
                return "attachDataAndMapToExternal";
            }

            public final String getSignature() {
                return "attachDataAndMapToExternal(Lcom/ekoapp/ekosdk/EkoInternalUser;)Lcom/amity/socialcloud/sdk/core/user/AmityUser;";
            }
        };
        Flowable flowable = userDao.getById(userId).map((Function)new UserRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"userDao.getById(userId).\u2026tachDataAndMapToExternal)");
        return flowable;
    }

    @NotNull
    public final Flowable<EkoUserFlag> getUserFlag(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        EkoUserFlagDao userFlagDao = UserDatabase.get().userFlagDao();
        Flowable<EkoUserFlag> flowable = userFlagDao.getById(userId);
        Intrinsics.checkExpressionValueIsNotNull(flowable, (String)"userFlagDao.getById(userId)");
        return flowable;
    }

    @NotNull
    public final Single<AmityUser> updateUser(@NotNull String userId, @NotNull UserUpdateOption option) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        UserUpdateRequest request = new UserUpdateRequest(userId, option.getDisplayName(), option.getRoles(), option.getMetadata(), option.getAvatarFileId(), option.getAvatarCustomUrl(), option.getDescription());
        Single single = EkoSocket.call(Call.create(request, new UserQueryConverter())).flatMap(new Function<T, SingleSource<? extends R>>(this, userId){
            final /* synthetic */ UserRepository this$0;
            final /* synthetic */ String $userId;

            @NotNull
            public final Single<AmityUser> apply(@NotNull EkoUserListDto it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Single.defer((Callable)new Callable<SingleSource<? extends T>>(this){
                    final /* synthetic */ updateUser.1 this$0;

                    public final Single<AmityUser> call() {
                        return this.this$0.this$0.getUser(this.this$0.$userId).firstOrError();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = userRepository;
                this.$userId = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"EkoSocket.call(Call.crea\u2026serId).firstOrError() } }");
        return single;
    }

    @NotNull
    public final Completable registerDevice(@NotNull String userId, @Nullable String displayName, @Nullable String authToken) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        CompletableSubject completableSubject = CompletableSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)completableSubject, (String)"CompletableSubject.create()");
        CompletableSubject result = completableSubject;
        RegisterDeviceManager registerManager = new RegisterDeviceManager(userId, displayName, authToken);
        EkoApiKeyDao ekoApiKeyDao = EkoDatabase.get().apiKeyDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoApiKeyDao, (String)"EkoDatabase.get().apiKeyDao()");
        ekoApiKeyDao.getCurrentApiKey().map(new Function<T, R>(registerManager){
            final /* synthetic */ RegisterDeviceManager $registerManager;

            public final EkoAccountDao apply(@NotNull EkoApiKey it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = it.getApiKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.apiKey");
                this.$registerManager.register(string).blockingGet();
                return EkoDatabase.get().accountDao();
            }
            {
                this.$registerManager = registerDeviceManager;
            }
        }).doOnSuccess((Consumer)new Consumer<EkoAccountDao>(userId){
            final /* synthetic */ String $userId;

            public final void accept(EkoAccountDao it) {
                EkoSocket.rpc(new UserGetRequest(CollectionsKt.listOf((Object)this.$userId)));
            }
            {
                this.$userId = string;
            }
        }).flatMap(new Function<T, MaybeSource<? extends R>>(registerManager){
            final /* synthetic */ RegisterDeviceManager $registerManager;

            @NotNull
            public final Maybe<SocketConnectionEvent> apply(@NotNull EkoAccountDao it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$registerManager.restart();
            }
            {
                this.$registerManager = registerDeviceManager;
            }
        }).doOnError(RxEko.CATCH_UNAUTHORIZED_ERROR_CONSUMER).doOnError(RxEko.LOG_ERROR_CONSUMER).switchIfEmpty((MaybeSource)Maybe.never()).ignoreElement().subscribeOn(Schedulers.io()).subscribe((CompletableObserver)result);
        Completable completable = result.hide();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"result.hide()");
        return completable;
    }
}

