/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.post;

import androidx.paging.DataSource;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.social.feed.AmityCommunityFeedSortOption;
import com.amity.socialcloud.sdk.social.feed.AmityPost;
import com.amity.socialcloud.sdk.social.feed.AmityUserFeedSortOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.EkoStandardPost;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.PostCreationConverter;
import com.ekoapp.ekosdk.internal.api.socket.call.PostDeleteConverter;
import com.ekoapp.ekosdk.internal.api.socket.call.PostSingleConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.CreatePostRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.GetPostRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.PostDeleteRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.CommunityFeedBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.GlobalFeedBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.UserFeedBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoPostFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoStandardPostDao;
import com.ekoapp.ekosdk.internal.data.model.EkoPostFlag;
import com.ekoapp.ekosdk.internal.repository.post.PostRepository$sam$io_reactivex_functions_Function$0;
import com.ekoapp.ekosdk.internal.repository.post.helper.AttachDataToPostHelper;
import com.ekoapp.ekosdk.internal.repository.post.helper.MapToEkoPostModelHelper;
import com.ekoapp.ekosdk.internal.repository.post.helper.PostRepositoryHelper;
import com.google.gson.JsonObject;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J1\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00100\u000fJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\r\u001a\u00020\u0007J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f2\u0006\u0010\r\u001a\u00020\u0007J1\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00100\u000f2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u001f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/post/PostRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "createPost", "Lio/reactivex/Single;", "Lcom/amity/socialcloud/sdk/social/feed/AmityPost;", "targetType", "", "targetId", "data", "Lcom/google/gson/JsonObject;", "deletePost", "Lio/reactivex/Completable;", "postId", "getCommunityPostCollection", "Lio/reactivex/Flowable;", "Landroidx/paging/PagedList;", "communityId", "sortOption", "Lcom/amity/socialcloud/sdk/social/feed/AmityCommunityFeedSortOption;", "isDeleted", "", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/social/feed/AmityCommunityFeedSortOption;Ljava/lang/Boolean;)Lio/reactivex/Flowable;", "getDefaultPageSize", "", "getGlobalPostCollection", "getPost", "getPostFlag", "Lcom/ekoapp/ekosdk/internal/data/model/EkoPostFlag;", "getUserPostCollection", "userId", "Lcom/amity/socialcloud/sdk/social/feed/AmityUserFeedSortOption;", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/social/feed/AmityUserFeedSortOption;Ljava/lang/Boolean;)Lio/reactivex/Flowable;", "amity-sdk_release"})
public final class PostRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<EkoPostFlag> getPostFlag(@NotNull String postId) {
        Intrinsics.checkParameterIsNotNull((Object)postId, (String)"postId");
        EkoPostFlagDao postFlagDao = UserDatabase.get().postFlagDao();
        Flowable<EkoPostFlag> flowable = postFlagDao.getByPostId(postId);
        Intrinsics.checkExpressionValueIsNotNull(flowable, (String)"postFlagDao.getByPostId(postId)");
        return flowable;
    }

    @NotNull
    public final Flowable<PagedList<AmityPost>> getGlobalPostCollection() {
        EkoStandardPostDao standardPostDao;
        EkoStandardPostDao ekoStandardPostDao = standardPostDao = UserDatabase.get().standardPostDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoStandardPostDao, (String)"standardPostDao");
        DataSource.Factory factory2 = ekoStandardPostDao.getGlobalPostCollection().map((androidx.arch.core.util.Function)new AttachDataToPostHelper()).map((androidx.arch.core.util.Function)new MapToEkoPostModelHelper());
        Intrinsics.checkExpressionValueIsNotNull((Object)factory2, (String)"standardPostDao.globalPo\u2026apToEkoPostModelHelper())");
        DataSource.Factory factory3 = factory2;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        GlobalFeedBoundaryCallback boundaryCallback = new GlobalFeedBoundaryCallback(this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        DataSource.Factory factory4 = factory3.map((androidx.arch.core.util.Function)boundaryCallback);
        Intrinsics.checkExpressionValueIsNotNull((Object)factory4, (String)"factory.map(boundaryCallback)");
        return this.createRxCollectionWithBoundaryCallback(factory4, boundaryCallback);
    }

    @NotNull
    public final Flowable<PagedList<AmityPost>> getCommunityPostCollection(@NotNull String communityId, @NotNull AmityCommunityFeedSortOption sortOption, @Nullable Boolean isDeleted) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortOption), (String)"sortOption");
        EkoStandardPostDao postDao = UserDatabase.get().standardPostDao();
        DataSource.Factory<Integer, EkoStandardPost> localFactory = sortOption == AmityCommunityFeedSortOption.LAST_CREATED ? postDao.getCommunityPostCollectionOrderByCreatedAtDesc(communityId, isDeleted) : postDao.getCommunityPostCollectionOrderByCreatedAtAsc(communityId, isDeleted);
        DataSource.Factory factory2 = localFactory.map((androidx.arch.core.util.Function)new AttachDataToPostHelper()).map((androidx.arch.core.util.Function)new MapToEkoPostModelHelper());
        Intrinsics.checkExpressionValueIsNotNull((Object)factory2, (String)"localFactory\n           \u2026apToEkoPostModelHelper())");
        DataSource.Factory factory3 = factory2;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        CommunityFeedBoundaryCallback boundaryCallback = new CommunityFeedBoundaryCallback(communityId, sortOption.getApiKey(), isDeleted, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        DataSource.Factory factory4 = factory3.map((androidx.arch.core.util.Function)boundaryCallback);
        Intrinsics.checkExpressionValueIsNotNull((Object)factory4, (String)"factory.map(boundaryCallback)");
        return this.createRxCollectionWithBoundaryCallback(factory4, boundaryCallback);
    }

    @NotNull
    public final Flowable<PagedList<AmityPost>> getUserPostCollection(@NotNull String userId, @NotNull AmityUserFeedSortOption sortOption, @Nullable Boolean isDeleted) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortOption), (String)"sortOption");
        EkoStandardPostDao postDao = UserDatabase.get().standardPostDao();
        DataSource.Factory<Integer, EkoStandardPost> localFactory = sortOption == AmityUserFeedSortOption.LAST_CREATED ? postDao.getUserPostCollectionOrderByCreatedAtDesc(userId, isDeleted) : postDao.getUserPostCollectionOrderByCreatedAtAsc(userId, isDeleted);
        DataSource.Factory factory2 = localFactory.map((androidx.arch.core.util.Function)new AttachDataToPostHelper()).map((androidx.arch.core.util.Function)new MapToEkoPostModelHelper());
        Intrinsics.checkExpressionValueIsNotNull((Object)factory2, (String)"localFactory\n           \u2026apToEkoPostModelHelper())");
        DataSource.Factory factory3 = factory2;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        UserFeedBoundaryCallback boundaryCallback = new UserFeedBoundaryCallback(userId, sortOption.getApiKey(), isDeleted, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        DataSource.Factory factory4 = factory3.map((androidx.arch.core.util.Function)boundaryCallback);
        Intrinsics.checkExpressionValueIsNotNull((Object)factory4, (String)"factory.map(boundaryCallback)");
        return this.createRxCollectionWithBoundaryCallback(factory4, boundaryCallback);
    }

    @NotNull
    public final Flowable<AmityPost> getPost(@NotNull String postId) {
        Intrinsics.checkParameterIsNotNull((Object)postId, (String)"postId");
        UserDatabase database = UserDatabase.get();
        EkoStandardPostDao ekoStandardPostDao = database.standardPostDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoStandardPostDao, (String)"database.standardPostDao()");
        EkoStandardPostDao localPost = ekoStandardPostDao;
        GetPostRequest request = new GetPostRequest(postId);
        EkoSocket.call(Call.create(request, new PostSingleConverter()));
        Function1 function1 = (Function1)new Function1<EkoStandardPost, EkoStandardPost>(new PostRepositoryHelper()){

            @NotNull
            public final EkoStandardPost invoke(@NotNull EkoStandardPost p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((PostRepositoryHelper)this.receiver).attachDataToEkoPost(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(PostRepositoryHelper.class);
            }

            public final String getName() {
                return "attachDataToEkoPost";
            }

            public final String getSignature() {
                return "attachDataToEkoPost(Lcom/ekoapp/ekosdk/internal/EkoStandardPost;)Lcom/ekoapp/ekosdk/internal/EkoStandardPost;";
            }
        };
        PostRepository$sam$io_reactivex_functions_Function$0 postRepository$sam$io_reactivex_functions_Function$0 = new PostRepository$sam$io_reactivex_functions_Function$0(function1);
        function1 = (Function1)new Function1<EkoStandardPost, AmityPost>(new PostRepositoryHelper()){

            @NotNull
            public final AmityPost invoke(@NotNull EkoStandardPost p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((PostRepositoryHelper)this.receiver).mapToExternalModel(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(PostRepositoryHelper.class);
            }

            public final String getName() {
                return "mapToExternalModel";
            }

            public final String getSignature() {
                return "mapToExternalModel(Lcom/ekoapp/ekosdk/internal/EkoStandardPost;)Lcom/amity/socialcloud/sdk/social/feed/AmityPost;";
            }
        };
        Flowable flowable = localPost.getPost(postId).map((Function)postRepository$sam$io_reactivex_functions_Function$0).map((Function)new PostRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"localPost.getPost(postId\u2026er()::mapToExternalModel)");
        return flowable;
    }

    @NotNull
    public final Single<AmityPost> createPost(@NotNull String targetType, @NotNull String targetId, @NotNull JsonObject data) {
        Intrinsics.checkParameterIsNotNull((Object)targetType, (String)"targetType");
        Intrinsics.checkParameterIsNotNull((Object)targetId, (String)"targetId");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        CreatePostRequest createPostRequest = new CreatePostRequest(null, null, null, null, 15, null);
        createPostRequest.setTargetType(targetType);
        createPostRequest.setTargetId(targetId);
        createPostRequest.setData(data);
        Function1 function1 = (Function1)new Function1<EkoStandardPost, EkoStandardPost>(new PostRepositoryHelper()){

            @NotNull
            public final EkoStandardPost invoke(@NotNull EkoStandardPost p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((PostRepositoryHelper)this.receiver).attachDataToEkoPost(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(PostRepositoryHelper.class);
            }

            public final String getName() {
                return "attachDataToEkoPost";
            }

            public final String getSignature() {
                return "attachDataToEkoPost(Lcom/ekoapp/ekosdk/internal/EkoStandardPost;)Lcom/ekoapp/ekosdk/internal/EkoStandardPost;";
            }
        };
        PostRepository$sam$io_reactivex_functions_Function$0 postRepository$sam$io_reactivex_functions_Function$0 = new PostRepository$sam$io_reactivex_functions_Function$0(function1);
        function1 = (Function1)new Function1<EkoStandardPost, AmityPost>(new PostRepositoryHelper()){

            @NotNull
            public final AmityPost invoke(@NotNull EkoStandardPost p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((PostRepositoryHelper)this.receiver).mapToExternalModel(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(PostRepositoryHelper.class);
            }

            public final String getName() {
                return "mapToExternalModel";
            }

            public final String getSignature() {
                return "mapToExternalModel(Lcom/ekoapp/ekosdk/internal/EkoStandardPost;)Lcom/amity/socialcloud/sdk/social/feed/AmityPost;";
            }
        };
        Single single = EkoSocket.call(Call.create(createPostRequest, new PostCreationConverter())).map((Function)postRepository$sam$io_reactivex_functions_Function$0).map((Function)new PostRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"EkoSocket.call(Call.crea\u2026er()::mapToExternalModel)");
        return single;
    }

    @NotNull
    public final Completable deletePost(@NotNull String postId) {
        Intrinsics.checkParameterIsNotNull((Object)postId, (String)"postId");
        PostDeleteRequest request = new PostDeleteRequest(postId);
        Completable completable = EkoSocket.call(Call.create(request, new PostDeleteConverter(postId))).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026postId))).ignoreElement()");
        return completable;
    }
}

