/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.ekoapp.ekosdk.internal.EkoInternalMessage;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageTagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoTagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageTag;
import io.reactivex.Flowable;
import java.util.List;

@Dao
public abstract class EkoMessageDao
extends EkoObjectDao<EkoInternalMessage> {
    private final EkoMessageTagDao messageTagDao = UserDatabase.get().messageTagDao();

    EkoMessageDao() {
    }

    @Deprecated
    @Query(value="SELECT count(*) from message")
    public abstract Flowable<Integer> getCount();

    @Deprecated
    @Query(value="SELECT count(*) from message where channelId = :channelId")
    public abstract Flowable<Integer> getCount(String var1);

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) order by channelSegment ASC")
    abstract DataSource.Factory<Integer, EkoInternalMessage> getAllImpl(String var1, String[] var2);

    public DataSource.Factory<Integer, EkoInternalMessage> getAll(String channelId, String[] excludingTags) {
        return this.getAllImpl(channelId, excludingTags);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId and message.parentId = :parentId and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) order by channelSegment ASC")
    abstract DataSource.Factory<Integer, EkoInternalMessage> getAllByParentIdImpl(String var1, String var2, String[] var3);

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId and message.parentId is null and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) order by channelSegment ASC")
    abstract DataSource.Factory<Integer, EkoInternalMessage> getAllByParentIdImpl(String var1, String[] var2);

    public DataSource.Factory<Integer, EkoInternalMessage> getAllByParentId(String channelId, String parentId, String[] excludingTags) {
        if (parentId != null) {
            return this.getAllByParentIdImpl(channelId, parentId, excludingTags);
        }
        return this.getAllByParentIdImpl(channelId, excludingTags);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId and message.messageId in (SELECT messageId from message_tag where tagName in (:includingTags)) and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) order by channelSegment ASC")
    abstract DataSource.Factory<Integer, EkoInternalMessage> getAllByTagsImpl(String var1, String[] var2, String[] var3);

    public DataSource.Factory<Integer, EkoInternalMessage> getAllByTags(String channelId, String[] includingTags, String[] excludingTags) {
        return this.getAllByTagsImpl(channelId, includingTags, excludingTags);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId and message.parentId = :parentId and message.messageId in (SELECT messageId from message_tag where tagName in (:includingTags)) and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) order by channelSegment ASC")
    abstract DataSource.Factory<Integer, EkoInternalMessage> getAllByParentIdAndTagsImpl(String var1, String var2, String[] var3, String[] var4);

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId and message.parentId is null and message.messageId in (SELECT messageId from message_tag where tagName in (:includingTags)) and message.messageId not in (SELECT messageId from message_tag where tagName in (:excludingTags)) order by channelSegment ASC")
    abstract DataSource.Factory<Integer, EkoInternalMessage> getAllByParentIdAndTagsImpl(String var1, String[] var2, String[] var3);

    public DataSource.Factory<Integer, EkoInternalMessage> getAllByParentIdAndTags(String channelId, String parentId, String[] includingTags, String[] excludingTags) {
        if (parentId != null) {
            return this.getAllByParentIdAndTagsImpl(channelId, parentId, includingTags, excludingTags);
        }
        return this.getAllByParentIdAndTagsImpl(channelId, includingTags, excludingTags);
    }

    @Query(value="SELECT channelSegment from message where channelId = :channelId order by channelSegment DESC LIMIT 1")
    public abstract int getHighestChannelSegment(String var1);

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = :channelId and message.messageId = message_flag.messageId order by channelSegment DESC LIMIT 1")
    abstract Flowable<EkoInternalMessage> getLatestMessageImpl(String var1);

    public Flowable<EkoInternalMessage> getLatestMessage(String channelId) {
        return this.getLatestMessageImpl(channelId);
    }

    @Query(value="UPDATE message set syncState = 'failed' where syncState = 'syncing'")
    public abstract void cleanUpSyncingStateOnStartup();

    @Query(value="UPDATE message set syncState = 'failed' where syncState = 'uploading'")
    public abstract void cleanUpUploadingStateOnStartup();

    @Override
    @Query(value="DELETE from message")
    public abstract void deleteAll();

    @Query(value="DELETE from message where channelId = :channelId")
    public abstract void deleteAllFromChannel(String var1);

    @Query(value="SELECT * from message where channelId = :channelId order by createdAt DESC LIMIT -1 OFFSET :offset")
    abstract List<EkoInternalMessage> getOldMessages(String var1, int var2);

    @Transaction
    public void retainLatestFromChannel(String channelId, int offset) {
        List<EkoInternalMessage> oldMessages = this.getOldMessages(channelId, offset);
        this.delete(oldMessages);
    }

    @Query(value="UPDATE message set isDeleted = 1, data = null where channelId = :channelId")
    public abstract void softDeleteAllFromChannel(String var1);

    @Query(value="UPDATE message set isDeleted = 1, data = null where channelId = :channelId and userId = :userId")
    abstract void softDeleteFromChannelByUserIdImpl(String var1, String var2);

    @Transaction
    public void softDeleteFromChannelByUserId(String channelId, String userId) {
        this.softDeleteFromChannelByUserIdImpl(channelId, userId);
    }

    @Query(value="UPDATE message set userId = :userId where userId = :userId")
    abstract void updateUserImpl(String var1);

    @Transaction
    public void updateUser(String userId) {
        this.updateUserImpl(userId);
    }

    @Override
    @Transaction
    public void insert(EkoInternalMessage message) {
        super.insert(message);
        EkoTagDao.update(message, this.messageTagDao, EkoMessageTag::create);
    }

    @Override
    @Transaction
    public void insert(List<EkoInternalMessage> messages) {
        super.insert(messages);
        EkoTagDao.update(messages, this.messageTagDao, EkoMessageTag::create);
    }

    @Override
    @Transaction
    public void update(EkoInternalMessage message) {
        super.update(message);
        EkoTagDao.update(message, this.messageTagDao, EkoMessageTag::create);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId = :messageId and message.messageId = message_flag.messageId LIMIT 1")
    abstract Flowable<EkoInternalMessage> getByIdImpl(String var1);

    public Flowable<EkoInternalMessage> getById(String messageId) {
        return this.getByIdImpl(messageId);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId = :messageId and message.messageId = message_flag.messageId LIMIT 1")
    abstract EkoInternalMessage getByIdNowImpl(String var1);

    @Override
    public EkoInternalMessage getByIdNow(String messageId) {
        return this.getByIdNowImpl(messageId);
    }

    @Query(value="SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId IN (:messageIds) and message.messageId = message_flag.messageId")
    abstract List<EkoInternalMessage> getByIdsNowImpl(List<String> var1);

    @Override
    public List<EkoInternalMessage> getByIdsNow(List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }
}

