/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoCommentDao_Impl
extends EkoCommentDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfCommentEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfCommentEntity;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfCommentEntity;
    private final SharedSQLiteStatement __preparedStmtOfInitSyncStateOnStartup;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteCommentByCommentId;
    private final SharedSQLiteStatement __preparedStmtOfUpdateComment;
    private final SharedSQLiteStatement __preparedStmtOfMarkAllDeletedBeforeCreatedAt;
    private final SharedSQLiteStatement __preparedStmtOfMarkAllDeletedAfterCreatedAt;

    public EkoCommentDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommentEntity = new EntityInsertionAdapter<CommentEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `comment`(`myReactions`,`commentId`,`referenceType`,`referenceId`,`userId`,`parentId`,`rootId`,`dataType`,`data`,`metadata`,`childrenNumber`,`flagCount`,`reactions`,`reactionCount`,`isDeleted`,`editedAt`,`syncState`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommentEntity value) {
                Integer _tmp_4;
                String _tmp = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(value.getMyReactions());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getCommentId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getCommentId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReferenceId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUserId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getParentId());
                }
                if (value.getRootId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getRootId());
                }
                if (value.getDataType() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getDataType());
                }
                String _tmp_1 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
                String _tmp_2 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_2);
                }
                if (value.getChildrenNumber() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)value.getChildrenNumber().intValue());
                }
                if (value.getFlagCount() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)value.getFlagCount().intValue());
                }
                String _tmp_3 = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_3 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_3);
                }
                stmt.bindLong(14, (long)value.getReactionCount());
                Integer n = value.isDeleted() == null ? null : (_tmp_4 = Integer.valueOf(value.isDeleted() != false ? 1 : 0));
                if (_tmp_4 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)_tmp_4.intValue());
                }
                String _tmp_5 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_5);
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getSyncState());
                }
                String _tmp_6 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                String _tmp_7 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_7);
                }
            }
        };
        this.__deletionAdapterOfCommentEntity = new EntityDeletionOrUpdateAdapter<CommentEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `comment` WHERE `commentId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommentEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
            }
        };
        this.__updateAdapterOfCommentEntity = new EntityDeletionOrUpdateAdapter<CommentEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `comment` SET `myReactions` = ?,`commentId` = ?,`referenceType` = ?,`referenceId` = ?,`userId` = ?,`parentId` = ?,`rootId` = ?,`dataType` = ?,`data` = ?,`metadata` = ?,`childrenNumber` = ?,`flagCount` = ?,`reactions` = ?,`reactionCount` = ?,`isDeleted` = ?,`editedAt` = ?,`syncState` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `commentId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommentEntity value) {
                Integer _tmp_4;
                String _tmp = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(value.getMyReactions());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getCommentId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getCommentId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReferenceId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUserId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getParentId());
                }
                if (value.getRootId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getRootId());
                }
                if (value.getDataType() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getDataType());
                }
                String _tmp_1 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
                String _tmp_2 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_2 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_2);
                }
                if (value.getChildrenNumber() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)value.getChildrenNumber().intValue());
                }
                if (value.getFlagCount() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)value.getFlagCount().intValue());
                }
                String _tmp_3 = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_3 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_3);
                }
                stmt.bindLong(14, (long)value.getReactionCount());
                Integer n = value.isDeleted() == null ? null : (_tmp_4 = Integer.valueOf(value.isDeleted() != false ? 1 : 0));
                if (_tmp_4 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)_tmp_4.intValue());
                }
                String _tmp_5 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_5);
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getSyncState());
                }
                String _tmp_6 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                String _tmp_7 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_7);
                }
                if (value.getCommentId() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getCommentId());
                }
            }
        };
        this.__preparedStmtOfInitSyncStateOnStartup = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set syncState = 'failed' where syncState = 'syncing'";
                return "UPDATE comment set syncState = 'failed' where syncState = 'syncing'";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from comment";
                return "DELETE from comment";
            }
        };
        this.__preparedStmtOfDeleteCommentByCommentId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set isDeleted = 1 where commentId = ?";
                return "UPDATE comment set isDeleted = 1 where commentId = ?";
            }
        };
        this.__preparedStmtOfUpdateComment = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set commentId = commentId where commentId = ?";
                return "UPDATE comment set commentId = commentId where commentId = ?";
            }
        };
        this.__preparedStmtOfMarkAllDeletedBeforeCreatedAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set isDeleted = 1 where createdAt < ?";
                return "UPDATE comment set isDeleted = 1 where createdAt < ?";
            }
        };
        this.__preparedStmtOfMarkAllDeletedAfterCreatedAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set isDeleted = 1 where createdAt > ?";
                return "UPDATE comment set isDeleted = 1 where createdAt > ?";
            }
        };
    }

    @Override
    void insertImpl(CommentEntity object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommentEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<CommentEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommentEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(CommentEntity object) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommentEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<CommentEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommentEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(CommentEntity object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCommentEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(CommentEntity object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<CommentEntity> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(CommentEntity object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void initSyncStateOnStartup() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfInitSyncStateOnStartup.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfInitSyncStateOnStartup.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCommentByCommentId(String commentId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteCommentByCommentId.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (commentId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, commentId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteCommentByCommentId.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateComment(String commentId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateComment.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (commentId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, commentId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateComment.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAllDeletedBeforeCreatedAt(DateTime createdAt) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfMarkAllDeletedBeforeCreatedAt.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
            if (_tmp == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _tmp);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfMarkAllDeletedBeforeCreatedAt.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAllDeletedAfterCreatedAt(DateTime createdAt) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfMarkAllDeletedAfterCreatedAt.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
            if (_tmp == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _tmp);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfMarkAllDeletedAfterCreatedAt.release(_stmt);
        }
    }

    @Override
    DataSource.Factory<Integer, CommentEntity> getAllImpl(String referenceType, String referenceId, Boolean isDeleted, Boolean isSortByCreatedACS) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ?  and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ?  and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)6);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 5;
        Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 6;
        Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, CommentEntity>(){

            public LimitOffsetDataSource<CommentEntity> create() {
                return new LimitOffsetDataSource<CommentEntity>(EkoCommentDao_Impl.this.__db, _statement, false, new String[]{"comment", "comment_flag"}){

                    protected List<CommentEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfMyReactions = cursor.getColumnIndexOrThrow("myReactions");
                        int _cursorIndexOfCommentId = cursor.getColumnIndexOrThrow("commentId");
                        int _cursorIndexOfReferenceType = cursor.getColumnIndexOrThrow("referenceType");
                        int _cursorIndexOfReferenceId = cursor.getColumnIndexOrThrow("referenceId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfParentId = cursor.getColumnIndexOrThrow("parentId");
                        int _cursorIndexOfRootId = cursor.getColumnIndexOrThrow("rootId");
                        int _cursorIndexOfDataType = cursor.getColumnIndexOrThrow("dataType");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfChildrenNumber = cursor.getColumnIndexOrThrow("childrenNumber");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfSyncState = cursor.getColumnIndexOrThrow("syncState");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommentEntity> _res = new ArrayList<CommentEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommentEntity _item = new CommentEntity();
                            String _tmp_4 = cursor.getString(_cursorIndexOfMyReactions);
                            List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_4);
                            _item.setMyReactions(_tmpMyReactions);
                            String _tmpCommentId = cursor.getString(_cursorIndexOfCommentId);
                            _item.setCommentId(_tmpCommentId);
                            String _tmpReferenceType = cursor.getString(_cursorIndexOfReferenceType);
                            _item.setReferenceType(_tmpReferenceType);
                            String _tmpReferenceId = cursor.getString(_cursorIndexOfReferenceId);
                            _item.setReferenceId(_tmpReferenceId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpParentId = cursor.getString(_cursorIndexOfParentId);
                            _item.setParentId(_tmpParentId);
                            String _tmpRootId = cursor.getString(_cursorIndexOfRootId);
                            _item.setRootId(_tmpRootId);
                            String _tmpDataType = cursor.getString(_cursorIndexOfDataType);
                            _item.setDataType(_tmpDataType);
                            String _tmp_5 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                            _item.setData(_tmpData);
                            String _tmp_6 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpChildrenNumber = cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfChildrenNumber));
                            _item.setChildrenNumber(_tmpChildrenNumber);
                            Integer _tmpFlagCount = cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfFlagCount));
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_7 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_7);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_9 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmpSyncState = cursor.getString(_cursorIndexOfSyncState);
                            _item.setSyncState(_tmpSyncState);
                            String _tmp_10 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_11 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    Flowable<List<CommentEntity>> getAllByIdsImpl(List<String> commentIds, Boolean isSortByCreatedACS) {
        Integer _tmp_1;
        Integer _tmp;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT comment.* from comment where comment.commentId in (");
        int _inputSize = commentIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")  order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then comment.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then comment.createdAt end desc");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : commentIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        Integer n = isSortByCreatedACS == null ? null : (_tmp = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2 + _inputSize;
        Integer n2 = isSortByCreatedACS == null ? null : (_tmp_1 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"comment"}, (Callable)new Callable<List<CommentEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CommentEntity> call() throws Exception {
                try (Cursor _cursor = EkoCommentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfMyReactions = _cursor.getColumnIndexOrThrow("myReactions");
                    int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
                    int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
                    int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
                    int _cursorIndexOfRootId = _cursor.getColumnIndexOrThrow("rootId");
                    int _cursorIndexOfDataType = _cursor.getColumnIndexOrThrow("dataType");
                    int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
                    int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                    int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
                    int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
                    int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                    int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                    int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CommentEntity _item_1 = new CommentEntity();
                        String _tmp_2 = _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_2);
                        _item_1.setMyReactions(_tmpMyReactions);
                        String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                        _item_1.setCommentId(_tmpCommentId);
                        String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                        _item_1.setReferenceType(_tmpReferenceType);
                        String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                        _item_1.setReferenceId(_tmpReferenceId);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        _item_1.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        _item_1.setParentId(_tmpParentId);
                        String _tmpRootId = _cursor.getString(_cursorIndexOfRootId);
                        _item_1.setRootId(_tmpRootId);
                        String _tmpDataType = _cursor.getString(_cursorIndexOfDataType);
                        _item_1.setDataType(_tmpDataType);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                        _item_1.setData(_tmpData);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _item_1.setMetadata(_tmpMetadata);
                        Integer _tmpChildrenNumber = _cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfChildrenNumber));
                        _item_1.setChildrenNumber(_tmpChildrenNumber);
                        Integer _tmpFlagCount = _cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFlagCount));
                        _item_1.setFlagCount(_tmpFlagCount);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_5);
                        _item_1.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _item_1.setReactionCount(_tmpReactionCount);
                        Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                        Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                        _item_1.setDeleted(_tmpIsDeleted);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _item_1.setEditedAt(_tmpEditedAt);
                        String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                        _item_1.setSyncState(_tmpSyncState);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _item_1.setCreatedAt(_tmpCreatedAt);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _item_1.setUpdatedAt(_tmpUpdatedAt);
                        _result.add(_item_1);
                    }
                    ArrayList<CommentEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    DataSource.Factory<Integer, CommentEntity> getAllByParentIdImpl(String referenceType, String referenceId, String parentId, Boolean isDeleted, Boolean isSortByCreatedACS) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)7);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 5;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 6;
        Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 7;
        Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, CommentEntity>(){

            public LimitOffsetDataSource<CommentEntity> create() {
                return new LimitOffsetDataSource<CommentEntity>(EkoCommentDao_Impl.this.__db, _statement, false, new String[]{"comment", "comment_flag"}){

                    protected List<CommentEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfMyReactions = cursor.getColumnIndexOrThrow("myReactions");
                        int _cursorIndexOfCommentId = cursor.getColumnIndexOrThrow("commentId");
                        int _cursorIndexOfReferenceType = cursor.getColumnIndexOrThrow("referenceType");
                        int _cursorIndexOfReferenceId = cursor.getColumnIndexOrThrow("referenceId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfParentId = cursor.getColumnIndexOrThrow("parentId");
                        int _cursorIndexOfRootId = cursor.getColumnIndexOrThrow("rootId");
                        int _cursorIndexOfDataType = cursor.getColumnIndexOrThrow("dataType");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfChildrenNumber = cursor.getColumnIndexOrThrow("childrenNumber");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfSyncState = cursor.getColumnIndexOrThrow("syncState");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommentEntity> _res = new ArrayList<CommentEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommentEntity _item = new CommentEntity();
                            String _tmp_4 = cursor.getString(_cursorIndexOfMyReactions);
                            List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_4);
                            _item.setMyReactions(_tmpMyReactions);
                            String _tmpCommentId = cursor.getString(_cursorIndexOfCommentId);
                            _item.setCommentId(_tmpCommentId);
                            String _tmpReferenceType = cursor.getString(_cursorIndexOfReferenceType);
                            _item.setReferenceType(_tmpReferenceType);
                            String _tmpReferenceId = cursor.getString(_cursorIndexOfReferenceId);
                            _item.setReferenceId(_tmpReferenceId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpParentId = cursor.getString(_cursorIndexOfParentId);
                            _item.setParentId(_tmpParentId);
                            String _tmpRootId = cursor.getString(_cursorIndexOfRootId);
                            _item.setRootId(_tmpRootId);
                            String _tmpDataType = cursor.getString(_cursorIndexOfDataType);
                            _item.setDataType(_tmpDataType);
                            String _tmp_5 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                            _item.setData(_tmpData);
                            String _tmp_6 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpChildrenNumber = cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfChildrenNumber));
                            _item.setChildrenNumber(_tmpChildrenNumber);
                            Integer _tmpFlagCount = cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfFlagCount));
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_7 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_7);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_9 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmpSyncState = cursor.getString(_cursorIndexOfSyncState);
                            _item.setSyncState(_tmpSyncState);
                            String _tmp_10 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_11 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommentEntity> getAllByParentIdImpl(String referenceType, String referenceId, Boolean isDeleted, Boolean isSortByCreatedACS) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId is null and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId is null and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)6);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 5;
        Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 6;
        Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, CommentEntity>(){

            public LimitOffsetDataSource<CommentEntity> create() {
                return new LimitOffsetDataSource<CommentEntity>(EkoCommentDao_Impl.this.__db, _statement, false, new String[]{"comment", "comment_flag"}){

                    protected List<CommentEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfMyReactions = cursor.getColumnIndexOrThrow("myReactions");
                        int _cursorIndexOfCommentId = cursor.getColumnIndexOrThrow("commentId");
                        int _cursorIndexOfReferenceType = cursor.getColumnIndexOrThrow("referenceType");
                        int _cursorIndexOfReferenceId = cursor.getColumnIndexOrThrow("referenceId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfParentId = cursor.getColumnIndexOrThrow("parentId");
                        int _cursorIndexOfRootId = cursor.getColumnIndexOrThrow("rootId");
                        int _cursorIndexOfDataType = cursor.getColumnIndexOrThrow("dataType");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfChildrenNumber = cursor.getColumnIndexOrThrow("childrenNumber");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfSyncState = cursor.getColumnIndexOrThrow("syncState");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommentEntity> _res = new ArrayList<CommentEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommentEntity _item = new CommentEntity();
                            String _tmp_4 = cursor.getString(_cursorIndexOfMyReactions);
                            List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_4);
                            _item.setMyReactions(_tmpMyReactions);
                            String _tmpCommentId = cursor.getString(_cursorIndexOfCommentId);
                            _item.setCommentId(_tmpCommentId);
                            String _tmpReferenceType = cursor.getString(_cursorIndexOfReferenceType);
                            _item.setReferenceType(_tmpReferenceType);
                            String _tmpReferenceId = cursor.getString(_cursorIndexOfReferenceId);
                            _item.setReferenceId(_tmpReferenceId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpParentId = cursor.getString(_cursorIndexOfParentId);
                            _item.setParentId(_tmpParentId);
                            String _tmpRootId = cursor.getString(_cursorIndexOfRootId);
                            _item.setRootId(_tmpRootId);
                            String _tmpDataType = cursor.getString(_cursorIndexOfDataType);
                            _item.setDataType(_tmpDataType);
                            String _tmp_5 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                            _item.setData(_tmpData);
                            String _tmp_6 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpChildrenNumber = cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfChildrenNumber));
                            _item.setChildrenNumber(_tmpChildrenNumber);
                            Integer _tmpFlagCount = cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfFlagCount));
                            _item.setFlagCount(_tmpFlagCount);
                            String _tmp_7 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_7);
                            _item.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item.setReactionCount(_tmpReactionCount);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_9 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmpSyncState = cursor.getString(_cursorIndexOfSyncState);
                            _item.setSyncState(_tmpSyncState);
                            String _tmp_10 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_11 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommentEntity> getLatestCommentsImpl(String referenceId) {
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceId = ? and comment.commentId = comment_flag.commentId and comment.isDeleted = 0 and comment.parentId is null order by createdAt DESC LIMIT 5";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceId = ? and comment.commentId = comment_flag.commentId and comment.isDeleted = 0 and comment.parentId is null order by createdAt DESC LIMIT 5", (int)1);
        int _argIndex = 1;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfMyReactions = _cursor.getColumnIndexOrThrow("myReactions");
            int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
            int _cursorIndexOfRootId = _cursor.getColumnIndexOrThrow("rootId");
            int _cursorIndexOfDataType = _cursor.getColumnIndexOrThrow("dataType");
            int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
            int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CommentEntity _item = new CommentEntity();
                String _tmp = _cursor.getString(_cursorIndexOfMyReactions);
                List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp);
                _item.setMyReactions(_tmpMyReactions);
                String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                _item.setCommentId(_tmpCommentId);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                _item.setReferenceId(_tmpReferenceId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                String _tmpRootId = _cursor.getString(_cursorIndexOfRootId);
                _item.setRootId(_tmpRootId);
                String _tmpDataType = _cursor.getString(_cursorIndexOfDataType);
                _item.setDataType(_tmpDataType);
                String _tmp_1 = _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                _item.setData(_tmpData);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                _item.setMetadata(_tmpMetadata);
                Integer _tmpChildrenNumber = _cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfChildrenNumber));
                _item.setChildrenNumber(_tmpChildrenNumber);
                Integer _tmpFlagCount = _cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFlagCount));
                _item.setFlagCount(_tmpFlagCount);
                String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _item.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item.setReactionCount(_tmpReactionCount);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                Boolean _tmpIsDeleted = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                _item.setDeleted(_tmpIsDeleted);
                String _tmp_5 = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _item.setEditedAt(_tmpEditedAt);
                String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                _item.setSyncState(_tmpSyncState);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<CommentEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommentEntity> getLatestRepliesImpl(String parentId, String referenceType, String referenceId, boolean isSortByCreatedACS) {
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.parentId = ? and comment.referenceId = ? and comment.referenceType = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc LIMIT 5";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.parentId = ? and comment.referenceId = ? and comment.referenceType = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc LIMIT 5", (int)5);
        int _argIndex = 1;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 4;
        int _tmp = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 5;
        int _tmp_1 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfMyReactions = _cursor.getColumnIndexOrThrow("myReactions");
            int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
            int _cursorIndexOfRootId = _cursor.getColumnIndexOrThrow("rootId");
            int _cursorIndexOfDataType = _cursor.getColumnIndexOrThrow("dataType");
            int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
            int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CommentEntity _item = new CommentEntity();
                String _tmp_2 = _cursor.getString(_cursorIndexOfMyReactions);
                List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_2);
                _item.setMyReactions(_tmpMyReactions);
                String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                _item.setCommentId(_tmpCommentId);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                _item.setReferenceId(_tmpReferenceId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                String _tmpRootId = _cursor.getString(_cursorIndexOfRootId);
                _item.setRootId(_tmpRootId);
                String _tmpDataType = _cursor.getString(_cursorIndexOfDataType);
                _item.setDataType(_tmpDataType);
                String _tmp_3 = _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                _item.setData(_tmpData);
                String _tmp_4 = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item.setMetadata(_tmpMetadata);
                Integer _tmpChildrenNumber = _cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfChildrenNumber));
                _item.setChildrenNumber(_tmpChildrenNumber);
                Integer _tmpFlagCount = _cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFlagCount));
                _item.setFlagCount(_tmpFlagCount);
                String _tmp_5 = _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_5);
                _item.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item.setReactionCount(_tmpReactionCount);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                _item.setDeleted(_tmpIsDeleted);
                String _tmp_7 = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item.setEditedAt(_tmpEditedAt);
                String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                _item.setSyncState(_tmpSyncState);
                String _tmp_8 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_9 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<CommentEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<List<CommentEntity>> observeCommentAfterImpl(String referenceType, String referenceId, boolean isSortByCreatedACS, DateTime offsetCommentTime) {
        String _sql = "SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)5);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(offsetCommentTime);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 4;
        int _tmp_1 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 5;
        int _tmp_2 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"comment"}, (Callable)new Callable<List<CommentEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CommentEntity> call() throws Exception {
                try (Cursor _cursor = EkoCommentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfMyReactions = _cursor.getColumnIndexOrThrow("myReactions");
                    int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
                    int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
                    int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
                    int _cursorIndexOfRootId = _cursor.getColumnIndexOrThrow("rootId");
                    int _cursorIndexOfDataType = _cursor.getColumnIndexOrThrow("dataType");
                    int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
                    int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                    int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
                    int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
                    int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                    int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                    int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CommentEntity _item = new CommentEntity();
                        String _tmp_3 = _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_3);
                        _item.setMyReactions(_tmpMyReactions);
                        String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                        _item.setCommentId(_tmpCommentId);
                        String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                        _item.setReferenceType(_tmpReferenceType);
                        String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                        _item.setReferenceId(_tmpReferenceId);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        _item.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        _item.setParentId(_tmpParentId);
                        String _tmpRootId = _cursor.getString(_cursorIndexOfRootId);
                        _item.setRootId(_tmpRootId);
                        String _tmpDataType = _cursor.getString(_cursorIndexOfDataType);
                        _item.setDataType(_tmpDataType);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _item.setData(_tmpData);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                        _item.setMetadata(_tmpMetadata);
                        Integer _tmpChildrenNumber = _cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfChildrenNumber));
                        _item.setChildrenNumber(_tmpChildrenNumber);
                        Integer _tmpFlagCount = _cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFlagCount));
                        _item.setFlagCount(_tmpFlagCount);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_6);
                        _item.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _item.setReactionCount(_tmpReactionCount);
                        Integer _tmp_7 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                        Boolean _tmpIsDeleted = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                        _item.setDeleted(_tmpIsDeleted);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _item.setEditedAt(_tmpEditedAt);
                        String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                        _item.setSyncState(_tmpSyncState);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        _result.add(_item);
                    }
                    ArrayList<CommentEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<List<CommentEntity>> observeCommentAfterFilterByParentImpl(String referenceType, String referenceId, String parentId, boolean isSortByCreatedACS, DateTime offsetCommentTime) {
        String _sql = "SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.parentId = ? and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.parentId = ? and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)6);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 4;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(offsetCommentTime);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 5;
        int _tmp_1 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 6;
        int _tmp_2 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"comment"}, (Callable)new Callable<List<CommentEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CommentEntity> call() throws Exception {
                try (Cursor _cursor = EkoCommentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfMyReactions = _cursor.getColumnIndexOrThrow("myReactions");
                    int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
                    int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
                    int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
                    int _cursorIndexOfRootId = _cursor.getColumnIndexOrThrow("rootId");
                    int _cursorIndexOfDataType = _cursor.getColumnIndexOrThrow("dataType");
                    int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
                    int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                    int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
                    int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
                    int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                    int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                    int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CommentEntity _item = new CommentEntity();
                        String _tmp_3 = _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_3);
                        _item.setMyReactions(_tmpMyReactions);
                        String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                        _item.setCommentId(_tmpCommentId);
                        String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                        _item.setReferenceType(_tmpReferenceType);
                        String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                        _item.setReferenceId(_tmpReferenceId);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        _item.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        _item.setParentId(_tmpParentId);
                        String _tmpRootId = _cursor.getString(_cursorIndexOfRootId);
                        _item.setRootId(_tmpRootId);
                        String _tmpDataType = _cursor.getString(_cursorIndexOfDataType);
                        _item.setDataType(_tmpDataType);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _item.setData(_tmpData);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                        _item.setMetadata(_tmpMetadata);
                        Integer _tmpChildrenNumber = _cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfChildrenNumber));
                        _item.setChildrenNumber(_tmpChildrenNumber);
                        Integer _tmpFlagCount = _cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFlagCount));
                        _item.setFlagCount(_tmpFlagCount);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_6);
                        _item.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _item.setReactionCount(_tmpReactionCount);
                        Integer _tmp_7 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                        Boolean _tmpIsDeleted = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                        _item.setDeleted(_tmpIsDeleted);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _item.setEditedAt(_tmpEditedAt);
                        String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                        _item.setSyncState(_tmpSyncState);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        _result.add(_item);
                    }
                    ArrayList<CommentEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateTime getCommentCreatedTime(String commentId) {
        String _sql = "SELECT createdAt from comment where commentId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT createdAt from comment where commentId = ?", (int)1);
        int _argIndex = 1;
        if (commentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, commentId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            DateTime _result;
            if (_cursor.moveToFirst()) {
                String _tmp = _cursor.getString(0);
                _result = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
            } else {
                _result = null;
            }
            DateTime dateTime = _result;
            return dateTime;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CommentEntity getByCommentIdNowImpl(String commentId) {
        String _sql = "SELECT * from comment where comment.commentId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment where comment.commentId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (commentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, commentId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            CommentEntity _result;
            int _cursorIndexOfMyReactions = _cursor.getColumnIndexOrThrow("myReactions");
            int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
            int _cursorIndexOfRootId = _cursor.getColumnIndexOrThrow("rootId");
            int _cursorIndexOfDataType = _cursor.getColumnIndexOrThrow("dataType");
            int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
            int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new CommentEntity();
                String _tmp = _cursor.getString(_cursorIndexOfMyReactions);
                List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp);
                _result.setMyReactions(_tmpMyReactions);
                String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                _result.setCommentId(_tmpCommentId);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _result.setReferenceType(_tmpReferenceType);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                _result.setReferenceId(_tmpReferenceId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                _result.setParentId(_tmpParentId);
                String _tmpRootId = _cursor.getString(_cursorIndexOfRootId);
                _result.setRootId(_tmpRootId);
                String _tmpDataType = _cursor.getString(_cursorIndexOfDataType);
                _result.setDataType(_tmpDataType);
                String _tmp_1 = _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                _result.setData(_tmpData);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                _result.setMetadata(_tmpMetadata);
                Integer _tmpChildrenNumber = _cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfChildrenNumber));
                _result.setChildrenNumber(_tmpChildrenNumber);
                Integer _tmpFlagCount = _cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFlagCount));
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _result.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _result.setReactionCount(_tmpReactionCount);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                Boolean _tmpIsDeleted = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                _result.setDeleted(_tmpIsDeleted);
                String _tmp_5 = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setEditedAt(_tmpEditedAt);
                String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                _result.setSyncState(_tmpSyncState);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            CommentEntity commentEntity = _result;
            return commentEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CommentEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from comment where comment.commentId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment where comment.commentId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            CommentEntity _result;
            int _cursorIndexOfMyReactions = _cursor.getColumnIndexOrThrow("myReactions");
            int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
            int _cursorIndexOfRootId = _cursor.getColumnIndexOrThrow("rootId");
            int _cursorIndexOfDataType = _cursor.getColumnIndexOrThrow("dataType");
            int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
            int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new CommentEntity();
                String _tmp = _cursor.getString(_cursorIndexOfMyReactions);
                List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp);
                _result.setMyReactions(_tmpMyReactions);
                String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                _result.setCommentId(_tmpCommentId);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _result.setReferenceType(_tmpReferenceType);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                _result.setReferenceId(_tmpReferenceId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                _result.setParentId(_tmpParentId);
                String _tmpRootId = _cursor.getString(_cursorIndexOfRootId);
                _result.setRootId(_tmpRootId);
                String _tmpDataType = _cursor.getString(_cursorIndexOfDataType);
                _result.setDataType(_tmpDataType);
                String _tmp_1 = _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                _result.setData(_tmpData);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                _result.setMetadata(_tmpMetadata);
                Integer _tmpChildrenNumber = _cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfChildrenNumber));
                _result.setChildrenNumber(_tmpChildrenNumber);
                Integer _tmpFlagCount = _cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFlagCount));
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _result.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _result.setReactionCount(_tmpReactionCount);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                Boolean _tmpIsDeleted = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                _result.setDeleted(_tmpIsDeleted);
                String _tmp_5 = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setEditedAt(_tmpEditedAt);
                String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                _result.setSyncState(_tmpSyncState);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            CommentEntity commentEntity = _result;
            return commentEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommentEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from comment where comment.commentId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfMyReactions = _cursor.getColumnIndexOrThrow("myReactions");
            int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
            int _cursorIndexOfRootId = _cursor.getColumnIndexOrThrow("rootId");
            int _cursorIndexOfDataType = _cursor.getColumnIndexOrThrow("dataType");
            int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
            int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CommentEntity _item_1 = new CommentEntity();
                String _tmp = _cursor.getString(_cursorIndexOfMyReactions);
                List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp);
                _item_1.setMyReactions(_tmpMyReactions);
                String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                _item_1.setCommentId(_tmpCommentId);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _item_1.setReferenceType(_tmpReferenceType);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                _item_1.setReferenceId(_tmpReferenceId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _item_1.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                _item_1.setParentId(_tmpParentId);
                String _tmpRootId = _cursor.getString(_cursorIndexOfRootId);
                _item_1.setRootId(_tmpRootId);
                String _tmpDataType = _cursor.getString(_cursorIndexOfDataType);
                _item_1.setDataType(_tmpDataType);
                String _tmp_1 = _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                _item_1.setData(_tmpData);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                _item_1.setMetadata(_tmpMetadata);
                Integer _tmpChildrenNumber = _cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfChildrenNumber));
                _item_1.setChildrenNumber(_tmpChildrenNumber);
                Integer _tmpFlagCount = _cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFlagCount));
                _item_1.setFlagCount(_tmpFlagCount);
                String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _item_1.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item_1.setReactionCount(_tmpReactionCount);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                Boolean _tmpIsDeleted = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmp_5 = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _item_1.setEditedAt(_tmpEditedAt);
                String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                _item_1.setSyncState(_tmpSyncState);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item_1);
            }
            ArrayList<CommentEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<CommentEntity> getByIdImpl(String commentId) {
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.commentId = ? and comment.commentId = comment_flag.commentId LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.commentId = ? and comment.commentId = comment_flag.commentId LIMIT 1", (int)1);
        int _argIndex = 1;
        if (commentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, commentId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"comment", "comment_flag"}, (Callable)new Callable<CommentEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommentEntity call() throws Exception {
                try (Cursor _cursor = EkoCommentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    CommentEntity _result;
                    int _cursorIndexOfMyReactions = _cursor.getColumnIndexOrThrow("myReactions");
                    int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
                    int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
                    int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
                    int _cursorIndexOfRootId = _cursor.getColumnIndexOrThrow("rootId");
                    int _cursorIndexOfDataType = _cursor.getColumnIndexOrThrow("dataType");
                    int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
                    int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                    int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
                    int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
                    int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                    int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                    int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new CommentEntity();
                        String _tmp = _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp);
                        _result.setMyReactions(_tmpMyReactions);
                        String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                        _result.setCommentId(_tmpCommentId);
                        String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                        _result.setReferenceType(_tmpReferenceType);
                        String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                        _result.setReferenceId(_tmpReferenceId);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        String _tmpRootId = _cursor.getString(_cursorIndexOfRootId);
                        _result.setRootId(_tmpRootId);
                        String _tmpDataType = _cursor.getString(_cursorIndexOfDataType);
                        _result.setDataType(_tmpDataType);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                        _result.setData(_tmpData);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                        _result.setMetadata(_tmpMetadata);
                        Integer _tmpChildrenNumber = _cursor.isNull(_cursorIndexOfChildrenNumber) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfChildrenNumber));
                        _result.setChildrenNumber(_tmpChildrenNumber);
                        Integer _tmpFlagCount = _cursor.isNull(_cursorIndexOfFlagCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfFlagCount));
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        Integer _tmp_4 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                        Boolean _tmpIsDeleted = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setEditedAt(_tmpEditedAt);
                        String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    CommentEntity commentEntity = _result;
                    return commentEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

