/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembershipSortOption;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelRoleDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoRoleDao;
import com.ekoapp.ekosdk.internal.data.model.ChannelMembershipPermissionEntity;
import com.ekoapp.ekosdk.internal.data.model.ChannelMembershipRoleEntity;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.google.common.base.Optional;
import io.reactivex.Flowable;
import java.util.List;

@Dao
public abstract class EkoChannelMembershipDao
extends EkoObjectDao<ChannelMembershipEntity> {
    private final EkoChannelRoleDao channelRoleDao;
    private final EkoChannelPermissionDao channelPermissionDao;

    EkoChannelMembershipDao() {
        UserDatabase db = UserDatabase.get();
        this.channelRoleDao = db.channelRoleDao();
        this.channelPermissionDao = db.channelPermissionDao();
    }

    @Query(value="UPDATE channel_membership set membership = :membership where channelId = :channelId and userId = :userId")
    public abstract void updateMembership(String var1, String var2, String var3);

    @Query(value="UPDATE channel_membership set readToSegment = :readToSegment where channelId = :channelId and userId = :userId and readToSegment < :readToSegment")
    public abstract void updateReadToSegment(String var1, String var2, int var3);

    @Override
    @Query(value="DELETE from channel_membership")
    public abstract void deleteAll();

    @Query(value="DELETE from channel_membership where channelId = :channelId")
    public abstract void deleteAllFromChannel(String var1);

    @Query(value="SELECT * from channel_membership where channelId = :channelId and userId = :userId LIMIT 1")
    abstract Flowable<ChannelMembershipEntity> getByIdWithUserIdImpl(String var1, String var2);

    public Flowable<ChannelMembershipEntity> getByIdWithUserId(String channelId, String userId) {
        return this.getByIdWithUserIdImpl(channelId, userId);
    }

    @Query(value="SELECT * from channel_membership where channelId = :channelId and membership in (:memberships) order by case when :isSortByDisplayName = 1 then channel_membership.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then channel_membership.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then channel_membership.createdAt end desc")
    abstract DataSource.Factory<Integer, ChannelMembershipEntity> getAllByMembershipImpl(String var1, List<String> var2, boolean var3, boolean var4);

    @Query(value="SELECT * from channel_membership where channelId = :channelId and membership in (:memberships) and isMuted = :isMuted order by case when :isSortByDisplayName = 1 then channel_membership.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then channel_membership.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then channel_membership.createdAt end desc")
    abstract DataSource.Factory<Integer, ChannelMembershipEntity> getAllByMembershipAndIsMutedImpl(String var1, List<String> var2, boolean var3, boolean var4, boolean var5);

    public DataSource.Factory<Integer, ChannelMembershipEntity> getAllByMembership(String channelId, List<String> memberships, Optional<Boolean> isMuted, AmityChannelMembershipSortOption sortBy) {
        return (isMuted.isPresent() ? this.getAllByMembershipAndIsMutedImpl(channelId, memberships, (Boolean)isMuted.get(), this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy)) : this.getAllByMembershipImpl(channelId, memberships, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy))).map(input -> input);
    }

    @Query(value="SELECT * from channel_membership where channelId = :channelId and membership in (:memberships) and userId in (SELECT userId from channel_role where channelId= :channelId and roleName in (:role)) order by case when :isSortByDisplayName = 1 then channel_membership.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then channel_membership.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then channel_membership.createdAt end desc")
    abstract DataSource.Factory<Integer, ChannelMembershipEntity> getAllByMembershipWithRoleImpl(String var1, List<String> var2, List<String> var3, boolean var4, boolean var5);

    @Query(value="SELECT * from channel_membership where channelId = :channelId and membership in (:memberships) and isMuted = :isMuted and channelId in (SELECT channelId from channel_role where roleName in (:role)) order by case when :isSortByDisplayName = 1 then channel_membership.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then channel_membership.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then channel_membership.createdAt end desc")
    abstract DataSource.Factory<Integer, ChannelMembershipEntity> getAllByMembershipAndIsMutedWithRoleImpl(String var1, List<String> var2, List<String> var3, boolean var4, boolean var5, boolean var6);

    public DataSource.Factory<Integer, ChannelMembershipEntity> getAllByMembershipWithRole(String channelId, List<String> role, List<String> memberships, Optional<Boolean> isMuted, AmityChannelMembershipSortOption sortBy) {
        return (isMuted.isPresent() ? this.getAllByMembershipAndIsMutedWithRoleImpl(channelId, role, memberships, (Boolean)isMuted.get(), this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy)) : this.getAllByMembershipWithRoleImpl(channelId, role, memberships, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy))).map(input -> input);
    }

    private Boolean isSortByDisplayName(AmityChannelMembershipSortOption sortBy) {
        return false;
    }

    private Boolean isSortByCreatedACS(AmityChannelMembershipSortOption sortBy) {
        return sortBy == AmityChannelMembershipSortOption.FIRST_CREATED;
    }

    @Override
    @Transaction
    public void insert(ChannelMembershipEntity membership) {
        super.insert(membership);
        EkoRoleDao.update(membership, this.channelRoleDao, ChannelMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.channelPermissionDao, ChannelMembershipPermissionEntity::create);
    }

    @Override
    @Transaction
    public void insert(List<ChannelMembershipEntity> memberships) {
        super.insert(memberships);
        EkoRoleDao.update(memberships, this.channelRoleDao, ChannelMembershipRoleEntity::create);
        EkoPermissionDao.update(memberships, this.channelPermissionDao, ChannelMembershipPermissionEntity::create);
    }

    @Override
    public void update(ChannelMembershipEntity membership) {
        super.update(membership);
        EkoRoleDao.update(membership, this.channelRoleDao, ChannelMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.channelPermissionDao, ChannelMembershipPermissionEntity::create);
    }

    @Transaction
    public void updateUser(String userId) {
        this.updateUserImpl(userId);
    }

    @Query(value="UPDATE channel_membership set userId = :userId where userId = :userId")
    abstract void updateUserImpl(String var1);
}

