/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EmptyResultSetException;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.internal.data.converter.EkoChannelReadStatusTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoChannelExtraDao_Impl
extends EkoChannelExtraDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEkoChannelExtra;
    private final EkoChannelReadStatusTypeConverter __ekoChannelReadStatusTypeConverter = new EkoChannelReadStatusTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfEkoChannelExtra;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfEkoChannelExtra;
    private final SharedSQLiteStatement __preparedStmtOfUpdateAllReadStatuses;
    private final SharedSQLiteStatement __preparedStmtOfUpdateReadStatus;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLocalReadToSegment;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllFromChannel;

    public EkoChannelExtraDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoChannelExtra = new EntityInsertionAdapter<EkoChannelExtra>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel_extra`(`channelId`,`readStatus`,`localReadToSegment`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelExtra value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                String _tmp = EkoChannelExtraDao_Impl.this.__ekoChannelReadStatusTypeConverter.readStatusToString(value.getReadStatus());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                stmt.bindLong(3, (long)value.getLocalReadToSegment());
                String _tmp_1 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfEkoChannelExtra = new EntityDeletionOrUpdateAdapter<EkoChannelExtra>(__db){

            public String createQuery() {
                return "DELETE FROM `channel_extra` WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelExtra value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
            }
        };
        this.__updateAdapterOfEkoChannelExtra = new EntityDeletionOrUpdateAdapter<EkoChannelExtra>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `channel_extra` SET `channelId` = ?,`readStatus` = ?,`localReadToSegment` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelExtra value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                String _tmp = EkoChannelExtraDao_Impl.this.__ekoChannelReadStatusTypeConverter.readStatusToString(value.getReadStatus());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                stmt.bindLong(3, (long)value.getLocalReadToSegment());
                String _tmp_1 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getChannelId());
                }
            }
        };
        this.__preparedStmtOfUpdateAllReadStatuses = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel_extra set readStatus = ? where readStatus != ?";
                return "UPDATE channel_extra set readStatus = ? where readStatus != ?";
            }
        };
        this.__preparedStmtOfUpdateReadStatus = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel_extra set readStatus = ? where channelId = ?";
                return "UPDATE channel_extra set readStatus = ? where channelId = ?";
            }
        };
        this.__preparedStmtOfUpdateLocalReadToSegment = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel_extra set localReadToSegment = ? where channelId = ? and localReadToSegment < ?";
                return "UPDATE channel_extra set localReadToSegment = ? where channelId = ? and localReadToSegment < ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_extra";
                return "DELETE from channel_extra";
            }
        };
        this.__preparedStmtOfDeleteAllFromChannel = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel_extra where channelId = ?";
                return "DELETE from channel_extra where channelId = ?";
            }
        };
    }

    @Override
    void insertImpl(EkoChannelExtra object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoChannelExtra.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoChannelExtra> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoChannelExtra.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoChannelExtra object) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoChannelExtra.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoChannelExtra> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoChannelExtra.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoChannelExtra object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoChannelExtra.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoChannelExtra object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoChannelExtra> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoChannelExtra object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertOrUpdate(String id) {
        this.__db.beginTransaction();
        try {
            super.insertOrUpdate(id);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllReadStatuses(EkoChannelReadStatus status) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateAllReadStatuses.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            String _tmp = this.__ekoChannelReadStatusTypeConverter.readStatusToString(status);
            if (_tmp == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _tmp);
            }
            _argIndex = 2;
            String _tmp_1 = this.__ekoChannelReadStatusTypeConverter.readStatusToString(status);
            if (_tmp_1 == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _tmp_1);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateAllReadStatuses.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReadStatus(String id, EkoChannelReadStatus readMode) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateReadStatus.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            String _tmp = this.__ekoChannelReadStatusTypeConverter.readStatusToString(readMode);
            if (_tmp == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _tmp);
            }
            _argIndex = 2;
            if (id == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, id);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateReadStatus.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLocalReadToSegment(String channelId, int localReadToSegment) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLocalReadToSegment.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)localReadToSegment);
            _argIndex = 2;
            if (channelId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, channelId);
            }
            _argIndex = 3;
            _stmt.bindLong(_argIndex, (long)localReadToSegment);
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLocalReadToSegment.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllFromChannel(String channelId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllFromChannel.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (channelId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, channelId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllFromChannel.release(_stmt);
        }
    }

    @Override
    public Flowable<EkoChannelExtra> getById(String id) {
        String _sql = "SELECT * from channel_extra where channelId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_extra where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"channel_extra"}, (Callable)new Callable<EkoChannelExtra>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoChannelExtra call() throws Exception {
                try (Cursor _cursor = EkoChannelExtraDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    EkoChannelExtra _result;
                    int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
                    int _cursorIndexOfReadStatus = _cursor.getColumnIndexOrThrow("readStatus");
                    int _cursorIndexOfLocalReadToSegment = _cursor.getColumnIndexOrThrow("localReadToSegment");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        _result = new EkoChannelExtra(_tmpChannelId);
                        String _tmp = _cursor.getString(_cursorIndexOfReadStatus);
                        EkoChannelReadStatus _tmpReadStatus = EkoChannelExtraDao_Impl.this.__ekoChannelReadStatusTypeConverter.stringToReadStatus(_tmp);
                        _result.setReadStatus(_tmpReadStatus);
                        int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                        _result.setLocalReadToSegment(_tmpLocalReadToSegment);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoChannelExtraDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoChannelExtra ekoChannelExtra = _result;
                    return ekoChannelExtra;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelExtra getByIdNow(String id) {
        String _sql = "SELECT * from channel_extra where channelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from channel_extra where channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            EkoChannelExtra _result;
            int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
            int _cursorIndexOfReadStatus = _cursor.getColumnIndexOrThrow("readStatus");
            int _cursorIndexOfLocalReadToSegment = _cursor.getColumnIndexOrThrow("localReadToSegment");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                _result = new EkoChannelExtra(_tmpChannelId);
                String _tmp = _cursor.getString(_cursorIndexOfReadStatus);
                EkoChannelReadStatus _tmpReadStatus = this.__ekoChannelReadStatusTypeConverter.stringToReadStatus(_tmp);
                _result.setReadStatus(_tmpReadStatus);
                int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                _result.setLocalReadToSegment(_tmpLocalReadToSegment);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_2 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            EkoChannelExtra ekoChannelExtra = _result;
            return ekoChannelExtra;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Single<List<String>> getAllIdsByReadStatus(EkoChannelReadStatus readStatus) {
        String _sql = "SELECT channelId from channel_extra where readStatus = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channelId from channel_extra where readStatus = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__ekoChannelReadStatusTypeConverter.readStatusToString(readStatus);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return Single.fromCallable((Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> call() throws Exception {
                try (Cursor _cursor = EkoChannelExtraDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _item = _cursor.getString(0);
                        _result.add(_item);
                    }
                    if (_result == null) {
                        throw new EmptyResultSetException("Query returned empty result set: " + _statement.getSql());
                    }
                    ArrayList<String> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

