/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data;

import android.content.Context;
import android.os.Build;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipQueryTokenDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelPermissionDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelRoleDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelRoleDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelTagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelTagDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityCategoryDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityCategoryDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityPermissionDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityRoleDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityRoleDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityWithCategoryDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityWithCategoryDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoGlobalPostDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoGlobalPostDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoInternalReactionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoInternalReactionDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageFlagDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageTagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageTagDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoPostFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoPostFlagDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoStandardPostDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoStandardPostDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoStreamDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoStreamDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoStreamSessionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoStreamSessionDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserFlagDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.RecommendedCommunityDao;
import com.ekoapp.ekosdk.internal.data.dao.RecommendedCommunityDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.TrendingCommunityDao;
import com.ekoapp.ekosdk.internal.data.dao.TrendingCommunityDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public final class UserDatabase_Impl
extends UserDatabase {
    private volatile EkoChannelDao _ekoChannelDao;
    private volatile EkoChannelTagDao _ekoChannelTagDao;
    private volatile EkoChannelRoleDao _ekoChannelRoleDao;
    private volatile EkoChannelPermissionDao _ekoChannelPermissionDao;
    private volatile EkoCommunityRoleDao _ekoCommunityRoleDao;
    private volatile EkoCommunityPermissionDao _ekoCommunityPermissionDao;
    private volatile EkoChannelMembershipDao _ekoChannelMembershipDao;
    private volatile EkoChannelMembershipQueryTokenDao _ekoChannelMembershipQueryTokenDao;
    private volatile EkoChannelExtraDao _ekoChannelExtraDao;
    private volatile EkoMessageDao _ekoMessageDao;
    private volatile EkoMessageTagDao _ekoMessageTagDao;
    private volatile EkoInternalReactionDao _ekoInternalReactionDao;
    private volatile EkoMessageFlagDao _ekoMessageFlagDao;
    private volatile EkoUserDao _ekoUserDao;
    private volatile EkoUserFlagDao _ekoUserFlagDao;
    private volatile EkoStandardPostDao _ekoStandardPostDao;
    private volatile EkoPostFlagDao _ekoPostFlagDao;
    private volatile EkoCommentDao _ekoCommentDao;
    private volatile EkoCommentFlagDao _ekoCommentFlagDao;
    private volatile EkoCommunityDao _ekoCommunityDao;
    private volatile EkoCommunityCategoryDao _ekoCommunityCategoryDao;
    private volatile EkoCommunityMembershipDao _ekoCommunityMembershipDao;
    private volatile EkoFileDao _ekoFileDao;
    private volatile EkoCommunityWithCategoryDao _ekoCommunityWithCategoryDao;
    private volatile EkoGlobalPostDao _ekoGlobalPostDao;
    private volatile RecommendedCommunityDao _recommendedCommunityDao;
    private volatile TrendingCommunityDao _trendingCommunityDao;
    private volatile EkoStreamDao _ekoStreamDao;
    private volatile EkoStreamSessionDao _ekoStreamSessionDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(50003000){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `channel` (`channelId` TEXT NOT NULL, `displayName` TEXT, `metadata` TEXT, `messageCount` INTEGER NOT NULL, `isRateLimited` INTEGER NOT NULL, `isMuted` INTEGER NOT NULL, `lastActivity` TEXT, `memberCount` INTEGER NOT NULL, `tags` TEXT, `channelType` TEXT, `avatarFileId` TEXT, `isDeleted` INTEGER NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`channelId`))");
                _db.execSQL("CREATE  INDEX `index_channel_channelId` ON `channel` (`channelId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `channel_tag` (`channelId` TEXT NOT NULL, `tagName` TEXT NOT NULL, PRIMARY KEY(`channelId`, `tagName`), FOREIGN KEY(`channelId`) REFERENCES `channel`(`channelId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `channel_membership` (`channelId` TEXT NOT NULL, `userId` TEXT NOT NULL, `readToSegment` INTEGER NOT NULL, `membership` TEXT, `isMuted` INTEGER, `isBanned` INTEGER, `roles` TEXT, `permissions` TEXT, `displayName` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`channelId`, `userId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `channel_role` (`channelId` TEXT NOT NULL, `userId` TEXT NOT NULL, `roleName` TEXT NOT NULL, PRIMARY KEY(`channelId`, `userId`, `roleName`), FOREIGN KEY(`channelId`, `userId`) REFERENCES `channel_membership`(`channelId`, `userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `channel_permission` (`channelId` TEXT NOT NULL, `userId` TEXT NOT NULL, `permissionName` TEXT NOT NULL, PRIMARY KEY(`channelId`, `userId`, `permissionName`), FOREIGN KEY(`channelId`, `userId`) REFERENCES `channel_membership`(`channelId`, `userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `community_role` (`communityId` TEXT NOT NULL, `userId` TEXT NOT NULL, `roleName` TEXT NOT NULL, PRIMARY KEY(`communityId`, `userId`, `roleName`), FOREIGN KEY(`communityId`, `userId`) REFERENCES `community_membership`(`communityId`, `userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `community_permission` (`communityId` TEXT NOT NULL, `userId` TEXT NOT NULL, `permissionName` TEXT NOT NULL, PRIMARY KEY(`communityId`, `userId`, `permissionName`), FOREIGN KEY(`communityId`, `userId`) REFERENCES `community_membership`(`communityId`, `userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `channel_query_token` (`filter` TEXT NOT NULL, `includingTags` TEXT NOT NULL, `excludingTags` TEXT NOT NULL, `previous` TEXT, `next` TEXT, PRIMARY KEY(`filter`, `includingTags`, `excludingTags`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `channel_membership_query_token` (`channelId` TEXT NOT NULL, `filter` TEXT NOT NULL, `previous` TEXT, `next` TEXT, PRIMARY KEY(`channelId`, `filter`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `channel_extra` (`channelId` TEXT NOT NULL, `readStatus` TEXT, `localReadToSegment` INTEGER NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`channelId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `message` (`messageId` TEXT NOT NULL, `channelId` TEXT NOT NULL, `userId` TEXT NOT NULL, `parentId` TEXT, `channelSegment` INTEGER NOT NULL, `childrenNumber` INTEGER NOT NULL, `editedAt` TEXT, `isDeleted` INTEGER NOT NULL, `readByCount` INTEGER NOT NULL, `flagCount` INTEGER NOT NULL, `tags` TEXT, `reactions` TEXT NOT NULL, `reactionCount` INTEGER NOT NULL, `type` TEXT NOT NULL, `data` TEXT, `fileId` TEXT, `syncState` TEXT NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`messageId`))");
                _db.execSQL("CREATE  INDEX `index_message_channelId` ON `message` (`channelId`)");
                _db.execSQL("CREATE  INDEX `index_message_syncState` ON `message` (`syncState`)");
                _db.execSQL("CREATE  INDEX `index_message_channelId_createdAt` ON `message` (`channelId`, `createdAt`)");
                _db.execSQL("CREATE  INDEX `index_message_channelId_channelSegment` ON `message` (`channelId`, `channelSegment`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `message_tag` (`messageId` TEXT NOT NULL, `tagName` TEXT NOT NULL, PRIMARY KEY(`messageId`, `tagName`), FOREIGN KEY(`messageId`) REFERENCES `message`(`messageId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `reaction` (`reactionId` TEXT, `reactionName` TEXT NOT NULL, `userId` TEXT NOT NULL, `userDisplayName` TEXT, `referenceId` TEXT NOT NULL, `referenceType` TEXT NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`userId`, `reactionName`, `referenceType`, `referenceId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `message_flag` (`messageId` TEXT NOT NULL, `flag` TEXT, `localFlag` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`messageId`), FOREIGN KEY(`messageId`) REFERENCES `message`(`messageId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `user` (`userId` TEXT NOT NULL, `displayName` TEXT, `roles` TEXT, `permissions` TEXT, `flagCount` INTEGER NOT NULL, `metadata` TEXT, `avatarFileId` TEXT, `avatarCustomUrl` TEXT, `description` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`userId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `user_flag` (`userId` TEXT NOT NULL, `flag` TEXT, `localFlag` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `user`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `standard_post` (`postId` TEXT NOT NULL, `parentPostId` TEXT, `postedUserId` TEXT, `sharedUserId` TEXT, `metadata` TEXT, `sharedCount` INTEGER NOT NULL, `reactions` TEXT, `reactionCount` INTEGER NOT NULL, `commentCount` INTEGER NOT NULL, `flagCount` INTEGER NOT NULL, `editedAt` TEXT, `isDeleted` INTEGER NOT NULL, `targetType` TEXT, `targetId` TEXT, `postDataType` TEXT, `data` TEXT, `childPostIds` TEXT NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`postId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `comment` (`myReactions` TEXT NOT NULL, `commentId` TEXT NOT NULL, `referenceType` TEXT, `referenceId` TEXT, `userId` TEXT, `parentId` TEXT, `rootId` TEXT, `dataType` TEXT, `data` TEXT, `metadata` TEXT, `childrenNumber` INTEGER, `flagCount` INTEGER, `reactions` TEXT, `reactionCount` INTEGER NOT NULL, `isDeleted` INTEGER, `editedAt` TEXT, `syncState` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`commentId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `post_flag` (`postId` TEXT NOT NULL, `flag` TEXT, `localFlag` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`postId`), FOREIGN KEY(`postId`) REFERENCES `standard_post`(`postId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `comment_flag` (`commentId` TEXT NOT NULL, `flag` TEXT, `localFlag` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`commentId`), FOREIGN KEY(`commentId`) REFERENCES `comment`(`commentId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `community` (`communityId` TEXT NOT NULL, `channelId` TEXT, `userId` TEXT, `displayName` TEXT, `description` TEXT, `avatarFileId` TEXT, `isOfficial` INTEGER, `isPublic` INTEGER, `onlyAdminCanPost` INTEGER, `tags` TEXT, `metadata` TEXT, `postsCount` INTEGER, `membersCount` INTEGER, `isJoined` INTEGER, `isDeleted` INTEGER, `editedAt` TEXT, `categoryIds` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`communityId`))");
                _db.execSQL("CREATE  INDEX `index_community_communityId` ON `community` (`communityId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `community_category` (`categoryId` TEXT NOT NULL, `name` TEXT NOT NULL, `avatarFileId` TEXT, `metadata` TEXT, `isDeleted` INTEGER NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`categoryId`))");
                _db.execSQL("CREATE  INDEX `index_community_category_categoryId` ON `community_category` (`categoryId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `community_membership` (`userId` TEXT NOT NULL, `communityId` TEXT NOT NULL, `channelId` TEXT, `metadata` TEXT, `communityMembership` TEXT, `isBanned` INTEGER, `roles` TEXT, `permissions` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`communityId`, `userId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `file` (`fileId` TEXT NOT NULL, `fileUrl` TEXT, `filePath` TEXT, `type` TEXT, `attributes` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`fileId`))");
                _db.execSQL("CREATE  INDEX `index_file_fileId` ON `file` (`fileId`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `category` (`communityId` TEXT NOT NULL, `categoryId` TEXT NOT NULL, PRIMARY KEY(`communityId`, `categoryId`), FOREIGN KEY(`communityId`) REFERENCES `community`(`communityId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `global_post` (`postId` TEXT NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`postId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `recommended_community` (`communityId` TEXT NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`communityId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `trending_community` (`communityId` TEXT NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`communityId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `stream` (`streamId` TEXT NOT NULL, `title` TEXT, `description` TEXT, `metadata` TEXT, `isDeleted` INTEGER NOT NULL, `thumbnailFileId` TEXT, `userId` TEXT, `watcherData` TEXT, `broadcasterData` TEXT, `recordings` TEXT, `status` TEXT, `isReconnecting` INTEGER NOT NULL, `resolution` TEXT, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`streamId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `stream_session` (`sessionId` TEXT NOT NULL, `streamId` TEXT, `title` TEXT, `watchSeconds` INTEGER NOT NULL, `startTime` TEXT, `endTime` TEXT, `resolution` TEXT, `syncState` TEXT NOT NULL, `syncedAt` TEXT, `retryCount` INTEGER NOT NULL, `createdAt` TEXT, `updatedAt` TEXT, PRIMARY KEY(`sessionId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, \"a4b2c95fe5b7e22079a78c0e4dde4e16\")");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `channel`");
                _db.execSQL("DROP TABLE IF EXISTS `channel_tag`");
                _db.execSQL("DROP TABLE IF EXISTS `channel_membership`");
                _db.execSQL("DROP TABLE IF EXISTS `channel_role`");
                _db.execSQL("DROP TABLE IF EXISTS `channel_permission`");
                _db.execSQL("DROP TABLE IF EXISTS `community_role`");
                _db.execSQL("DROP TABLE IF EXISTS `community_permission`");
                _db.execSQL("DROP TABLE IF EXISTS `channel_query_token`");
                _db.execSQL("DROP TABLE IF EXISTS `channel_membership_query_token`");
                _db.execSQL("DROP TABLE IF EXISTS `channel_extra`");
                _db.execSQL("DROP TABLE IF EXISTS `message`");
                _db.execSQL("DROP TABLE IF EXISTS `message_tag`");
                _db.execSQL("DROP TABLE IF EXISTS `reaction`");
                _db.execSQL("DROP TABLE IF EXISTS `message_flag`");
                _db.execSQL("DROP TABLE IF EXISTS `user`");
                _db.execSQL("DROP TABLE IF EXISTS `user_flag`");
                _db.execSQL("DROP TABLE IF EXISTS `standard_post`");
                _db.execSQL("DROP TABLE IF EXISTS `comment`");
                _db.execSQL("DROP TABLE IF EXISTS `post_flag`");
                _db.execSQL("DROP TABLE IF EXISTS `comment_flag`");
                _db.execSQL("DROP TABLE IF EXISTS `community`");
                _db.execSQL("DROP TABLE IF EXISTS `community_category`");
                _db.execSQL("DROP TABLE IF EXISTS `community_membership`");
                _db.execSQL("DROP TABLE IF EXISTS `file`");
                _db.execSQL("DROP TABLE IF EXISTS `category`");
                _db.execSQL("DROP TABLE IF EXISTS `global_post`");
                _db.execSQL("DROP TABLE IF EXISTS `recommended_community`");
                _db.execSQL("DROP TABLE IF EXISTS `trending_community`");
                _db.execSQL("DROP TABLE IF EXISTS `stream`");
                _db.execSQL("DROP TABLE IF EXISTS `stream_session`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (UserDatabase_Impl.this.mCallbacks != null) {
                    int _size = UserDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)UserDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                UserDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                UserDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (UserDatabase_Impl.this.mCallbacks != null) {
                    int _size = UserDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)UserDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsChannel = new HashMap<String, TableInfo.Column>(14);
                _columnsChannel.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 1));
                _columnsChannel.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0));
                _columnsChannel.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0));
                _columnsChannel.put("messageCount", new TableInfo.Column("messageCount", "INTEGER", true, 0));
                _columnsChannel.put("isRateLimited", new TableInfo.Column("isRateLimited", "INTEGER", true, 0));
                _columnsChannel.put("isMuted", new TableInfo.Column("isMuted", "INTEGER", true, 0));
                _columnsChannel.put("lastActivity", new TableInfo.Column("lastActivity", "TEXT", false, 0));
                _columnsChannel.put("memberCount", new TableInfo.Column("memberCount", "INTEGER", true, 0));
                _columnsChannel.put("tags", new TableInfo.Column("tags", "TEXT", false, 0));
                _columnsChannel.put("channelType", new TableInfo.Column("channelType", "TEXT", false, 0));
                _columnsChannel.put("avatarFileId", new TableInfo.Column("avatarFileId", "TEXT", false, 0));
                _columnsChannel.put("isDeleted", new TableInfo.Column("isDeleted", "INTEGER", true, 0));
                _columnsChannel.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsChannel.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysChannel = new HashSet(0);
                HashSet<TableInfo.Index> _indicesChannel = new HashSet<TableInfo.Index>(1);
                _indicesChannel.add(new TableInfo.Index("index_channel_channelId", false, Arrays.asList("channelId")));
                TableInfo _infoChannel = new TableInfo("channel", _columnsChannel, _foreignKeysChannel, _indicesChannel);
                TableInfo _existingChannel = TableInfo.read((SupportSQLiteDatabase)_db, (String)"channel");
                if (!_infoChannel.equals((Object)_existingChannel)) {
                    throw new IllegalStateException("Migration didn't properly handle channel(com.ekoapp.ekosdk.internal.EkoChannelEntity).\n Expected:\n" + _infoChannel + "\n Found:\n" + _existingChannel);
                }
                HashMap<String, TableInfo.Column> _columnsChannelTag = new HashMap<String, TableInfo.Column>(2);
                _columnsChannelTag.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 1));
                _columnsChannelTag.put("tagName", new TableInfo.Column("tagName", "TEXT", true, 2));
                HashSet<TableInfo.ForeignKey> _foreignKeysChannelTag = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysChannelTag.add(new TableInfo.ForeignKey("channel", "CASCADE", "NO ACTION", Arrays.asList("channelId"), Arrays.asList("channelId")));
                HashSet _indicesChannelTag = new HashSet(0);
                TableInfo _infoChannelTag = new TableInfo("channel_tag", _columnsChannelTag, _foreignKeysChannelTag, _indicesChannelTag);
                TableInfo _existingChannelTag = TableInfo.read((SupportSQLiteDatabase)_db, (String)"channel_tag");
                if (!_infoChannelTag.equals((Object)_existingChannelTag)) {
                    throw new IllegalStateException("Migration didn't properly handle channel_tag(com.ekoapp.ekosdk.internal.data.model.EkoChannelTag).\n Expected:\n" + _infoChannelTag + "\n Found:\n" + _existingChannelTag);
                }
                HashMap<String, TableInfo.Column> _columnsChannelMembership = new HashMap<String, TableInfo.Column>(11);
                _columnsChannelMembership.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 1));
                _columnsChannelMembership.put("userId", new TableInfo.Column("userId", "TEXT", true, 2));
                _columnsChannelMembership.put("readToSegment", new TableInfo.Column("readToSegment", "INTEGER", true, 0));
                _columnsChannelMembership.put("membership", new TableInfo.Column("membership", "TEXT", false, 0));
                _columnsChannelMembership.put("isMuted", new TableInfo.Column("isMuted", "INTEGER", false, 0));
                _columnsChannelMembership.put("isBanned", new TableInfo.Column("isBanned", "INTEGER", false, 0));
                _columnsChannelMembership.put("roles", new TableInfo.Column("roles", "TEXT", false, 0));
                _columnsChannelMembership.put("permissions", new TableInfo.Column("permissions", "TEXT", false, 0));
                _columnsChannelMembership.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0));
                _columnsChannelMembership.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsChannelMembership.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysChannelMembership = new HashSet(0);
                HashSet _indicesChannelMembership = new HashSet(0);
                TableInfo _infoChannelMembership = new TableInfo("channel_membership", _columnsChannelMembership, _foreignKeysChannelMembership, _indicesChannelMembership);
                TableInfo _existingChannelMembership = TableInfo.read((SupportSQLiteDatabase)_db, (String)"channel_membership");
                if (!_infoChannelMembership.equals((Object)_existingChannelMembership)) {
                    throw new IllegalStateException("Migration didn't properly handle channel_membership(com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity).\n Expected:\n" + _infoChannelMembership + "\n Found:\n" + _existingChannelMembership);
                }
                HashMap<String, TableInfo.Column> _columnsChannelRole = new HashMap<String, TableInfo.Column>(3);
                _columnsChannelRole.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 1));
                _columnsChannelRole.put("userId", new TableInfo.Column("userId", "TEXT", true, 2));
                _columnsChannelRole.put("roleName", new TableInfo.Column("roleName", "TEXT", true, 3));
                HashSet<TableInfo.ForeignKey> _foreignKeysChannelRole = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysChannelRole.add(new TableInfo.ForeignKey("channel_membership", "CASCADE", "NO ACTION", Arrays.asList("channelId", "userId"), Arrays.asList("channelId", "userId")));
                HashSet _indicesChannelRole = new HashSet(0);
                TableInfo _infoChannelRole = new TableInfo("channel_role", _columnsChannelRole, _foreignKeysChannelRole, _indicesChannelRole);
                TableInfo _existingChannelRole = TableInfo.read((SupportSQLiteDatabase)_db, (String)"channel_role");
                if (!_infoChannelRole.equals((Object)_existingChannelRole)) {
                    throw new IllegalStateException("Migration didn't properly handle channel_role(com.ekoapp.ekosdk.internal.data.model.ChannelMembershipRoleEntity).\n Expected:\n" + _infoChannelRole + "\n Found:\n" + _existingChannelRole);
                }
                HashMap<String, TableInfo.Column> _columnsChannelPermission = new HashMap<String, TableInfo.Column>(3);
                _columnsChannelPermission.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 1));
                _columnsChannelPermission.put("userId", new TableInfo.Column("userId", "TEXT", true, 2));
                _columnsChannelPermission.put("permissionName", new TableInfo.Column("permissionName", "TEXT", true, 3));
                HashSet<TableInfo.ForeignKey> _foreignKeysChannelPermission = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysChannelPermission.add(new TableInfo.ForeignKey("channel_membership", "CASCADE", "NO ACTION", Arrays.asList("channelId", "userId"), Arrays.asList("channelId", "userId")));
                HashSet _indicesChannelPermission = new HashSet(0);
                TableInfo _infoChannelPermission = new TableInfo("channel_permission", _columnsChannelPermission, _foreignKeysChannelPermission, _indicesChannelPermission);
                TableInfo _existingChannelPermission = TableInfo.read((SupportSQLiteDatabase)_db, (String)"channel_permission");
                if (!_infoChannelPermission.equals((Object)_existingChannelPermission)) {
                    throw new IllegalStateException("Migration didn't properly handle channel_permission(com.ekoapp.ekosdk.internal.data.model.ChannelMembershipPermissionEntity).\n Expected:\n" + _infoChannelPermission + "\n Found:\n" + _existingChannelPermission);
                }
                HashMap<String, TableInfo.Column> _columnsCommunityRole = new HashMap<String, TableInfo.Column>(3);
                _columnsCommunityRole.put("communityId", new TableInfo.Column("communityId", "TEXT", true, 1));
                _columnsCommunityRole.put("userId", new TableInfo.Column("userId", "TEXT", true, 2));
                _columnsCommunityRole.put("roleName", new TableInfo.Column("roleName", "TEXT", true, 3));
                HashSet<TableInfo.ForeignKey> _foreignKeysCommunityRole = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysCommunityRole.add(new TableInfo.ForeignKey("community_membership", "CASCADE", "NO ACTION", Arrays.asList("communityId", "userId"), Arrays.asList("communityId", "userId")));
                HashSet _indicesCommunityRole = new HashSet(0);
                TableInfo _infoCommunityRole = new TableInfo("community_role", _columnsCommunityRole, _foreignKeysCommunityRole, _indicesCommunityRole);
                TableInfo _existingCommunityRole = TableInfo.read((SupportSQLiteDatabase)_db, (String)"community_role");
                if (!_infoCommunityRole.equals((Object)_existingCommunityRole)) {
                    throw new IllegalStateException("Migration didn't properly handle community_role(com.ekoapp.ekosdk.internal.data.model.CommunityMembershipRoleEntity).\n Expected:\n" + _infoCommunityRole + "\n Found:\n" + _existingCommunityRole);
                }
                HashMap<String, TableInfo.Column> _columnsCommunityPermission = new HashMap<String, TableInfo.Column>(3);
                _columnsCommunityPermission.put("communityId", new TableInfo.Column("communityId", "TEXT", true, 1));
                _columnsCommunityPermission.put("userId", new TableInfo.Column("userId", "TEXT", true, 2));
                _columnsCommunityPermission.put("permissionName", new TableInfo.Column("permissionName", "TEXT", true, 3));
                HashSet<TableInfo.ForeignKey> _foreignKeysCommunityPermission = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysCommunityPermission.add(new TableInfo.ForeignKey("community_membership", "CASCADE", "NO ACTION", Arrays.asList("communityId", "userId"), Arrays.asList("communityId", "userId")));
                HashSet _indicesCommunityPermission = new HashSet(0);
                TableInfo _infoCommunityPermission = new TableInfo("community_permission", _columnsCommunityPermission, _foreignKeysCommunityPermission, _indicesCommunityPermission);
                TableInfo _existingCommunityPermission = TableInfo.read((SupportSQLiteDatabase)_db, (String)"community_permission");
                if (!_infoCommunityPermission.equals((Object)_existingCommunityPermission)) {
                    throw new IllegalStateException("Migration didn't properly handle community_permission(com.ekoapp.ekosdk.internal.data.model.CommunityMembershipPermissionEntity).\n Expected:\n" + _infoCommunityPermission + "\n Found:\n" + _existingCommunityPermission);
                }
                HashMap<String, TableInfo.Column> _columnsChannelQueryToken = new HashMap<String, TableInfo.Column>(5);
                _columnsChannelQueryToken.put("filter", new TableInfo.Column("filter", "TEXT", true, 1));
                _columnsChannelQueryToken.put("includingTags", new TableInfo.Column("includingTags", "TEXT", true, 2));
                _columnsChannelQueryToken.put("excludingTags", new TableInfo.Column("excludingTags", "TEXT", true, 3));
                _columnsChannelQueryToken.put("previous", new TableInfo.Column("previous", "TEXT", false, 0));
                _columnsChannelQueryToken.put("next", new TableInfo.Column("next", "TEXT", false, 0));
                HashSet _foreignKeysChannelQueryToken = new HashSet(0);
                HashSet _indicesChannelQueryToken = new HashSet(0);
                TableInfo _infoChannelQueryToken = new TableInfo("channel_query_token", _columnsChannelQueryToken, _foreignKeysChannelQueryToken, _indicesChannelQueryToken);
                TableInfo _existingChannelQueryToken = TableInfo.read((SupportSQLiteDatabase)_db, (String)"channel_query_token");
                if (!_infoChannelQueryToken.equals((Object)_existingChannelQueryToken)) {
                    throw new IllegalStateException("Migration didn't properly handle channel_query_token(com.ekoapp.ekosdk.internal.data.model.EkoChannelQueryToken).\n Expected:\n" + _infoChannelQueryToken + "\n Found:\n" + _existingChannelQueryToken);
                }
                HashMap<String, TableInfo.Column> _columnsChannelMembershipQueryToken = new HashMap<String, TableInfo.Column>(4);
                _columnsChannelMembershipQueryToken.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 1));
                _columnsChannelMembershipQueryToken.put("filter", new TableInfo.Column("filter", "TEXT", true, 2));
                _columnsChannelMembershipQueryToken.put("previous", new TableInfo.Column("previous", "TEXT", false, 0));
                _columnsChannelMembershipQueryToken.put("next", new TableInfo.Column("next", "TEXT", false, 0));
                HashSet _foreignKeysChannelMembershipQueryToken = new HashSet(0);
                HashSet _indicesChannelMembershipQueryToken = new HashSet(0);
                TableInfo _infoChannelMembershipQueryToken = new TableInfo("channel_membership_query_token", _columnsChannelMembershipQueryToken, _foreignKeysChannelMembershipQueryToken, _indicesChannelMembershipQueryToken);
                TableInfo _existingChannelMembershipQueryToken = TableInfo.read((SupportSQLiteDatabase)_db, (String)"channel_membership_query_token");
                if (!_infoChannelMembershipQueryToken.equals((Object)_existingChannelMembershipQueryToken)) {
                    throw new IllegalStateException("Migration didn't properly handle channel_membership_query_token(com.ekoapp.ekosdk.internal.data.model.EkoChannelMembershipQueryToken).\n Expected:\n" + _infoChannelMembershipQueryToken + "\n Found:\n" + _existingChannelMembershipQueryToken);
                }
                HashMap<String, TableInfo.Column> _columnsChannelExtra = new HashMap<String, TableInfo.Column>(5);
                _columnsChannelExtra.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 1));
                _columnsChannelExtra.put("readStatus", new TableInfo.Column("readStatus", "TEXT", false, 0));
                _columnsChannelExtra.put("localReadToSegment", new TableInfo.Column("localReadToSegment", "INTEGER", true, 0));
                _columnsChannelExtra.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsChannelExtra.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysChannelExtra = new HashSet(0);
                HashSet _indicesChannelExtra = new HashSet(0);
                TableInfo _infoChannelExtra = new TableInfo("channel_extra", _columnsChannelExtra, _foreignKeysChannelExtra, _indicesChannelExtra);
                TableInfo _existingChannelExtra = TableInfo.read((SupportSQLiteDatabase)_db, (String)"channel_extra");
                if (!_infoChannelExtra.equals((Object)_existingChannelExtra)) {
                    throw new IllegalStateException("Migration didn't properly handle channel_extra(com.ekoapp.ekosdk.EkoChannelExtra).\n Expected:\n" + _infoChannelExtra + "\n Found:\n" + _existingChannelExtra);
                }
                HashMap<String, TableInfo.Column> _columnsMessage = new HashMap<String, TableInfo.Column>(19);
                _columnsMessage.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 1));
                _columnsMessage.put("channelId", new TableInfo.Column("channelId", "TEXT", true, 0));
                _columnsMessage.put("userId", new TableInfo.Column("userId", "TEXT", true, 0));
                _columnsMessage.put("parentId", new TableInfo.Column("parentId", "TEXT", false, 0));
                _columnsMessage.put("channelSegment", new TableInfo.Column("channelSegment", "INTEGER", true, 0));
                _columnsMessage.put("childrenNumber", new TableInfo.Column("childrenNumber", "INTEGER", true, 0));
                _columnsMessage.put("editedAt", new TableInfo.Column("editedAt", "TEXT", false, 0));
                _columnsMessage.put("isDeleted", new TableInfo.Column("isDeleted", "INTEGER", true, 0));
                _columnsMessage.put("readByCount", new TableInfo.Column("readByCount", "INTEGER", true, 0));
                _columnsMessage.put("flagCount", new TableInfo.Column("flagCount", "INTEGER", true, 0));
                _columnsMessage.put("tags", new TableInfo.Column("tags", "TEXT", false, 0));
                _columnsMessage.put("reactions", new TableInfo.Column("reactions", "TEXT", true, 0));
                _columnsMessage.put("reactionCount", new TableInfo.Column("reactionCount", "INTEGER", true, 0));
                _columnsMessage.put("type", new TableInfo.Column("type", "TEXT", true, 0));
                _columnsMessage.put("data", new TableInfo.Column("data", "TEXT", false, 0));
                _columnsMessage.put("fileId", new TableInfo.Column("fileId", "TEXT", false, 0));
                _columnsMessage.put("syncState", new TableInfo.Column("syncState", "TEXT", true, 0));
                _columnsMessage.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsMessage.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysMessage = new HashSet(0);
                HashSet<TableInfo.Index> _indicesMessage = new HashSet<TableInfo.Index>(4);
                _indicesMessage.add(new TableInfo.Index("index_message_channelId", false, Arrays.asList("channelId")));
                _indicesMessage.add(new TableInfo.Index("index_message_syncState", false, Arrays.asList("syncState")));
                _indicesMessage.add(new TableInfo.Index("index_message_channelId_createdAt", false, Arrays.asList("channelId", "createdAt")));
                _indicesMessage.add(new TableInfo.Index("index_message_channelId_channelSegment", false, Arrays.asList("channelId", "channelSegment")));
                TableInfo _infoMessage = new TableInfo("message", _columnsMessage, _foreignKeysMessage, _indicesMessage);
                TableInfo _existingMessage = TableInfo.read((SupportSQLiteDatabase)_db, (String)"message");
                if (!_infoMessage.equals((Object)_existingMessage)) {
                    throw new IllegalStateException("Migration didn't properly handle message(com.ekoapp.ekosdk.internal.EkoInternalMessage).\n Expected:\n" + _infoMessage + "\n Found:\n" + _existingMessage);
                }
                HashMap<String, TableInfo.Column> _columnsMessageTag = new HashMap<String, TableInfo.Column>(2);
                _columnsMessageTag.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 1));
                _columnsMessageTag.put("tagName", new TableInfo.Column("tagName", "TEXT", true, 2));
                HashSet<TableInfo.ForeignKey> _foreignKeysMessageTag = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysMessageTag.add(new TableInfo.ForeignKey("message", "CASCADE", "NO ACTION", Arrays.asList("messageId"), Arrays.asList("messageId")));
                HashSet _indicesMessageTag = new HashSet(0);
                TableInfo _infoMessageTag = new TableInfo("message_tag", _columnsMessageTag, _foreignKeysMessageTag, _indicesMessageTag);
                TableInfo _existingMessageTag = TableInfo.read((SupportSQLiteDatabase)_db, (String)"message_tag");
                if (!_infoMessageTag.equals((Object)_existingMessageTag)) {
                    throw new IllegalStateException("Migration didn't properly handle message_tag(com.ekoapp.ekosdk.internal.data.model.EkoMessageTag).\n Expected:\n" + _infoMessageTag + "\n Found:\n" + _existingMessageTag);
                }
                HashMap<String, TableInfo.Column> _columnsReaction = new HashMap<String, TableInfo.Column>(8);
                _columnsReaction.put("reactionId", new TableInfo.Column("reactionId", "TEXT", false, 0));
                _columnsReaction.put("reactionName", new TableInfo.Column("reactionName", "TEXT", true, 2));
                _columnsReaction.put("userId", new TableInfo.Column("userId", "TEXT", true, 1));
                _columnsReaction.put("userDisplayName", new TableInfo.Column("userDisplayName", "TEXT", false, 0));
                _columnsReaction.put("referenceId", new TableInfo.Column("referenceId", "TEXT", true, 4));
                _columnsReaction.put("referenceType", new TableInfo.Column("referenceType", "TEXT", true, 3));
                _columnsReaction.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsReaction.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysReaction = new HashSet(0);
                HashSet _indicesReaction = new HashSet(0);
                TableInfo _infoReaction = new TableInfo("reaction", _columnsReaction, _foreignKeysReaction, _indicesReaction);
                TableInfo _existingReaction = TableInfo.read((SupportSQLiteDatabase)_db, (String)"reaction");
                if (!_infoReaction.equals((Object)_existingReaction)) {
                    throw new IllegalStateException("Migration didn't properly handle reaction(com.ekoapp.ekosdk.internal.data.model.EkoInternalReaction).\n Expected:\n" + _infoReaction + "\n Found:\n" + _existingReaction);
                }
                HashMap<String, TableInfo.Column> _columnsMessageFlag = new HashMap<String, TableInfo.Column>(5);
                _columnsMessageFlag.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 1));
                _columnsMessageFlag.put("flag", new TableInfo.Column("flag", "TEXT", false, 0));
                _columnsMessageFlag.put("localFlag", new TableInfo.Column("localFlag", "TEXT", false, 0));
                _columnsMessageFlag.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsMessageFlag.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet<TableInfo.ForeignKey> _foreignKeysMessageFlag = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysMessageFlag.add(new TableInfo.ForeignKey("message", "CASCADE", "NO ACTION", Arrays.asList("messageId"), Arrays.asList("messageId")));
                HashSet _indicesMessageFlag = new HashSet(0);
                TableInfo _infoMessageFlag = new TableInfo("message_flag", _columnsMessageFlag, _foreignKeysMessageFlag, _indicesMessageFlag);
                TableInfo _existingMessageFlag = TableInfo.read((SupportSQLiteDatabase)_db, (String)"message_flag");
                if (!_infoMessageFlag.equals((Object)_existingMessageFlag)) {
                    throw new IllegalStateException("Migration didn't properly handle message_flag(com.ekoapp.ekosdk.internal.data.model.EkoMessageFlag).\n Expected:\n" + _infoMessageFlag + "\n Found:\n" + _existingMessageFlag);
                }
                HashMap<String, TableInfo.Column> _columnsUser = new HashMap<String, TableInfo.Column>(11);
                _columnsUser.put("userId", new TableInfo.Column("userId", "TEXT", true, 1));
                _columnsUser.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0));
                _columnsUser.put("roles", new TableInfo.Column("roles", "TEXT", false, 0));
                _columnsUser.put("permissions", new TableInfo.Column("permissions", "TEXT", false, 0));
                _columnsUser.put("flagCount", new TableInfo.Column("flagCount", "INTEGER", true, 0));
                _columnsUser.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0));
                _columnsUser.put("avatarFileId", new TableInfo.Column("avatarFileId", "TEXT", false, 0));
                _columnsUser.put("avatarCustomUrl", new TableInfo.Column("avatarCustomUrl", "TEXT", false, 0));
                _columnsUser.put("description", new TableInfo.Column("description", "TEXT", false, 0));
                _columnsUser.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsUser.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysUser = new HashSet(0);
                HashSet _indicesUser = new HashSet(0);
                TableInfo _infoUser = new TableInfo("user", _columnsUser, _foreignKeysUser, _indicesUser);
                TableInfo _existingUser = TableInfo.read((SupportSQLiteDatabase)_db, (String)"user");
                if (!_infoUser.equals((Object)_existingUser)) {
                    throw new IllegalStateException("Migration didn't properly handle user(com.ekoapp.ekosdk.EkoInternalUser).\n Expected:\n" + _infoUser + "\n Found:\n" + _existingUser);
                }
                HashMap<String, TableInfo.Column> _columnsUserFlag = new HashMap<String, TableInfo.Column>(5);
                _columnsUserFlag.put("userId", new TableInfo.Column("userId", "TEXT", true, 1));
                _columnsUserFlag.put("flag", new TableInfo.Column("flag", "TEXT", false, 0));
                _columnsUserFlag.put("localFlag", new TableInfo.Column("localFlag", "TEXT", false, 0));
                _columnsUserFlag.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsUserFlag.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet<TableInfo.ForeignKey> _foreignKeysUserFlag = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysUserFlag.add(new TableInfo.ForeignKey("user", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
                HashSet _indicesUserFlag = new HashSet(0);
                TableInfo _infoUserFlag = new TableInfo("user_flag", _columnsUserFlag, _foreignKeysUserFlag, _indicesUserFlag);
                TableInfo _existingUserFlag = TableInfo.read((SupportSQLiteDatabase)_db, (String)"user_flag");
                if (!_infoUserFlag.equals((Object)_existingUserFlag)) {
                    throw new IllegalStateException("Migration didn't properly handle user_flag(com.ekoapp.ekosdk.internal.data.model.EkoUserFlag).\n Expected:\n" + _infoUserFlag + "\n Found:\n" + _existingUserFlag);
                }
                HashMap<String, TableInfo.Column> _columnsStandardPost = new HashMap<String, TableInfo.Column>(19);
                _columnsStandardPost.put("postId", new TableInfo.Column("postId", "TEXT", true, 1));
                _columnsStandardPost.put("parentPostId", new TableInfo.Column("parentPostId", "TEXT", false, 0));
                _columnsStandardPost.put("postedUserId", new TableInfo.Column("postedUserId", "TEXT", false, 0));
                _columnsStandardPost.put("sharedUserId", new TableInfo.Column("sharedUserId", "TEXT", false, 0));
                _columnsStandardPost.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0));
                _columnsStandardPost.put("sharedCount", new TableInfo.Column("sharedCount", "INTEGER", true, 0));
                _columnsStandardPost.put("reactions", new TableInfo.Column("reactions", "TEXT", false, 0));
                _columnsStandardPost.put("reactionCount", new TableInfo.Column("reactionCount", "INTEGER", true, 0));
                _columnsStandardPost.put("commentCount", new TableInfo.Column("commentCount", "INTEGER", true, 0));
                _columnsStandardPost.put("flagCount", new TableInfo.Column("flagCount", "INTEGER", true, 0));
                _columnsStandardPost.put("editedAt", new TableInfo.Column("editedAt", "TEXT", false, 0));
                _columnsStandardPost.put("isDeleted", new TableInfo.Column("isDeleted", "INTEGER", true, 0));
                _columnsStandardPost.put("targetType", new TableInfo.Column("targetType", "TEXT", false, 0));
                _columnsStandardPost.put("targetId", new TableInfo.Column("targetId", "TEXT", false, 0));
                _columnsStandardPost.put("postDataType", new TableInfo.Column("postDataType", "TEXT", false, 0));
                _columnsStandardPost.put("data", new TableInfo.Column("data", "TEXT", false, 0));
                _columnsStandardPost.put("childPostIds", new TableInfo.Column("childPostIds", "TEXT", true, 0));
                _columnsStandardPost.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsStandardPost.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysStandardPost = new HashSet(0);
                HashSet _indicesStandardPost = new HashSet(0);
                TableInfo _infoStandardPost = new TableInfo("standard_post", _columnsStandardPost, _foreignKeysStandardPost, _indicesStandardPost);
                TableInfo _existingStandardPost = TableInfo.read((SupportSQLiteDatabase)_db, (String)"standard_post");
                if (!_infoStandardPost.equals((Object)_existingStandardPost)) {
                    throw new IllegalStateException("Migration didn't properly handle standard_post(com.ekoapp.ekosdk.internal.EkoStandardPost).\n Expected:\n" + _infoStandardPost + "\n Found:\n" + _existingStandardPost);
                }
                HashMap<String, TableInfo.Column> _columnsComment = new HashMap<String, TableInfo.Column>(19);
                _columnsComment.put("myReactions", new TableInfo.Column("myReactions", "TEXT", true, 0));
                _columnsComment.put("commentId", new TableInfo.Column("commentId", "TEXT", true, 1));
                _columnsComment.put("referenceType", new TableInfo.Column("referenceType", "TEXT", false, 0));
                _columnsComment.put("referenceId", new TableInfo.Column("referenceId", "TEXT", false, 0));
                _columnsComment.put("userId", new TableInfo.Column("userId", "TEXT", false, 0));
                _columnsComment.put("parentId", new TableInfo.Column("parentId", "TEXT", false, 0));
                _columnsComment.put("rootId", new TableInfo.Column("rootId", "TEXT", false, 0));
                _columnsComment.put("dataType", new TableInfo.Column("dataType", "TEXT", false, 0));
                _columnsComment.put("data", new TableInfo.Column("data", "TEXT", false, 0));
                _columnsComment.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0));
                _columnsComment.put("childrenNumber", new TableInfo.Column("childrenNumber", "INTEGER", false, 0));
                _columnsComment.put("flagCount", new TableInfo.Column("flagCount", "INTEGER", false, 0));
                _columnsComment.put("reactions", new TableInfo.Column("reactions", "TEXT", false, 0));
                _columnsComment.put("reactionCount", new TableInfo.Column("reactionCount", "INTEGER", true, 0));
                _columnsComment.put("isDeleted", new TableInfo.Column("isDeleted", "INTEGER", false, 0));
                _columnsComment.put("editedAt", new TableInfo.Column("editedAt", "TEXT", false, 0));
                _columnsComment.put("syncState", new TableInfo.Column("syncState", "TEXT", false, 0));
                _columnsComment.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsComment.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysComment = new HashSet(0);
                HashSet _indicesComment = new HashSet(0);
                TableInfo _infoComment = new TableInfo("comment", _columnsComment, _foreignKeysComment, _indicesComment);
                TableInfo _existingComment = TableInfo.read((SupportSQLiteDatabase)_db, (String)"comment");
                if (!_infoComment.equals((Object)_existingComment)) {
                    throw new IllegalStateException("Migration didn't properly handle comment(com.ekoapp.ekosdk.internal.entity.CommentEntity).\n Expected:\n" + _infoComment + "\n Found:\n" + _existingComment);
                }
                HashMap<String, TableInfo.Column> _columnsPostFlag = new HashMap<String, TableInfo.Column>(5);
                _columnsPostFlag.put("postId", new TableInfo.Column("postId", "TEXT", true, 1));
                _columnsPostFlag.put("flag", new TableInfo.Column("flag", "TEXT", false, 0));
                _columnsPostFlag.put("localFlag", new TableInfo.Column("localFlag", "TEXT", false, 0));
                _columnsPostFlag.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsPostFlag.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet<TableInfo.ForeignKey> _foreignKeysPostFlag = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysPostFlag.add(new TableInfo.ForeignKey("standard_post", "CASCADE", "NO ACTION", Arrays.asList("postId"), Arrays.asList("postId")));
                HashSet _indicesPostFlag = new HashSet(0);
                TableInfo _infoPostFlag = new TableInfo("post_flag", _columnsPostFlag, _foreignKeysPostFlag, _indicesPostFlag);
                TableInfo _existingPostFlag = TableInfo.read((SupportSQLiteDatabase)_db, (String)"post_flag");
                if (!_infoPostFlag.equals((Object)_existingPostFlag)) {
                    throw new IllegalStateException("Migration didn't properly handle post_flag(com.ekoapp.ekosdk.internal.data.model.EkoPostFlag).\n Expected:\n" + _infoPostFlag + "\n Found:\n" + _existingPostFlag);
                }
                HashMap<String, TableInfo.Column> _columnsCommentFlag = new HashMap<String, TableInfo.Column>(5);
                _columnsCommentFlag.put("commentId", new TableInfo.Column("commentId", "TEXT", true, 1));
                _columnsCommentFlag.put("flag", new TableInfo.Column("flag", "TEXT", false, 0));
                _columnsCommentFlag.put("localFlag", new TableInfo.Column("localFlag", "TEXT", false, 0));
                _columnsCommentFlag.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsCommentFlag.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet<TableInfo.ForeignKey> _foreignKeysCommentFlag = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysCommentFlag.add(new TableInfo.ForeignKey("comment", "CASCADE", "NO ACTION", Arrays.asList("commentId"), Arrays.asList("commentId")));
                HashSet _indicesCommentFlag = new HashSet(0);
                TableInfo _infoCommentFlag = new TableInfo("comment_flag", _columnsCommentFlag, _foreignKeysCommentFlag, _indicesCommentFlag);
                TableInfo _existingCommentFlag = TableInfo.read((SupportSQLiteDatabase)_db, (String)"comment_flag");
                if (!_infoCommentFlag.equals((Object)_existingCommentFlag)) {
                    throw new IllegalStateException("Migration didn't properly handle comment_flag(com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity).\n Expected:\n" + _infoCommentFlag + "\n Found:\n" + _existingCommentFlag);
                }
                HashMap<String, TableInfo.Column> _columnsCommunity = new HashMap<String, TableInfo.Column>(19);
                _columnsCommunity.put("communityId", new TableInfo.Column("communityId", "TEXT", true, 1));
                _columnsCommunity.put("channelId", new TableInfo.Column("channelId", "TEXT", false, 0));
                _columnsCommunity.put("userId", new TableInfo.Column("userId", "TEXT", false, 0));
                _columnsCommunity.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0));
                _columnsCommunity.put("description", new TableInfo.Column("description", "TEXT", false, 0));
                _columnsCommunity.put("avatarFileId", new TableInfo.Column("avatarFileId", "TEXT", false, 0));
                _columnsCommunity.put("isOfficial", new TableInfo.Column("isOfficial", "INTEGER", false, 0));
                _columnsCommunity.put("isPublic", new TableInfo.Column("isPublic", "INTEGER", false, 0));
                _columnsCommunity.put("onlyAdminCanPost", new TableInfo.Column("onlyAdminCanPost", "INTEGER", false, 0));
                _columnsCommunity.put("tags", new TableInfo.Column("tags", "TEXT", false, 0));
                _columnsCommunity.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0));
                _columnsCommunity.put("postsCount", new TableInfo.Column("postsCount", "INTEGER", false, 0));
                _columnsCommunity.put("membersCount", new TableInfo.Column("membersCount", "INTEGER", false, 0));
                _columnsCommunity.put("isJoined", new TableInfo.Column("isJoined", "INTEGER", false, 0));
                _columnsCommunity.put("isDeleted", new TableInfo.Column("isDeleted", "INTEGER", false, 0));
                _columnsCommunity.put("editedAt", new TableInfo.Column("editedAt", "TEXT", false, 0));
                _columnsCommunity.put("categoryIds", new TableInfo.Column("categoryIds", "TEXT", false, 0));
                _columnsCommunity.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsCommunity.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysCommunity = new HashSet(0);
                HashSet<TableInfo.Index> _indicesCommunity = new HashSet<TableInfo.Index>(1);
                _indicesCommunity.add(new TableInfo.Index("index_community_communityId", false, Arrays.asList("communityId")));
                TableInfo _infoCommunity = new TableInfo("community", _columnsCommunity, _foreignKeysCommunity, _indicesCommunity);
                TableInfo _existingCommunity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"community");
                if (!_infoCommunity.equals((Object)_existingCommunity)) {
                    throw new IllegalStateException("Migration didn't properly handle community(com.ekoapp.ekosdk.internal.entity.CommunityEntity).\n Expected:\n" + _infoCommunity + "\n Found:\n" + _existingCommunity);
                }
                HashMap<String, TableInfo.Column> _columnsCommunityCategory = new HashMap<String, TableInfo.Column>(7);
                _columnsCommunityCategory.put("categoryId", new TableInfo.Column("categoryId", "TEXT", true, 1));
                _columnsCommunityCategory.put("name", new TableInfo.Column("name", "TEXT", true, 0));
                _columnsCommunityCategory.put("avatarFileId", new TableInfo.Column("avatarFileId", "TEXT", false, 0));
                _columnsCommunityCategory.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0));
                _columnsCommunityCategory.put("isDeleted", new TableInfo.Column("isDeleted", "INTEGER", true, 0));
                _columnsCommunityCategory.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsCommunityCategory.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysCommunityCategory = new HashSet(0);
                HashSet<TableInfo.Index> _indicesCommunityCategory = new HashSet<TableInfo.Index>(1);
                _indicesCommunityCategory.add(new TableInfo.Index("index_community_category_categoryId", false, Arrays.asList("categoryId")));
                TableInfo _infoCommunityCategory = new TableInfo("community_category", _columnsCommunityCategory, _foreignKeysCommunityCategory, _indicesCommunityCategory);
                TableInfo _existingCommunityCategory = TableInfo.read((SupportSQLiteDatabase)_db, (String)"community_category");
                if (!_infoCommunityCategory.equals((Object)_existingCommunityCategory)) {
                    throw new IllegalStateException("Migration didn't properly handle community_category(com.ekoapp.ekosdk.community.category.CommunityCategoryEntity).\n Expected:\n" + _infoCommunityCategory + "\n Found:\n" + _existingCommunityCategory);
                }
                HashMap<String, TableInfo.Column> _columnsCommunityMembership = new HashMap<String, TableInfo.Column>(10);
                _columnsCommunityMembership.put("userId", new TableInfo.Column("userId", "TEXT", true, 2));
                _columnsCommunityMembership.put("communityId", new TableInfo.Column("communityId", "TEXT", true, 1));
                _columnsCommunityMembership.put("channelId", new TableInfo.Column("channelId", "TEXT", false, 0));
                _columnsCommunityMembership.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0));
                _columnsCommunityMembership.put("communityMembership", new TableInfo.Column("communityMembership", "TEXT", false, 0));
                _columnsCommunityMembership.put("isBanned", new TableInfo.Column("isBanned", "INTEGER", false, 0));
                _columnsCommunityMembership.put("roles", new TableInfo.Column("roles", "TEXT", false, 0));
                _columnsCommunityMembership.put("permissions", new TableInfo.Column("permissions", "TEXT", false, 0));
                _columnsCommunityMembership.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsCommunityMembership.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysCommunityMembership = new HashSet(0);
                HashSet _indicesCommunityMembership = new HashSet(0);
                TableInfo _infoCommunityMembership = new TableInfo("community_membership", _columnsCommunityMembership, _foreignKeysCommunityMembership, _indicesCommunityMembership);
                TableInfo _existingCommunityMembership = TableInfo.read((SupportSQLiteDatabase)_db, (String)"community_membership");
                if (!_infoCommunityMembership.equals((Object)_existingCommunityMembership)) {
                    throw new IllegalStateException("Migration didn't properly handle community_membership(com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity).\n Expected:\n" + _infoCommunityMembership + "\n Found:\n" + _existingCommunityMembership);
                }
                HashMap<String, TableInfo.Column> _columnsFile = new HashMap<String, TableInfo.Column>(7);
                _columnsFile.put("fileId", new TableInfo.Column("fileId", "TEXT", true, 1));
                _columnsFile.put("fileUrl", new TableInfo.Column("fileUrl", "TEXT", false, 0));
                _columnsFile.put("filePath", new TableInfo.Column("filePath", "TEXT", false, 0));
                _columnsFile.put("type", new TableInfo.Column("type", "TEXT", false, 0));
                _columnsFile.put("attributes", new TableInfo.Column("attributes", "TEXT", false, 0));
                _columnsFile.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsFile.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysFile = new HashSet(0);
                HashSet<TableInfo.Index> _indicesFile = new HashSet<TableInfo.Index>(1);
                _indicesFile.add(new TableInfo.Index("index_file_fileId", false, Arrays.asList("fileId")));
                TableInfo _infoFile = new TableInfo("file", _columnsFile, _foreignKeysFile, _indicesFile);
                TableInfo _existingFile = TableInfo.read((SupportSQLiteDatabase)_db, (String)"file");
                if (!_infoFile.equals((Object)_existingFile)) {
                    throw new IllegalStateException("Migration didn't properly handle file(com.ekoapp.ekosdk.internal.EkoFileEntity).\n Expected:\n" + _infoFile + "\n Found:\n" + _existingFile);
                }
                HashMap<String, TableInfo.Column> _columnsCategory = new HashMap<String, TableInfo.Column>(2);
                _columnsCategory.put("communityId", new TableInfo.Column("communityId", "TEXT", true, 1));
                _columnsCategory.put("categoryId", new TableInfo.Column("categoryId", "TEXT", true, 2));
                HashSet<TableInfo.ForeignKey> _foreignKeysCategory = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysCategory.add(new TableInfo.ForeignKey("community", "CASCADE", "NO ACTION", Arrays.asList("communityId"), Arrays.asList("communityId")));
                HashSet _indicesCategory = new HashSet(0);
                TableInfo _infoCategory = new TableInfo("category", _columnsCategory, _foreignKeysCategory, _indicesCategory);
                TableInfo _existingCategory = TableInfo.read((SupportSQLiteDatabase)_db, (String)"category");
                if (!_infoCategory.equals((Object)_existingCategory)) {
                    throw new IllegalStateException("Migration didn't properly handle category(com.ekoapp.ekosdk.internal.data.model.EkoCategoryEntity).\n Expected:\n" + _infoCategory + "\n Found:\n" + _existingCategory);
                }
                HashMap<String, TableInfo.Column> _columnsGlobalPost = new HashMap<String, TableInfo.Column>(3);
                _columnsGlobalPost.put("postId", new TableInfo.Column("postId", "TEXT", true, 1));
                _columnsGlobalPost.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsGlobalPost.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysGlobalPost = new HashSet(0);
                HashSet _indicesGlobalPost = new HashSet(0);
                TableInfo _infoGlobalPost = new TableInfo("global_post", _columnsGlobalPost, _foreignKeysGlobalPost, _indicesGlobalPost);
                TableInfo _existingGlobalPost = TableInfo.read((SupportSQLiteDatabase)_db, (String)"global_post");
                if (!_infoGlobalPost.equals((Object)_existingGlobalPost)) {
                    throw new IllegalStateException("Migration didn't properly handle global_post(com.ekoapp.ekosdk.internal.data.model.GlobalPostEntity).\n Expected:\n" + _infoGlobalPost + "\n Found:\n" + _existingGlobalPost);
                }
                HashMap<String, TableInfo.Column> _columnsRecommendedCommunity = new HashMap<String, TableInfo.Column>(3);
                _columnsRecommendedCommunity.put("communityId", new TableInfo.Column("communityId", "TEXT", true, 1));
                _columnsRecommendedCommunity.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsRecommendedCommunity.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysRecommendedCommunity = new HashSet(0);
                HashSet _indicesRecommendedCommunity = new HashSet(0);
                TableInfo _infoRecommendedCommunity = new TableInfo("recommended_community", _columnsRecommendedCommunity, _foreignKeysRecommendedCommunity, _indicesRecommendedCommunity);
                TableInfo _existingRecommendedCommunity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"recommended_community");
                if (!_infoRecommendedCommunity.equals((Object)_existingRecommendedCommunity)) {
                    throw new IllegalStateException("Migration didn't properly handle recommended_community(com.ekoapp.ekosdk.internal.data.model.RecommendedCommunityEntity).\n Expected:\n" + _infoRecommendedCommunity + "\n Found:\n" + _existingRecommendedCommunity);
                }
                HashMap<String, TableInfo.Column> _columnsTrendingCommunity = new HashMap<String, TableInfo.Column>(3);
                _columnsTrendingCommunity.put("communityId", new TableInfo.Column("communityId", "TEXT", true, 1));
                _columnsTrendingCommunity.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsTrendingCommunity.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysTrendingCommunity = new HashSet(0);
                HashSet _indicesTrendingCommunity = new HashSet(0);
                TableInfo _infoTrendingCommunity = new TableInfo("trending_community", _columnsTrendingCommunity, _foreignKeysTrendingCommunity, _indicesTrendingCommunity);
                TableInfo _existingTrendingCommunity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"trending_community");
                if (!_infoTrendingCommunity.equals((Object)_existingTrendingCommunity)) {
                    throw new IllegalStateException("Migration didn't properly handle trending_community(com.ekoapp.ekosdk.internal.data.model.TrendingCommunityEntity).\n Expected:\n" + _infoTrendingCommunity + "\n Found:\n" + _existingTrendingCommunity);
                }
                HashMap<String, TableInfo.Column> _columnsStream = new HashMap<String, TableInfo.Column>(15);
                _columnsStream.put("streamId", new TableInfo.Column("streamId", "TEXT", true, 1));
                _columnsStream.put("title", new TableInfo.Column("title", "TEXT", false, 0));
                _columnsStream.put("description", new TableInfo.Column("description", "TEXT", false, 0));
                _columnsStream.put("metadata", new TableInfo.Column("metadata", "TEXT", false, 0));
                _columnsStream.put("isDeleted", new TableInfo.Column("isDeleted", "INTEGER", true, 0));
                _columnsStream.put("thumbnailFileId", new TableInfo.Column("thumbnailFileId", "TEXT", false, 0));
                _columnsStream.put("userId", new TableInfo.Column("userId", "TEXT", false, 0));
                _columnsStream.put("watcherData", new TableInfo.Column("watcherData", "TEXT", false, 0));
                _columnsStream.put("broadcasterData", new TableInfo.Column("broadcasterData", "TEXT", false, 0));
                _columnsStream.put("recordings", new TableInfo.Column("recordings", "TEXT", false, 0));
                _columnsStream.put("status", new TableInfo.Column("status", "TEXT", false, 0));
                _columnsStream.put("isReconnecting", new TableInfo.Column("isReconnecting", "INTEGER", true, 0));
                _columnsStream.put("resolution", new TableInfo.Column("resolution", "TEXT", false, 0));
                _columnsStream.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsStream.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysStream = new HashSet(0);
                HashSet _indicesStream = new HashSet(0);
                TableInfo _infoStream = new TableInfo("stream", _columnsStream, _foreignKeysStream, _indicesStream);
                TableInfo _existingStream = TableInfo.read((SupportSQLiteDatabase)_db, (String)"stream");
                if (!_infoStream.equals((Object)_existingStream)) {
                    throw new IllegalStateException("Migration didn't properly handle stream(com.ekoapp.ekosdk.internal.entity.EkoStreamEntity).\n Expected:\n" + _infoStream + "\n Found:\n" + _existingStream);
                }
                HashMap<String, TableInfo.Column> _columnsStreamSession = new HashMap<String, TableInfo.Column>(12);
                _columnsStreamSession.put("sessionId", new TableInfo.Column("sessionId", "TEXT", true, 1));
                _columnsStreamSession.put("streamId", new TableInfo.Column("streamId", "TEXT", false, 0));
                _columnsStreamSession.put("title", new TableInfo.Column("title", "TEXT", false, 0));
                _columnsStreamSession.put("watchSeconds", new TableInfo.Column("watchSeconds", "INTEGER", true, 0));
                _columnsStreamSession.put("startTime", new TableInfo.Column("startTime", "TEXT", false, 0));
                _columnsStreamSession.put("endTime", new TableInfo.Column("endTime", "TEXT", false, 0));
                _columnsStreamSession.put("resolution", new TableInfo.Column("resolution", "TEXT", false, 0));
                _columnsStreamSession.put("syncState", new TableInfo.Column("syncState", "TEXT", true, 0));
                _columnsStreamSession.put("syncedAt", new TableInfo.Column("syncedAt", "TEXT", false, 0));
                _columnsStreamSession.put("retryCount", new TableInfo.Column("retryCount", "INTEGER", true, 0));
                _columnsStreamSession.put("createdAt", new TableInfo.Column("createdAt", "TEXT", false, 0));
                _columnsStreamSession.put("updatedAt", new TableInfo.Column("updatedAt", "TEXT", false, 0));
                HashSet _foreignKeysStreamSession = new HashSet(0);
                HashSet _indicesStreamSession = new HashSet(0);
                TableInfo _infoStreamSession = new TableInfo("stream_session", _columnsStreamSession, _foreignKeysStreamSession, _indicesStreamSession);
                TableInfo _existingStreamSession = TableInfo.read((SupportSQLiteDatabase)_db, (String)"stream_session");
                if (!_infoStreamSession.equals((Object)_existingStreamSession)) {
                    throw new IllegalStateException("Migration didn't properly handle stream_session(com.ekoapp.ekosdk.stream.entity.EkoStreamSessionEntity).\n Expected:\n" + _infoStreamSession + "\n Found:\n" + _existingStreamSession);
                }
            }
        }, "a4b2c95fe5b7e22079a78c0e4dde4e16", "ea046a761bc439ad43f09044da640641");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        return new InvalidationTracker((RoomDatabase)this, new String[]{"channel", "channel_tag", "channel_membership", "channel_role", "channel_permission", "community_role", "community_permission", "channel_query_token", "channel_membership_query_token", "channel_extra", "message", "message_tag", "reaction", "message_flag", "user", "user_flag", "standard_post", "comment", "post_flag", "comment_flag", "community", "community_category", "community_membership", "file", "category", "global_post", "recommended_community", "trending_community", "stream", "stream_session"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `channel`");
            _db.execSQL("DELETE FROM `channel_tag`");
            _db.execSQL("DELETE FROM `channel_membership`");
            _db.execSQL("DELETE FROM `channel_role`");
            _db.execSQL("DELETE FROM `channel_permission`");
            _db.execSQL("DELETE FROM `community_role`");
            _db.execSQL("DELETE FROM `community_permission`");
            _db.execSQL("DELETE FROM `channel_query_token`");
            _db.execSQL("DELETE FROM `channel_membership_query_token`");
            _db.execSQL("DELETE FROM `channel_extra`");
            _db.execSQL("DELETE FROM `message`");
            _db.execSQL("DELETE FROM `message_tag`");
            _db.execSQL("DELETE FROM `reaction`");
            _db.execSQL("DELETE FROM `message_flag`");
            _db.execSQL("DELETE FROM `user`");
            _db.execSQL("DELETE FROM `user_flag`");
            _db.execSQL("DELETE FROM `standard_post`");
            _db.execSQL("DELETE FROM `comment`");
            _db.execSQL("DELETE FROM `post_flag`");
            _db.execSQL("DELETE FROM `comment_flag`");
            _db.execSQL("DELETE FROM `community`");
            _db.execSQL("DELETE FROM `community_category`");
            _db.execSQL("DELETE FROM `community_membership`");
            _db.execSQL("DELETE FROM `file`");
            _db.execSQL("DELETE FROM `category`");
            _db.execSQL("DELETE FROM `global_post`");
            _db.execSQL("DELETE FROM `recommended_community`");
            _db.execSQL("DELETE FROM `trending_community`");
            _db.execSQL("DELETE FROM `stream`");
            _db.execSQL("DELETE FROM `stream_session`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelDao channelDao() {
        if (this._ekoChannelDao != null) {
            return this._ekoChannelDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoChannelDao == null) {
                this._ekoChannelDao = new EkoChannelDao_Impl(this);
            }
            return this._ekoChannelDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelTagDao channelTagDao() {
        if (this._ekoChannelTagDao != null) {
            return this._ekoChannelTagDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoChannelTagDao == null) {
                this._ekoChannelTagDao = new EkoChannelTagDao_Impl(this);
            }
            return this._ekoChannelTagDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelRoleDao channelRoleDao() {
        if (this._ekoChannelRoleDao != null) {
            return this._ekoChannelRoleDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoChannelRoleDao == null) {
                this._ekoChannelRoleDao = new EkoChannelRoleDao_Impl(this);
            }
            return this._ekoChannelRoleDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelPermissionDao channelPermissionDao() {
        if (this._ekoChannelPermissionDao != null) {
            return this._ekoChannelPermissionDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoChannelPermissionDao == null) {
                this._ekoChannelPermissionDao = new EkoChannelPermissionDao_Impl(this);
            }
            return this._ekoChannelPermissionDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoCommunityRoleDao communityRoleDao() {
        if (this._ekoCommunityRoleDao != null) {
            return this._ekoCommunityRoleDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoCommunityRoleDao == null) {
                this._ekoCommunityRoleDao = new EkoCommunityRoleDao_Impl(this);
            }
            return this._ekoCommunityRoleDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoCommunityPermissionDao communityPermissionDao() {
        if (this._ekoCommunityPermissionDao != null) {
            return this._ekoCommunityPermissionDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoCommunityPermissionDao == null) {
                this._ekoCommunityPermissionDao = new EkoCommunityPermissionDao_Impl(this);
            }
            return this._ekoCommunityPermissionDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelMembershipDao channelMembershipDao() {
        if (this._ekoChannelMembershipDao != null) {
            return this._ekoChannelMembershipDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoChannelMembershipDao == null) {
                this._ekoChannelMembershipDao = new EkoChannelMembershipDao_Impl(this);
            }
            return this._ekoChannelMembershipDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelMembershipQueryTokenDao channelMembershipTokenDao() {
        if (this._ekoChannelMembershipQueryTokenDao != null) {
            return this._ekoChannelMembershipQueryTokenDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoChannelMembershipQueryTokenDao == null) {
                this._ekoChannelMembershipQueryTokenDao = new EkoChannelMembershipQueryTokenDao_Impl(this);
            }
            return this._ekoChannelMembershipQueryTokenDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoChannelExtraDao channelExtraDao() {
        if (this._ekoChannelExtraDao != null) {
            return this._ekoChannelExtraDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoChannelExtraDao == null) {
                this._ekoChannelExtraDao = new EkoChannelExtraDao_Impl(this);
            }
            return this._ekoChannelExtraDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoMessageDao messageDao() {
        if (this._ekoMessageDao != null) {
            return this._ekoMessageDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoMessageDao == null) {
                this._ekoMessageDao = new EkoMessageDao_Impl(this);
            }
            return this._ekoMessageDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoMessageTagDao messageTagDao() {
        if (this._ekoMessageTagDao != null) {
            return this._ekoMessageTagDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoMessageTagDao == null) {
                this._ekoMessageTagDao = new EkoMessageTagDao_Impl(this);
            }
            return this._ekoMessageTagDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoInternalReactionDao reactionDao() {
        if (this._ekoInternalReactionDao != null) {
            return this._ekoInternalReactionDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoInternalReactionDao == null) {
                this._ekoInternalReactionDao = new EkoInternalReactionDao_Impl(this);
            }
            return this._ekoInternalReactionDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoMessageFlagDao messageFlagDao() {
        if (this._ekoMessageFlagDao != null) {
            return this._ekoMessageFlagDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoMessageFlagDao == null) {
                this._ekoMessageFlagDao = new EkoMessageFlagDao_Impl(this);
            }
            return this._ekoMessageFlagDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoUserDao userDao() {
        if (this._ekoUserDao != null) {
            return this._ekoUserDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoUserDao == null) {
                this._ekoUserDao = new EkoUserDao_Impl(this);
            }
            return this._ekoUserDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoUserFlagDao userFlagDao() {
        if (this._ekoUserFlagDao != null) {
            return this._ekoUserFlagDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoUserFlagDao == null) {
                this._ekoUserFlagDao = new EkoUserFlagDao_Impl(this);
            }
            return this._ekoUserFlagDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoStandardPostDao standardPostDao() {
        if (this._ekoStandardPostDao != null) {
            return this._ekoStandardPostDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoStandardPostDao == null) {
                this._ekoStandardPostDao = new EkoStandardPostDao_Impl(this);
            }
            return this._ekoStandardPostDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoPostFlagDao postFlagDao() {
        if (this._ekoPostFlagDao != null) {
            return this._ekoPostFlagDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoPostFlagDao == null) {
                this._ekoPostFlagDao = new EkoPostFlagDao_Impl(this);
            }
            return this._ekoPostFlagDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoCommentDao commentDao() {
        if (this._ekoCommentDao != null) {
            return this._ekoCommentDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoCommentDao == null) {
                this._ekoCommentDao = new EkoCommentDao_Impl(this);
            }
            return this._ekoCommentDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoCommentFlagDao commentFlagDao() {
        if (this._ekoCommentFlagDao != null) {
            return this._ekoCommentFlagDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoCommentFlagDao == null) {
                this._ekoCommentFlagDao = new EkoCommentFlagDao_Impl(this);
            }
            return this._ekoCommentFlagDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoCommunityDao communityDao() {
        if (this._ekoCommunityDao != null) {
            return this._ekoCommunityDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoCommunityDao == null) {
                this._ekoCommunityDao = new EkoCommunityDao_Impl(this);
            }
            return this._ekoCommunityDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoCommunityCategoryDao communityCategoryDao() {
        if (this._ekoCommunityCategoryDao != null) {
            return this._ekoCommunityCategoryDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoCommunityCategoryDao == null) {
                this._ekoCommunityCategoryDao = new EkoCommunityCategoryDao_Impl(this);
            }
            return this._ekoCommunityCategoryDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoCommunityMembershipDao communityMembershipDao() {
        if (this._ekoCommunityMembershipDao != null) {
            return this._ekoCommunityMembershipDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoCommunityMembershipDao == null) {
                this._ekoCommunityMembershipDao = new EkoCommunityMembershipDao_Impl(this);
            }
            return this._ekoCommunityMembershipDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoFileDao fileDao() {
        if (this._ekoFileDao != null) {
            return this._ekoFileDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoFileDao == null) {
                this._ekoFileDao = new EkoFileDao_Impl(this);
            }
            return this._ekoFileDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoCommunityWithCategoryDao communityWithCategoryDao() {
        if (this._ekoCommunityWithCategoryDao != null) {
            return this._ekoCommunityWithCategoryDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoCommunityWithCategoryDao == null) {
                this._ekoCommunityWithCategoryDao = new EkoCommunityWithCategoryDao_Impl(this);
            }
            return this._ekoCommunityWithCategoryDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoGlobalPostDao globalPostDao() {
        if (this._ekoGlobalPostDao != null) {
            return this._ekoGlobalPostDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoGlobalPostDao == null) {
                this._ekoGlobalPostDao = new EkoGlobalPostDao_Impl(this);
            }
            return this._ekoGlobalPostDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecommendedCommunityDao recommendedCommunityDao() {
        if (this._recommendedCommunityDao != null) {
            return this._recommendedCommunityDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._recommendedCommunityDao == null) {
                this._recommendedCommunityDao = new RecommendedCommunityDao_Impl(this);
            }
            return this._recommendedCommunityDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrendingCommunityDao trendingCommunityDao() {
        if (this._trendingCommunityDao != null) {
            return this._trendingCommunityDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._trendingCommunityDao == null) {
                this._trendingCommunityDao = new TrendingCommunityDao_Impl(this);
            }
            return this._trendingCommunityDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoStreamDao streamDao() {
        if (this._ekoStreamDao != null) {
            return this._ekoStreamDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoStreamDao == null) {
                this._ekoStreamDao = new EkoStreamDao_Impl(this);
            }
            return this._ekoStreamDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoStreamSessionDao streamSessionDao() {
        if (this._ekoStreamSessionDao != null) {
            return this._ekoStreamSessionDao;
        }
        UserDatabase_Impl userDatabase_Impl = this;
        synchronized (userDatabase_Impl) {
            if (this._ekoStreamSessionDao == null) {
                this._ekoStreamSessionDao = new EkoStreamSessionDao_Impl(this);
            }
            return this._ekoStreamSessionDao;
        }
    }
}

