/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;
import androidx.room.Transaction;
import com.ekoapp.ekosdk.internal.EkoStandardPost;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import io.reactivex.Flowable;
import java.util.List;

@Dao
public abstract class EkoStandardPostDao
extends EkoObjectDao<EkoStandardPost> {
    @Override
    @Delete
    public abstract void delete(EkoStandardPost var1);

    @Override
    @Query(value="DELETE from standard_post")
    public abstract void deleteAll();

    @Query(value="UPDATE standard_post set isDeleted = 1 where postId = :postId")
    public abstract void deletePostByPostId(String var1);

    @Query(value="UPDATE standard_post set commentCount = commentCount + 1 where postId = :postId")
    public abstract void incrementCommentCount(String var1);

    @Query(value="UPDATE standard_post set commentCount = commentCount - 1 where postId = :postId")
    public abstract void decrementCommentCount(String var1);

    @Query(value="UPDATE standard_post set postId = postId where postId = :postId")
    public abstract void updatePost(String var1);

    @Transaction
    @Query(value="SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.targetType= :targetType and standard_post.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and standard_post.targetId = :targetId  and standard_post.postId = post_flag.postId and standard_post.parentPostId is null order by createdAt ASC")
    abstract DataSource.Factory<Integer, EkoStandardPost> getAllByTargetTypeAndTargetIdOrderByCreatedAtAscImpl(String var1, String var2, Boolean var3);

    @Transaction
    @Query(value="SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.targetType= :targetType and standard_post.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and standard_post.targetId = :targetId  and standard_post.postId = post_flag.postId and standard_post.parentPostId is null order by createdAt DESC")
    abstract DataSource.Factory<Integer, EkoStandardPost> getAllByTargetTypeAndTargetIdOrderByCreatedAtDescImpl(String var1, String var2, Boolean var3);

    @Transaction
    @Query(value="SELECT standard_post.*, global_post.* from standard_post, global_post where standard_post.postId = global_post.postId order by global_post.createdAt ASC")
    abstract DataSource.Factory<Integer, EkoStandardPost> getGlobalPostCollectionImpl();

    public DataSource.Factory<Integer, EkoStandardPost> getUserPostCollectionOrderByCreatedAtAsc(String userId, Boolean isDeleted) {
        return this.getAllByTargetTypeAndTargetIdOrderByCreatedAtAscImpl("user", userId, isDeleted).map(input -> input);
    }

    public DataSource.Factory<Integer, EkoStandardPost> getUserPostCollectionOrderByCreatedAtDesc(String userId, Boolean isDeleted) {
        return this.getAllByTargetTypeAndTargetIdOrderByCreatedAtDescImpl("user", userId, isDeleted).map(input -> input);
    }

    public DataSource.Factory<Integer, EkoStandardPost> getCommunityPostCollectionOrderByCreatedAtDesc(String communityId, Boolean isDeleted) {
        return this.getAllByTargetTypeAndTargetIdOrderByCreatedAtDescImpl("community", communityId, isDeleted).map(input -> input);
    }

    public DataSource.Factory<Integer, EkoStandardPost> getCommunityPostCollectionOrderByCreatedAtAsc(String communityId, Boolean isDeleted) {
        return this.getAllByTargetTypeAndTargetIdOrderByCreatedAtAscImpl("community", communityId, isDeleted).map(input -> input);
    }

    public DataSource.Factory<Integer, EkoStandardPost> getGlobalPostCollection() {
        return this.getGlobalPostCollectionImpl();
    }

    @Transaction
    @Query(value="SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.postId IN (:postIds) and standard_post.postId = post_flag.postId")
    abstract List<EkoStandardPost> getByIdsNowImpl(List<String> var1);

    @Override
    public List<EkoStandardPost> getByIdsNow(List<String> postIds) {
        return this.getByIdsNowImpl(postIds);
    }

    @Transaction
    @Query(value="SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.postId IN (:postIds) and standard_post.postId = post_flag.postId LIMIT 1")
    abstract EkoStandardPost getByIdNowImpl(String var1);

    @Override
    public EkoStandardPost getByIdNow(String postId) {
        return this.getByIdNowImpl(postId);
    }

    @Query(value="UPDATE standard_post SET isDeleted = :isDeleted WHERE postId LIKE :postId ")
    abstract void updateDeletedImpl(String var1, boolean var2);

    public void updateDeleted(String postId, boolean isDeleted) {
        this.updateDeletedImpl(postId, isDeleted);
    }

    @Transaction
    @Query(value="SELECT standard_post.*, post_flag.postId as flag_postId, post_flag.flag as flag_flag, post_flag.localFlag as flag_localFlag from standard_post, post_flag where standard_post.postId IN (:postIds) and standard_post.postId = post_flag.postId LIMIT 1")
    abstract Flowable<EkoStandardPost> getPostImpl(String var1);

    public Flowable<EkoStandardPost> getPost(String postId) {
        return this.getPostImpl(postId);
    }
}

