/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.AmityTags;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.EkoInternalMessage;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoMessageDao_Impl
extends EkoMessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEkoInternalMessage;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfEkoInternalMessage;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfEkoInternalMessage;
    private final SharedSQLiteStatement __preparedStmtOfCleanUpSyncingStateOnStartup;
    private final SharedSQLiteStatement __preparedStmtOfCleanUpUploadingStateOnStartup;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllFromChannel;
    private final SharedSQLiteStatement __preparedStmtOfSoftDeleteAllFromChannel;
    private final SharedSQLiteStatement __preparedStmtOfSoftDeleteFromChannelByUserIdImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUserImpl;

    public EkoMessageDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoInternalMessage = new EntityInsertionAdapter<EkoInternalMessage>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `message`(`messageId`,`channelId`,`userId`,`parentId`,`channelSegment`,`childrenNumber`,`editedAt`,`isDeleted`,`readByCount`,`flagCount`,`tags`,`reactions`,`reactionCount`,`type`,`data`,`fileId`,`syncState`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoInternalMessage value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getParentId());
                }
                stmt.bindLong(5, (long)value.getChannelSegment());
                stmt.bindLong(6, (long)value.getChildrenNumber());
                String _tmp = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_1);
                stmt.bindLong(9, (long)value.getReadByCount());
                stmt.bindLong(10, (long)value.getFlagCount());
                String _tmp_2 = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_2);
                }
                String _tmp_3 = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_3 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_3);
                }
                stmt.bindLong(13, (long)value.getReactionCount());
                if (value.getType() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getType());
                }
                String _tmp_4 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_4);
                }
                if (value.getFileId() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getFileId());
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getSyncState());
                }
                String _tmp_5 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_5);
                }
                String _tmp_6 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_6);
                }
            }
        };
        this.__deletionAdapterOfEkoInternalMessage = new EntityDeletionOrUpdateAdapter<EkoInternalMessage>(__db){

            public String createQuery() {
                return "DELETE FROM `message` WHERE `messageId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoInternalMessage value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
            }
        };
        this.__updateAdapterOfEkoInternalMessage = new EntityDeletionOrUpdateAdapter<EkoInternalMessage>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `message` SET `messageId` = ?,`channelId` = ?,`userId` = ?,`parentId` = ?,`channelSegment` = ?,`childrenNumber` = ?,`editedAt` = ?,`isDeleted` = ?,`readByCount` = ?,`flagCount` = ?,`tags` = ?,`reactions` = ?,`reactionCount` = ?,`type` = ?,`data` = ?,`fileId` = ?,`syncState` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `messageId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoInternalMessage value) {
                if (value.getMessageId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessageId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getParentId());
                }
                stmt.bindLong(5, (long)value.getChannelSegment());
                stmt.bindLong(6, (long)value.getChildrenNumber());
                String _tmp = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_1);
                stmt.bindLong(9, (long)value.getReadByCount());
                stmt.bindLong(10, (long)value.getFlagCount());
                String _tmp_2 = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_2);
                }
                String _tmp_3 = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_3 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_3);
                }
                stmt.bindLong(13, (long)value.getReactionCount());
                if (value.getType() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getType());
                }
                String _tmp_4 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_4 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_4);
                }
                if (value.getFileId() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getFileId());
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getSyncState());
                }
                String _tmp_5 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_5);
                }
                String _tmp_6 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_6);
                }
                if (value.getMessageId() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getMessageId());
                }
            }
        };
        this.__preparedStmtOfCleanUpSyncingStateOnStartup = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set syncState = 'failed' where syncState = 'syncing'";
                return "UPDATE message set syncState = 'failed' where syncState = 'syncing'";
            }
        };
        this.__preparedStmtOfCleanUpUploadingStateOnStartup = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set syncState = 'failed' where syncState = 'uploading'";
                return "UPDATE message set syncState = 'failed' where syncState = 'uploading'";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message";
                return "DELETE from message";
            }
        };
        this.__preparedStmtOfDeleteAllFromChannel = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from message where channelId = ?";
                return "DELETE from message where channelId = ?";
            }
        };
        this.__preparedStmtOfSoftDeleteAllFromChannel = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set isDeleted = 1, data = null where channelId = ?";
                return "UPDATE message set isDeleted = 1, data = null where channelId = ?";
            }
        };
        this.__preparedStmtOfSoftDeleteFromChannelByUserIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set isDeleted = 1, data = null where channelId = ? and userId = ?";
                return "UPDATE message set isDeleted = 1, data = null where channelId = ? and userId = ?";
            }
        };
        this.__preparedStmtOfUpdateUserImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set userId = ? where userId = ?";
                return "UPDATE message set userId = ? where userId = ?";
            }
        };
    }

    @Override
    void insertImpl(EkoInternalMessage object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoInternalMessage.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoInternalMessage> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoInternalMessage.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoInternalMessage object) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoInternalMessage.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoInternalMessage> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoInternalMessage.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoInternalMessage object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoInternalMessage.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void retainLatestFromChannel(String channelId, int offset) {
        this.__db.beginTransaction();
        try {
            super.retainLatestFromChannel(channelId, offset);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void softDeleteFromChannelByUserId(String channelId, String userId) {
        this.__db.beginTransaction();
        try {
            super.softDeleteFromChannelByUserId(channelId, userId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateUser(String userId) {
        this.__db.beginTransaction();
        try {
            super.updateUser(userId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoInternalMessage message) {
        this.__db.beginTransaction();
        try {
            super.insert(message);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoInternalMessage> messages) {
        this.__db.beginTransaction();
        try {
            super.insert(messages);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoInternalMessage message) {
        this.__db.beginTransaction();
        try {
            super.update(message);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void cleanUpSyncingStateOnStartup() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfCleanUpSyncingStateOnStartup.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfCleanUpSyncingStateOnStartup.release(_stmt);
        }
    }

    @Override
    public void cleanUpUploadingStateOnStartup() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfCleanUpUploadingStateOnStartup.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfCleanUpUploadingStateOnStartup.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllFromChannel(String channelId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllFromChannel.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (channelId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, channelId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllFromChannel.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void softDeleteAllFromChannel(String channelId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSoftDeleteAllFromChannel.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (channelId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, channelId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSoftDeleteAllFromChannel.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void softDeleteFromChannelByUserIdImpl(String channelId, String userId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSoftDeleteFromChannelByUserIdImpl.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (channelId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, channelId);
            }
            _argIndex = 2;
            if (userId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, userId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSoftDeleteFromChannelByUserIdImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateUserImpl(String userId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUserImpl.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (userId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, userId);
            }
            _argIndex = 2;
            if (userId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, userId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUserImpl.release(_stmt);
        }
    }

    @Override
    public Flowable<Integer> getCount() {
        String _sql = "SELECT count(*) from message";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from message", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"message"}, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                try (Cursor _cursor = EkoMessageDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    Integer _result;
                    if (_cursor.moveToFirst()) {
                        Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                        _result = _tmp;
                    } else {
                        _result = null;
                    }
                    Integer n = _result;
                    return n;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<Integer> getCount(String channelId) {
        String _sql = "SELECT count(*) from message where channelId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from message where channelId = ?", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"message"}, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                try (Cursor _cursor = EkoMessageDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    Integer _result;
                    if (_cursor.moveToFirst()) {
                        Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                        _result = _tmp;
                    } else {
                        _result = null;
                    }
                    Integer n = _result;
                    return n;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    DataSource.Factory<Integer, EkoInternalMessage> getAllImpl(String channelId, String[] excludingTags) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.messageId = message_flag.messageId and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) order by channelSegment ASC");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        for (String _item : excludingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new DataSource.Factory<Integer, EkoInternalMessage>(){

            public LimitOffsetDataSource<EkoInternalMessage> create() {
                return new LimitOffsetDataSource<EkoInternalMessage>(EkoMessageDao_Impl.this.__db, _statement, false, new String[]{"message", "message_flag", "message_tag"}){

                    protected List<EkoInternalMessage> convertRows(Cursor cursor) {
                        int _cursorIndexOfMessageId = cursor.getColumnIndexOrThrow("messageId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfParentId = cursor.getColumnIndexOrThrow("parentId");
                        int _cursorIndexOfChannelSegment = cursor.getColumnIndexOrThrow("channelSegment");
                        int _cursorIndexOfChildrenNumber = cursor.getColumnIndexOrThrow("childrenNumber");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfReadByCount = cursor.getColumnIndexOrThrow("readByCount");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfFileId = cursor.getColumnIndexOrThrow("fileId");
                        int _cursorIndexOfSyncState = cursor.getColumnIndexOrThrow("syncState");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoInternalMessage> _res = new ArrayList<EkoInternalMessage>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoInternalMessage _item_1 = new EkoInternalMessage();
                            String _tmpMessageId = cursor.getString(_cursorIndexOfMessageId);
                            _item_1.setMessageId(_tmpMessageId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item_1.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item_1.setUserId(_tmpUserId);
                            String _tmpParentId = cursor.getString(_cursorIndexOfParentId);
                            _item_1.setParentId(_tmpParentId);
                            int _tmpChannelSegment = cursor.getInt(_cursorIndexOfChannelSegment);
                            _item_1.setChannelSegment(_tmpChannelSegment);
                            int _tmpChildrenNumber = cursor.getInt(_cursorIndexOfChildrenNumber);
                            _item_1.setChildrenNumber(_tmpChildrenNumber);
                            String _tmp = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item_1.setEditedAt(_tmpEditedAt);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_1 != 0;
                            _item_1.setDeleted(_tmpIsDeleted);
                            int _tmpReadByCount = cursor.getInt(_cursorIndexOfReadByCount);
                            _item_1.setReadByCount(_tmpReadByCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item_1.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                            _item_1.setTags(_tmpTags);
                            String _tmp_3 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                            _item_1.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item_1.setReactionCount(_tmpReactionCount);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item_1.setType(_tmpType);
                            String _tmp_4 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item_1.setData(_tmpData);
                            String _tmpFileId = cursor.getString(_cursorIndexOfFileId);
                            _item_1.setFileId(_tmpFileId);
                            String _tmpSyncState = cursor.getString(_cursorIndexOfSyncState);
                            _item_1.setSyncState(_tmpSyncState);
                            String _tmp_5 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                            _item_1.setCreatedAt(_tmpCreatedAt);
                            String _tmp_6 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item_1.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item_1);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoInternalMessage> getAllByParentIdImpl(String channelId, String parentId, String[] excludingTags) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.messageId = message_flag.messageId and message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) order by channelSegment ASC");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 3;
        for (String _item : excludingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new DataSource.Factory<Integer, EkoInternalMessage>(){

            public LimitOffsetDataSource<EkoInternalMessage> create() {
                return new LimitOffsetDataSource<EkoInternalMessage>(EkoMessageDao_Impl.this.__db, _statement, false, new String[]{"message", "message_flag", "message_tag"}){

                    protected List<EkoInternalMessage> convertRows(Cursor cursor) {
                        int _cursorIndexOfMessageId = cursor.getColumnIndexOrThrow("messageId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfParentId = cursor.getColumnIndexOrThrow("parentId");
                        int _cursorIndexOfChannelSegment = cursor.getColumnIndexOrThrow("channelSegment");
                        int _cursorIndexOfChildrenNumber = cursor.getColumnIndexOrThrow("childrenNumber");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfReadByCount = cursor.getColumnIndexOrThrow("readByCount");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfFileId = cursor.getColumnIndexOrThrow("fileId");
                        int _cursorIndexOfSyncState = cursor.getColumnIndexOrThrow("syncState");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoInternalMessage> _res = new ArrayList<EkoInternalMessage>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoInternalMessage _item_1 = new EkoInternalMessage();
                            String _tmpMessageId = cursor.getString(_cursorIndexOfMessageId);
                            _item_1.setMessageId(_tmpMessageId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item_1.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item_1.setUserId(_tmpUserId);
                            String _tmpParentId = cursor.getString(_cursorIndexOfParentId);
                            _item_1.setParentId(_tmpParentId);
                            int _tmpChannelSegment = cursor.getInt(_cursorIndexOfChannelSegment);
                            _item_1.setChannelSegment(_tmpChannelSegment);
                            int _tmpChildrenNumber = cursor.getInt(_cursorIndexOfChildrenNumber);
                            _item_1.setChildrenNumber(_tmpChildrenNumber);
                            String _tmp = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item_1.setEditedAt(_tmpEditedAt);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_1 != 0;
                            _item_1.setDeleted(_tmpIsDeleted);
                            int _tmpReadByCount = cursor.getInt(_cursorIndexOfReadByCount);
                            _item_1.setReadByCount(_tmpReadByCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item_1.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                            _item_1.setTags(_tmpTags);
                            String _tmp_3 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                            _item_1.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item_1.setReactionCount(_tmpReactionCount);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item_1.setType(_tmpType);
                            String _tmp_4 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item_1.setData(_tmpData);
                            String _tmpFileId = cursor.getString(_cursorIndexOfFileId);
                            _item_1.setFileId(_tmpFileId);
                            String _tmpSyncState = cursor.getString(_cursorIndexOfSyncState);
                            _item_1.setSyncState(_tmpSyncState);
                            String _tmp_5 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                            _item_1.setCreatedAt(_tmpCreatedAt);
                            String _tmp_6 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item_1.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item_1);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoInternalMessage> getAllByParentIdImpl(String channelId, String[] excludingTags) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.messageId = message_flag.messageId and message.parentId is null and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) order by channelSegment ASC");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        for (String _item : excludingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new DataSource.Factory<Integer, EkoInternalMessage>(){

            public LimitOffsetDataSource<EkoInternalMessage> create() {
                return new LimitOffsetDataSource<EkoInternalMessage>(EkoMessageDao_Impl.this.__db, _statement, false, new String[]{"message", "message_flag", "message_tag"}){

                    protected List<EkoInternalMessage> convertRows(Cursor cursor) {
                        int _cursorIndexOfMessageId = cursor.getColumnIndexOrThrow("messageId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfParentId = cursor.getColumnIndexOrThrow("parentId");
                        int _cursorIndexOfChannelSegment = cursor.getColumnIndexOrThrow("channelSegment");
                        int _cursorIndexOfChildrenNumber = cursor.getColumnIndexOrThrow("childrenNumber");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfReadByCount = cursor.getColumnIndexOrThrow("readByCount");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfFileId = cursor.getColumnIndexOrThrow("fileId");
                        int _cursorIndexOfSyncState = cursor.getColumnIndexOrThrow("syncState");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoInternalMessage> _res = new ArrayList<EkoInternalMessage>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoInternalMessage _item_1 = new EkoInternalMessage();
                            String _tmpMessageId = cursor.getString(_cursorIndexOfMessageId);
                            _item_1.setMessageId(_tmpMessageId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item_1.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item_1.setUserId(_tmpUserId);
                            String _tmpParentId = cursor.getString(_cursorIndexOfParentId);
                            _item_1.setParentId(_tmpParentId);
                            int _tmpChannelSegment = cursor.getInt(_cursorIndexOfChannelSegment);
                            _item_1.setChannelSegment(_tmpChannelSegment);
                            int _tmpChildrenNumber = cursor.getInt(_cursorIndexOfChildrenNumber);
                            _item_1.setChildrenNumber(_tmpChildrenNumber);
                            String _tmp = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item_1.setEditedAt(_tmpEditedAt);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_1 != 0;
                            _item_1.setDeleted(_tmpIsDeleted);
                            int _tmpReadByCount = cursor.getInt(_cursorIndexOfReadByCount);
                            _item_1.setReadByCount(_tmpReadByCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item_1.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                            _item_1.setTags(_tmpTags);
                            String _tmp_3 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                            _item_1.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item_1.setReactionCount(_tmpReactionCount);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item_1.setType(_tmpType);
                            String _tmp_4 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item_1.setData(_tmpData);
                            String _tmpFileId = cursor.getString(_cursorIndexOfFileId);
                            _item_1.setFileId(_tmpFileId);
                            String _tmpSyncState = cursor.getString(_cursorIndexOfSyncState);
                            _item_1.setSyncState(_tmpSyncState);
                            String _tmp_5 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                            _item_1.setCreatedAt(_tmpCreatedAt);
                            String _tmp_6 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item_1.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item_1);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoInternalMessage> getAllByTagsImpl(String channelId, String[] includingTags, String[] excludingTags) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.messageId = message_flag.messageId and message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) order by channelSegment ASC");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        for (String _item : includingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        for (String _item_1 : excludingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        return new DataSource.Factory<Integer, EkoInternalMessage>(){

            public LimitOffsetDataSource<EkoInternalMessage> create() {
                return new LimitOffsetDataSource<EkoInternalMessage>(EkoMessageDao_Impl.this.__db, _statement, false, new String[]{"message", "message_flag", "message_tag"}){

                    protected List<EkoInternalMessage> convertRows(Cursor cursor) {
                        int _cursorIndexOfMessageId = cursor.getColumnIndexOrThrow("messageId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfParentId = cursor.getColumnIndexOrThrow("parentId");
                        int _cursorIndexOfChannelSegment = cursor.getColumnIndexOrThrow("channelSegment");
                        int _cursorIndexOfChildrenNumber = cursor.getColumnIndexOrThrow("childrenNumber");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfReadByCount = cursor.getColumnIndexOrThrow("readByCount");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfFileId = cursor.getColumnIndexOrThrow("fileId");
                        int _cursorIndexOfSyncState = cursor.getColumnIndexOrThrow("syncState");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoInternalMessage> _res = new ArrayList<EkoInternalMessage>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoInternalMessage _item_2 = new EkoInternalMessage();
                            String _tmpMessageId = cursor.getString(_cursorIndexOfMessageId);
                            _item_2.setMessageId(_tmpMessageId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item_2.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item_2.setUserId(_tmpUserId);
                            String _tmpParentId = cursor.getString(_cursorIndexOfParentId);
                            _item_2.setParentId(_tmpParentId);
                            int _tmpChannelSegment = cursor.getInt(_cursorIndexOfChannelSegment);
                            _item_2.setChannelSegment(_tmpChannelSegment);
                            int _tmpChildrenNumber = cursor.getInt(_cursorIndexOfChildrenNumber);
                            _item_2.setChildrenNumber(_tmpChildrenNumber);
                            String _tmp = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item_2.setEditedAt(_tmpEditedAt);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_1 != 0;
                            _item_2.setDeleted(_tmpIsDeleted);
                            int _tmpReadByCount = cursor.getInt(_cursorIndexOfReadByCount);
                            _item_2.setReadByCount(_tmpReadByCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item_2.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                            _item_2.setTags(_tmpTags);
                            String _tmp_3 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                            _item_2.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item_2.setReactionCount(_tmpReactionCount);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item_2.setType(_tmpType);
                            String _tmp_4 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item_2.setData(_tmpData);
                            String _tmpFileId = cursor.getString(_cursorIndexOfFileId);
                            _item_2.setFileId(_tmpFileId);
                            String _tmpSyncState = cursor.getString(_cursorIndexOfSyncState);
                            _item_2.setSyncState(_tmpSyncState);
                            String _tmp_5 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                            _item_2.setCreatedAt(_tmpCreatedAt);
                            String _tmp_6 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item_2.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item_2);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoInternalMessage> getAllByParentIdAndTagsImpl(String channelId, String parentId, String[] includingTags, String[] excludingTags) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.messageId = message_flag.messageId and message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) order by channelSegment ASC");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 3;
        for (String _item : includingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 3 + _inputSize;
        for (String _item_1 : excludingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        return new DataSource.Factory<Integer, EkoInternalMessage>(){

            public LimitOffsetDataSource<EkoInternalMessage> create() {
                return new LimitOffsetDataSource<EkoInternalMessage>(EkoMessageDao_Impl.this.__db, _statement, false, new String[]{"message", "message_flag", "message_tag"}){

                    protected List<EkoInternalMessage> convertRows(Cursor cursor) {
                        int _cursorIndexOfMessageId = cursor.getColumnIndexOrThrow("messageId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfParentId = cursor.getColumnIndexOrThrow("parentId");
                        int _cursorIndexOfChannelSegment = cursor.getColumnIndexOrThrow("channelSegment");
                        int _cursorIndexOfChildrenNumber = cursor.getColumnIndexOrThrow("childrenNumber");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfReadByCount = cursor.getColumnIndexOrThrow("readByCount");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfFileId = cursor.getColumnIndexOrThrow("fileId");
                        int _cursorIndexOfSyncState = cursor.getColumnIndexOrThrow("syncState");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoInternalMessage> _res = new ArrayList<EkoInternalMessage>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoInternalMessage _item_2 = new EkoInternalMessage();
                            String _tmpMessageId = cursor.getString(_cursorIndexOfMessageId);
                            _item_2.setMessageId(_tmpMessageId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item_2.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item_2.setUserId(_tmpUserId);
                            String _tmpParentId = cursor.getString(_cursorIndexOfParentId);
                            _item_2.setParentId(_tmpParentId);
                            int _tmpChannelSegment = cursor.getInt(_cursorIndexOfChannelSegment);
                            _item_2.setChannelSegment(_tmpChannelSegment);
                            int _tmpChildrenNumber = cursor.getInt(_cursorIndexOfChildrenNumber);
                            _item_2.setChildrenNumber(_tmpChildrenNumber);
                            String _tmp = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item_2.setEditedAt(_tmpEditedAt);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_1 != 0;
                            _item_2.setDeleted(_tmpIsDeleted);
                            int _tmpReadByCount = cursor.getInt(_cursorIndexOfReadByCount);
                            _item_2.setReadByCount(_tmpReadByCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item_2.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                            _item_2.setTags(_tmpTags);
                            String _tmp_3 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                            _item_2.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item_2.setReactionCount(_tmpReactionCount);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item_2.setType(_tmpType);
                            String _tmp_4 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item_2.setData(_tmpData);
                            String _tmpFileId = cursor.getString(_cursorIndexOfFileId);
                            _item_2.setFileId(_tmpFileId);
                            String _tmpSyncState = cursor.getString(_cursorIndexOfSyncState);
                            _item_2.setSyncState(_tmpSyncState);
                            String _tmp_5 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                            _item_2.setCreatedAt(_tmpCreatedAt);
                            String _tmp_6 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item_2.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item_2);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoInternalMessage> getAllByParentIdAndTagsImpl(String channelId, String[] includingTags, String[] excludingTags) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.messageId = message_flag.messageId and message.parentId is null and message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) order by channelSegment ASC");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize + _inputSize_1;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        for (String _item : includingTags) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        for (String _item_1 : excludingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        return new DataSource.Factory<Integer, EkoInternalMessage>(){

            public LimitOffsetDataSource<EkoInternalMessage> create() {
                return new LimitOffsetDataSource<EkoInternalMessage>(EkoMessageDao_Impl.this.__db, _statement, false, new String[]{"message", "message_flag", "message_tag"}){

                    protected List<EkoInternalMessage> convertRows(Cursor cursor) {
                        int _cursorIndexOfMessageId = cursor.getColumnIndexOrThrow("messageId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfParentId = cursor.getColumnIndexOrThrow("parentId");
                        int _cursorIndexOfChannelSegment = cursor.getColumnIndexOrThrow("channelSegment");
                        int _cursorIndexOfChildrenNumber = cursor.getColumnIndexOrThrow("childrenNumber");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfReadByCount = cursor.getColumnIndexOrThrow("readByCount");
                        int _cursorIndexOfFlagCount = cursor.getColumnIndexOrThrow("flagCount");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfReactions = cursor.getColumnIndexOrThrow("reactions");
                        int _cursorIndexOfReactionCount = cursor.getColumnIndexOrThrow("reactionCount");
                        int _cursorIndexOfType = cursor.getColumnIndexOrThrow("type");
                        int _cursorIndexOfData = cursor.getColumnIndexOrThrow("data");
                        int _cursorIndexOfFileId = cursor.getColumnIndexOrThrow("fileId");
                        int _cursorIndexOfSyncState = cursor.getColumnIndexOrThrow("syncState");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoInternalMessage> _res = new ArrayList<EkoInternalMessage>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoInternalMessage _item_2 = new EkoInternalMessage();
                            String _tmpMessageId = cursor.getString(_cursorIndexOfMessageId);
                            _item_2.setMessageId(_tmpMessageId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item_2.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item_2.setUserId(_tmpUserId);
                            String _tmpParentId = cursor.getString(_cursorIndexOfParentId);
                            _item_2.setParentId(_tmpParentId);
                            int _tmpChannelSegment = cursor.getInt(_cursorIndexOfChannelSegment);
                            _item_2.setChannelSegment(_tmpChannelSegment);
                            int _tmpChildrenNumber = cursor.getInt(_cursorIndexOfChildrenNumber);
                            _item_2.setChildrenNumber(_tmpChildrenNumber);
                            String _tmp = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item_2.setEditedAt(_tmpEditedAt);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_1 != 0;
                            _item_2.setDeleted(_tmpIsDeleted);
                            int _tmpReadByCount = cursor.getInt(_cursorIndexOfReadByCount);
                            _item_2.setReadByCount(_tmpReadByCount);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            _item_2.setFlagCount(_tmpFlagCount);
                            String _tmp_2 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                            _item_2.setTags(_tmpTags);
                            String _tmp_3 = cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                            _item_2.setReactions(_tmpReactions);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            _item_2.setReactionCount(_tmpReactionCount);
                            String _tmpType = cursor.getString(_cursorIndexOfType);
                            _item_2.setType(_tmpType);
                            String _tmp_4 = cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item_2.setData(_tmpData);
                            String _tmpFileId = cursor.getString(_cursorIndexOfFileId);
                            _item_2.setFileId(_tmpFileId);
                            String _tmpSyncState = cursor.getString(_cursorIndexOfSyncState);
                            _item_2.setSyncState(_tmpSyncState);
                            String _tmp_5 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                            _item_2.setCreatedAt(_tmpCreatedAt);
                            String _tmp_6 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item_2.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item_2);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHighestChannelSegment(String channelId) {
        String _sql = "SELECT channelSegment from message where channelId = ? order by channelSegment DESC LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channelSegment from message where channelId = ? order by channelSegment DESC LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<EkoInternalMessage> getLatestMessageImpl(String channelId) {
        String _sql = "SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = ? and message.messageId = message_flag.messageId order by channelSegment DESC LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.channelId = ? and message.messageId = message_flag.messageId order by channelSegment DESC LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"message", "message_flag"}, (Callable)new Callable<EkoInternalMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoInternalMessage call() throws Exception {
                try (Cursor _cursor = EkoMessageDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    EkoInternalMessage _result;
                    int _cursorIndexOfMessageId = _cursor.getColumnIndexOrThrow("messageId");
                    int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
                    int _cursorIndexOfChannelSegment = _cursor.getColumnIndexOrThrow("channelSegment");
                    int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
                    int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                    int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                    int _cursorIndexOfReadByCount = _cursor.getColumnIndexOrThrow("readByCount");
                    int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                    int _cursorIndexOfTags = _cursor.getColumnIndexOrThrow("tags");
                    int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
                    int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
                    int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("fileId");
                    int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoInternalMessage();
                        String _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _result.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _result.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp = _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_1 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmpReadByCount = _cursor.getInt(_cursorIndexOfReadByCount);
                        _result.setReadByCount(_tmpReadByCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                        _result.setTags(_tmpTags);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _result.setData(_tmpData);
                        String _tmpFileId = _cursor.getString(_cursorIndexOfFileId);
                        _result.setFileId(_tmpFileId);
                        String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoInternalMessage ekoInternalMessage = _result;
                    return ekoInternalMessage;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<EkoInternalMessage> getOldMessages(String channelId, int offset) {
        String _sql = "SELECT * from message where channelId = ? order by createdAt DESC LIMIT -1 OFFSET ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message where channelId = ? order by createdAt DESC LIMIT -1 OFFSET ?", (int)2);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)offset);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfMessageId = _cursor.getColumnIndexOrThrow("messageId");
            int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
            int _cursorIndexOfChannelSegment = _cursor.getColumnIndexOrThrow("channelSegment");
            int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfReadByCount = _cursor.getColumnIndexOrThrow("readByCount");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfTags = _cursor.getColumnIndexOrThrow("tags");
            int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
            int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
            int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("fileId");
            int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<EkoInternalMessage> _result = new ArrayList<EkoInternalMessage>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoInternalMessage _item = new EkoInternalMessage();
                String _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
                _item.setMessageId(_tmpMessageId);
                String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                _item.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _item.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                _item.setParentId(_tmpParentId);
                int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                _item.setChannelSegment(_tmpChannelSegment);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                _item.setChildrenNumber(_tmpChildrenNumber);
                String _tmp = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setEditedAt(_tmpEditedAt);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _item.setDeleted(_tmpIsDeleted);
                int _tmpReadByCount = _cursor.getInt(_cursorIndexOfReadByCount);
                _item.setReadByCount(_tmpReadByCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                _item.setTags(_tmpTags);
                String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _item.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item.setReactionCount(_tmpReactionCount);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item.setType(_tmpType);
                String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item.setData(_tmpData);
                String _tmpFileId = _cursor.getString(_cursorIndexOfFileId);
                _item.setFileId(_tmpFileId);
                String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                _item.setSyncState(_tmpSyncState);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_6 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoInternalMessage> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<EkoInternalMessage> getByIdImpl(String messageId) {
        String _sql = "SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId = ? and message.messageId = message_flag.messageId LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId = ? and message.messageId = message_flag.messageId LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"message", "message_flag"}, (Callable)new Callable<EkoInternalMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoInternalMessage call() throws Exception {
                try (Cursor _cursor = EkoMessageDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    EkoInternalMessage _result;
                    int _cursorIndexOfMessageId = _cursor.getColumnIndexOrThrow("messageId");
                    int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
                    int _cursorIndexOfChannelSegment = _cursor.getColumnIndexOrThrow("channelSegment");
                    int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
                    int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                    int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                    int _cursorIndexOfReadByCount = _cursor.getColumnIndexOrThrow("readByCount");
                    int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                    int _cursorIndexOfTags = _cursor.getColumnIndexOrThrow("tags");
                    int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
                    int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
                    int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
                    int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
                    int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("fileId");
                    int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoInternalMessage();
                        String _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
                        _result.setMessageId(_tmpMessageId);
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                        _result.setParentId(_tmpParentId);
                        int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                        _result.setChannelSegment(_tmpChannelSegment);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        _result.setChildrenNumber(_tmpChildrenNumber);
                        String _tmp = _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setEditedAt(_tmpEditedAt);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_1 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmpReadByCount = _cursor.getInt(_cursorIndexOfReadByCount);
                        _result.setReadByCount(_tmpReadByCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                        _result.setTags(_tmpTags);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        String _tmpType = _cursor.getString(_cursorIndexOfType);
                        _result.setType(_tmpType);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _result.setData(_tmpData);
                        String _tmpFileId = _cursor.getString(_cursorIndexOfFileId);
                        _result.setFileId(_tmpFileId);
                        String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoMessageDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoInternalMessage ekoInternalMessage = _result;
                    return ekoInternalMessage;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoInternalMessage getByIdNowImpl(String messageId) {
        String _sql = "SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId = ? and message.messageId = message_flag.messageId LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId = ? and message.messageId = message_flag.messageId LIMIT 1", (int)1);
        int _argIndex = 1;
        if (messageId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, messageId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            EkoInternalMessage _result;
            int _cursorIndexOfMessageId = _cursor.getColumnIndexOrThrow("messageId");
            int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
            int _cursorIndexOfChannelSegment = _cursor.getColumnIndexOrThrow("channelSegment");
            int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfReadByCount = _cursor.getColumnIndexOrThrow("readByCount");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfTags = _cursor.getColumnIndexOrThrow("tags");
            int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
            int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
            int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("fileId");
            int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoInternalMessage();
                String _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
                _result.setMessageId(_tmpMessageId);
                String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                _result.setParentId(_tmpParentId);
                int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                _result.setChannelSegment(_tmpChannelSegment);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                _result.setChildrenNumber(_tmpChildrenNumber);
                String _tmp = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setEditedAt(_tmpEditedAt);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _result.setDeleted(_tmpIsDeleted);
                int _tmpReadByCount = _cursor.getInt(_cursorIndexOfReadByCount);
                _result.setReadByCount(_tmpReadByCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                _result.setTags(_tmpTags);
                String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _result.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _result.setReactionCount(_tmpReactionCount);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _result.setType(_tmpType);
                String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _result.setData(_tmpData);
                String _tmpFileId = _cursor.getString(_cursorIndexOfFileId);
                _result.setFileId(_tmpFileId);
                String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                _result.setSyncState(_tmpSyncState);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_6 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            EkoInternalMessage ekoInternalMessage = _result;
            return ekoInternalMessage;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<EkoInternalMessage> getByIdsNowImpl(List<String> messageIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT message.*, message_flag.messageId as flag_messageId, message_flag.flag as flag_flag, message_flag.localFlag as flag_localFlag from message, message_flag where message.messageId IN (");
        int _inputSize = messageIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and message.messageId = message_flag.messageId");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : messageIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfMessageId = _cursor.getColumnIndexOrThrow("messageId");
            int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfParentId = _cursor.getColumnIndexOrThrow("parentId");
            int _cursorIndexOfChannelSegment = _cursor.getColumnIndexOrThrow("channelSegment");
            int _cursorIndexOfChildrenNumber = _cursor.getColumnIndexOrThrow("childrenNumber");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfReadByCount = _cursor.getColumnIndexOrThrow("readByCount");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfTags = _cursor.getColumnIndexOrThrow("tags");
            int _cursorIndexOfReactions = _cursor.getColumnIndexOrThrow("reactions");
            int _cursorIndexOfReactionCount = _cursor.getColumnIndexOrThrow("reactionCount");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfData = _cursor.getColumnIndexOrThrow("data");
            int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("fileId");
            int _cursorIndexOfSyncState = _cursor.getColumnIndexOrThrow("syncState");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<EkoInternalMessage> _result = new ArrayList<EkoInternalMessage>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoInternalMessage _item_1 = new EkoInternalMessage();
                String _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
                _item_1.setMessageId(_tmpMessageId);
                String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                _item_1.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _item_1.setUserId(_tmpUserId);
                String _tmpParentId = _cursor.getString(_cursorIndexOfParentId);
                _item_1.setParentId(_tmpParentId);
                int _tmpChannelSegment = _cursor.getInt(_cursorIndexOfChannelSegment);
                _item_1.setChannelSegment(_tmpChannelSegment);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                _item_1.setChildrenNumber(_tmpChildrenNumber);
                String _tmp = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item_1.setEditedAt(_tmpEditedAt);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                int _tmpReadByCount = _cursor.getInt(_cursorIndexOfReadByCount);
                _item_1.setReadByCount(_tmpReadByCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item_1.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                _item_1.setTags(_tmpTags);
                String _tmp_3 = _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _item_1.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item_1.setReactionCount(_tmpReactionCount);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item_1.setType(_tmpType);
                String _tmp_4 = _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item_1.setData(_tmpData);
                String _tmpFileId = _cursor.getString(_cursorIndexOfFileId);
                _item_1.setFileId(_tmpFileId);
                String _tmpSyncState = _cursor.getString(_cursorIndexOfSyncState);
                _item_1.setSyncState(_tmpSyncState);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_6 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item_1);
            }
            ArrayList<EkoInternalMessage> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

