/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public final class EkoFileDao_Impl
extends EkoFileDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEkoFileEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfEkoFileEntity;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfEkoFileEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoFileDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoFileEntity = new EntityInsertionAdapter<EkoFileEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `file`(`fileId`,`fileUrl`,`filePath`,`type`,`attributes`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoFileEntity value) {
                if (value.getFileId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFileId());
                }
                if (value.getFileUrl() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFileUrl());
                }
                if (value.getFilePath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFilePath());
                }
                if (value.getType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getType());
                }
                String _tmp = EkoFileDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getAttributes());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfEkoFileEntity = new EntityDeletionOrUpdateAdapter<EkoFileEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `file` WHERE `fileId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoFileEntity value) {
                if (value.getFileId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFileId());
                }
            }
        };
        this.__updateAdapterOfEkoFileEntity = new EntityDeletionOrUpdateAdapter<EkoFileEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `file` SET `fileId` = ?,`fileUrl` = ?,`filePath` = ?,`type` = ?,`attributes` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `fileId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoFileEntity value) {
                if (value.getFileId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getFileId());
                }
                if (value.getFileUrl() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFileUrl());
                }
                if (value.getFilePath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFilePath());
                }
                if (value.getType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getType());
                }
                String _tmp = EkoFileDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getAttributes());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                if (value.getFileId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getFileId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from file";
                return "DELETE from file";
            }
        };
    }

    @Override
    void insertImpl(EkoFileEntity object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoFileEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoFileEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoFileEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoFileEntity object) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoFileEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoFileEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoFileEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoFileEntity object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoFileEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoFileEntity object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoFileEntity> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoFileEntity object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoFileEntity getByIdNowImpl(String fileId) {
        String _sql = "SELECT * from file where file.fileId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from file where file.fileId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (fileId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, fileId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            EkoFileEntity _result;
            int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("fileId");
            int _cursorIndexOfFileUrl = _cursor.getColumnIndexOrThrow("fileUrl");
            int _cursorIndexOfFilePath = _cursor.getColumnIndexOrThrow("filePath");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfAttributes = _cursor.getColumnIndexOrThrow("attributes");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoFileEntity();
                String _tmpFileId = _cursor.getString(_cursorIndexOfFileId);
                _result.setFileId(_tmpFileId);
                String _tmpFileUrl = _cursor.getString(_cursorIndexOfFileUrl);
                _result.setFileUrl(_tmpFileUrl);
                String _tmpFilePath = _cursor.getString(_cursorIndexOfFilePath);
                _result.setFilePath(_tmpFilePath);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _result.setType(_tmpType);
                String _tmp = _cursor.getString(_cursorIndexOfAttributes);
                JsonObject _tmpAttributes = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setAttributes(_tmpAttributes);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_2 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            EkoFileEntity ekoFileEntity = _result;
            return ekoFileEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<EkoFileEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from file where file.fileId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("fileId");
            int _cursorIndexOfFileUrl = _cursor.getColumnIndexOrThrow("fileUrl");
            int _cursorIndexOfFilePath = _cursor.getColumnIndexOrThrow("filePath");
            int _cursorIndexOfType = _cursor.getColumnIndexOrThrow("type");
            int _cursorIndexOfAttributes = _cursor.getColumnIndexOrThrow("attributes");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<EkoFileEntity> _result = new ArrayList<EkoFileEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoFileEntity _item_1 = new EkoFileEntity();
                String _tmpFileId = _cursor.getString(_cursorIndexOfFileId);
                _item_1.setFileId(_tmpFileId);
                String _tmpFileUrl = _cursor.getString(_cursorIndexOfFileUrl);
                _item_1.setFileUrl(_tmpFileUrl);
                String _tmpFilePath = _cursor.getString(_cursorIndexOfFilePath);
                _item_1.setFilePath(_tmpFilePath);
                String _tmpType = _cursor.getString(_cursorIndexOfType);
                _item_1.setType(_tmpType);
                String _tmp = _cursor.getString(_cursorIndexOfAttributes);
                JsonObject _tmpAttributes = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item_1.setAttributes(_tmpAttributes);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_2 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item_1);
            }
            ArrayList<EkoFileEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

