/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.boundarycallback;

import androidx.arch.core.util.Function;
import androidx.core.util.Pair;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.amity.socialcloud.sdk.core.user.AmityUserSortOption;
import com.ekoapp.core.utils.PropertyUtilsKt;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.UserQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.UserQueryRequest;
import com.ekoapp.ekosdk.internal.data.model.EkoUserQueryToken;
import com.github.davidmoten.rx2.RetryWhen;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0004:\u0001)B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002J\b\u0010!\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020\u001fJ\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0014\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00060\u0006 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoUserBoundaryCallback;", "Landroidx/paging/PagedList$BoundaryCallback;", "Lcom/amity/socialcloud/sdk/core/user/AmityUser;", "Lio/reactivex/CompletableObserver;", "Landroidx/arch/core/util/Function;", "keyword", "", "sortOption", "Lcom/amity/socialcloud/sdk/core/user/AmityUserSortOption;", "pageSize", "", "delaySubject", "Lio/reactivex/subjects/Subject;", "", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/core/user/AmityUserSortOption;ILio/reactivex/subjects/Subject;)V", "getPageSize", "()I", "userIdAndTokenMap", "", "Landroidx/core/util/Pair;", "userIdSet", "", "kotlin.jvm.PlatformType", "", "apply", "input", "call", "Lio/reactivex/Completable;", "options", "Lcom/ekoapp/ekosdk/internal/api/socket/request/UserQueryRequest$UserQueryOptions;", "mapByUser", "", "userId", "onComplete", "onError", "e", "", "onFirstLoaded", "onSubscribe", "d", "Lio/reactivex/disposables/Disposable;", "Companion", "amity-sdk_release"})
public final class EkoUserBoundaryCallback
extends PagedList.BoundaryCallback<AmityUser>
implements CompletableObserver,
Function<AmityUser, AmityUser> {
    private final Map<String, Pair<String, Boolean>> userIdAndTokenMap;
    private final Set<String> userIdSet;
    private final String keyword;
    private final AmityUserSortOption sortOption;
    private final int pageSize;
    private final Subject<Boolean> delaySubject;
    private static final Executor SINGLE_THREAD_EXECUTOR;
    public static final Companion Companion;

    public void onSubscribe(@NotNull Disposable d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
    }

    public void onComplete() {
    }

    public void onError(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
    }

    public final void onFirstLoaded() {
        Timber.tag((String)((Object)((Object)this)).getClass().getName()).i("onFirstLoaded", new Object[0]);
        UserQueryRequest.UserQueryOptions options = new UserQueryRequest.UserQueryOptions(this.pageSize, null, 2, null);
        this.call(options).doOnComplete(new Action(this){
            final /* synthetic */ EkoUserBoundaryCallback this$0;

            public final void run() {
                EkoUserBoundaryCallback.access$getDelaySubject$p(this.this$0).onComplete();
            }
            {
                this.this$0 = ekoUserBoundaryCallback;
            }
        }).doOnError((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ EkoUserBoundaryCallback this$0;

            public final void accept(Throwable it) {
                EkoUserBoundaryCallback.access$getDelaySubject$p(this.this$0).onComplete();
            }
            {
                this.this$0 = ekoUserBoundaryCallback;
            }
        }).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
    }

    @NotNull
    public AmityUser apply(@NotNull AmityUser input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        this.userIdSet.add(input.getUserId());
        this.mapByUser(input.getUserId());
        return input;
    }

    private final void mapByUser(String userId) {
        block1: {
            Pair<String, Boolean> pair = this.userIdAndTokenMap.get(userId);
            if (pair == null) break block1;
            Pair<String, Boolean> pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair<String, Boolean> tokenAndStatusNonNull = pair2;
            boolean bl3 = false;
            CharSequence charSequence = (CharSequence)tokenAndStatusNonNull.first;
            boolean bl4 = false;
            boolean bl5 = false;
            if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)((Boolean)tokenAndStatusNonNull.second), (Object)true)) {
                return;
            }
            UserQueryRequest.UserQueryOptions options = new UserQueryRequest.UserQueryOptions(null, null, 3, null);
            options.setToken((String)tokenAndStatusNonNull.first);
            Timber.tag((String)((Object)((Object)this)).getClass().getName()).i("map userId:" + userId, new Object[0]);
            this.call(options).doOnSubscribe((Consumer)new Consumer<Disposable>(tokenAndStatusNonNull, this, userId){
                final /* synthetic */ Pair $tokenAndStatusNonNull;
                final /* synthetic */ EkoUserBoundaryCallback this$0;
                final /* synthetic */ String $userId$inlined;
                {
                    this.$tokenAndStatusNonNull = pair;
                    this.this$0 = ekoUserBoundaryCallback;
                    this.$userId$inlined = string;
                }

                public final void accept(Disposable it) {
                    EkoUserBoundaryCallback.access$getUserIdAndTokenMap$p(this.this$0).put(this.$userId$inlined, new Pair(this.$tokenAndStatusNonNull.first, (Object)true));
                }
            }).doOnError((Consumer)new Consumer<Throwable>(tokenAndStatusNonNull, this, userId){
                final /* synthetic */ Pair $tokenAndStatusNonNull;
                final /* synthetic */ EkoUserBoundaryCallback this$0;
                final /* synthetic */ String $userId$inlined;
                {
                    this.$tokenAndStatusNonNull = pair;
                    this.this$0 = ekoUserBoundaryCallback;
                    this.$userId$inlined = string;
                }

                public final void accept(Throwable it) {
                    EkoUserBoundaryCallback.access$getUserIdAndTokenMap$p(this.this$0).put(this.$userId$inlined, new Pair(this.$tokenAndStatusNonNull.first, (Object)false));
                }
            }).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
        }
    }

    private final Completable call(UserQueryRequest.UserQueryOptions options) {
        UserQueryRequest request = new UserQueryRequest(PropertyUtilsKt.requiredNotEmpty(this.keyword), this.sortOption.getApiKey(), options);
        Completable completable = EkoSocket.call(Call.create(request, new UserQueryConverter())).doOnSuccess((Consumer)new Consumer<EkoUserListDto>(this){
            final /* synthetic */ EkoUserBoundaryCallback this$0;

            public final void accept(@NotNull EkoUserListDto dto) {
                Intrinsics.checkParameterIsNotNull((Object)dto, (String)"dto");
                List<EkoUserDto> users = dto.getUsers();
                if (!CollectionUtils.isEmpty((Collection)users)) {
                    EkoUserDto user = users.get(users.size() - 1);
                    Map map = EkoUserBoundaryCallback.access$getUserIdAndTokenMap$p(this.this$0);
                    EkoUserDto ekoUserDto = user;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ekoUserDto, (String)"user");
                    String string = ekoUserDto.getUserId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.userId");
                    EkoUserQueryToken ekoUserQueryToken = dto.getToken();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ekoUserQueryToken, (String)"dto.token");
                    Pair pair = Pair.create((Object)ekoUserQueryToken.getNext(), (Object)false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(dto.token.next, false)");
                    map.put(string, pair);
                    if (EkoUserBoundaryCallback.access$getUserIdSet$p(this.this$0).contains(user.getUserId())) {
                        String string2 = user.getUserId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"user.userId");
                        EkoUserBoundaryCallback.access$mapByUser(this.this$0, string2);
                    }
                }
            }
            {
                this.this$0 = ekoUserBoundaryCallback;
            }
        }).retryWhen(RetryWhen.maxRetries((int)3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).action((Consumer)new Consumer<RetryWhen.ErrorAndDuration>(this){
            final /* synthetic */ EkoUserBoundaryCallback this$0;

            public final void accept(@NotNull RetryWhen.ErrorAndDuration errorAndDuration) {
                Intrinsics.checkParameterIsNotNull((Object)errorAndDuration, (String)"errorAndDuration");
                Timber.tag((String)((Object)((Object)this.this$0)).getClass().getName()).e(errorAndDuration.throwable(), "an error occurred, back-off for durationMs:%s", new Object[]{errorAndDuration.durationMs()});
            }
            {
                this.this$0 = ekoUserBoundaryCallback;
            }
        }).build()).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public EkoUserBoundaryCallback(@NotNull String keyword, @NotNull AmityUserSortOption sortOption, int pageSize, @NotNull Subject<Boolean> delaySubject) {
        Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkParameterIsNotNull(delaySubject, (String)"delaySubject");
        this.keyword = keyword;
        this.sortOption = sortOption;
        this.pageSize = pageSize;
        this.delaySubject = delaySubject;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"Maps.newConcurrentMap()");
        this.userIdAndTokenMap = concurrentMap;
        this.userIdSet = Sets.newConcurrentHashSet();
        this.onFirstLoaded();
    }

    static {
        Companion = new Companion(null);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        SINGLE_THREAD_EXECUTOR = executorService;
    }

    public static final /* synthetic */ Subject access$getDelaySubject$p(EkoUserBoundaryCallback $this) {
        return $this.delaySubject;
    }

    public static final /* synthetic */ Map access$getUserIdAndTokenMap$p(EkoUserBoundaryCallback $this) {
        return $this.userIdAndTokenMap;
    }

    public static final /* synthetic */ Set access$getUserIdSet$p(EkoUserBoundaryCallback $this) {
        return $this.userIdSet;
    }

    public static final /* synthetic */ void access$mapByUser(EkoUserBoundaryCallback $this, String userId) {
        $this.mapByUser(userId);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoUserBoundaryCallback$Companion;", "", "()V", "SINGLE_THREAD_EXECUTOR", "Ljava/util/concurrent/Executor;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

