/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.log;

import android.util.Log;
import com.amity.socialcloud.sdk.log.AmityLogProvider;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006J+\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000eJ7\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J-\u0010\u0012\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000eJ7\u0010\u0012\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J-\u0010\u0013\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000eJ7\u0010\u0013\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J-\u0010\u0014\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000eJ7\u0010\u0014\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0014\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J-\u0010\u0015\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000eJ7\u0010\u0015\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0015\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010JA\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\r\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0019J,\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/amity/socialcloud/sdk/log/AmityLog;", "", "<init>", "()V", "explicitTag", "Ljava/lang/ThreadLocal;", "", "getTag", "tag", "v", "", "message", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "t", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "d", "i", "w", "e", "prepareLog", "priority", "", "(ILjava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "log", "isLoggable", "", "getStackTraceString", "amity-log_release"})
public final class AmityLog {
    @NotNull
    public static final AmityLog INSTANCE = new AmityLog();
    @NotNull
    private static final ThreadLocal<String> explicitTag = new ThreadLocal();

    private AmityLog() {
    }

    private final String getTag() {
        String tag = explicitTag.get();
        if (tag != null) {
            explicitTag.remove();
        }
        return tag;
    }

    @NotNull
    public final AmityLog tag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        explicitTag.set(tag);
        return this;
    }

    public final void v(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.v(null, message, Arrays.copyOf(args, args.length));
    }

    public final void v(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.prepareLog(2, t, message, Arrays.copyOf(args, args.length));
    }

    public final void v(@Nullable Throwable t) {
        this.v(t, null, new Object[0]);
    }

    public final void d(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.d(null, message, Arrays.copyOf(args, args.length));
    }

    public final void d(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.prepareLog(3, t, message, Arrays.copyOf(args, args.length));
    }

    public final void d(@Nullable Throwable t) {
        this.d(t, null, new Object[0]);
    }

    public final void i(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.i(null, message, Arrays.copyOf(args, args.length));
    }

    public final void i(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.prepareLog(4, t, message, Arrays.copyOf(args, args.length));
    }

    public final void i(@Nullable Throwable t) {
        this.i(t, null, new Object[0]);
    }

    public final void w(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.w(null, message, Arrays.copyOf(args, args.length));
    }

    public final void w(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.prepareLog(5, t, message, Arrays.copyOf(args, args.length));
    }

    public final void w(@Nullable Throwable t) {
        this.w(t, null, new Object[0]);
    }

    public final void e(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.e(null, message, Arrays.copyOf(args, args.length));
    }

    public final void e(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.prepareLog(6, t, message, Arrays.copyOf(args, args.length));
    }

    public final void e(@Nullable Throwable t) {
        this.e(t, null, new Object[0]);
    }

    private final void prepareLog(int priority, Throwable t, String message, Object ... args) {
        Object message2;
        String tag = this.getTag();
        Object object = message;
        if (object == null) {
            object = message2 = "";
        }
        if (!this.isLoggable()) {
            return;
        }
        if (((CharSequence)message2).length() == 0) {
            if (t == null) {
                return;
            }
            message2 = this.getStackTraceString(t);
        } else {
            if (!(args.length == 0)) {
                Object[] objectArray = Arrays.copyOf(args, args.length);
                String string = String.format((String)message2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                message2 = string;
            }
            if (t != null) {
                message2 = (String)message2 + StringsKt.trimIndent((String)("\n\t        \t\n\t        \t" + this.getStackTraceString(t) + "\n\t        \t"));
            }
        }
        this.log(priority, tag, (String)message2, t);
    }

    private final void log(int priority, String tag, String message, Throwable t) {
        switch (priority) {
            case 2: {
                Log.v((String)tag, (String)message, (Throwable)t);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)message, (Throwable)t);
                break;
            }
            case 3: {
                Log.d((String)tag, (String)message, (Throwable)t);
                break;
            }
            case 5: {
                Log.w((String)tag, (String)message, (Throwable)t);
                break;
            }
            case 6: {
                Log.e((String)tag, (String)message, (Throwable)t);
            }
        }
    }

    private final boolean isLoggable() {
        return !AmityLogProvider.Companion.isHiddenAmityLog();
    }

    private final String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

