package com.amity.socialcloud.sdk.log

import android.content.ContentProvider
import android.content.ContentValues
import android.database.Cursor
import android.net.Uri
import java.util.concurrent.atomic.AtomicBoolean

class AmityLogProvider : ContentProvider() {
	override fun onCreate(): Boolean {
		val isHiddenAmityLog = context?.applicationContext?.resources?.getBoolean(R.bool.IS_HIDDEN_AMITY_LOG) ?: DEFAULT_IS_HIDDEN
		isHidden.set(isHiddenAmityLog)
		return true
	}
	
	override fun query(uri: Uri, projection: Array<String>?, selection: String?, selectionArgs: Array<String>?, sortOrder: String?): Cursor? {
		return null
	}
	
	override fun getType(uri: Uri): String? {
		return null
	}
	
	override fun insert(uri: Uri, values: ContentValues?): Uri? {
		return null
	}
	
	override fun delete(uri: Uri, selection: String?, selectionArgs: Array<String>?): Int {
		return 0
	}
	
	override fun update(uri: Uri, values: ContentValues?, selection: String?, selectionArgs: Array<String>?): Int {
		return 0
	}
	
	companion object {
		private const val DEFAULT_IS_HIDDEN = true
		private val isHidden = AtomicBoolean(DEFAULT_IS_HIDDEN)
		fun isHiddenAmityLog(): Boolean {
			return isHidden.get()
		}
	}
}