/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import com.almasb.gameutils.math.Vec2;
import org.jbox2d.callbacks.ContactFilter;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.callbacks.DestructionListener;
import org.jbox2d.callbacks.ParticleDestructionListener;
import org.jbox2d.callbacks.ParticleQueryCallback;
import org.jbox2d.callbacks.ParticleRaycastCallback;
import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.callbacks.RayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.TimeOfImpact;
import org.jbox2d.collision.broadphase.BroadPhase;
import org.jbox2d.collision.broadphase.BroadPhaseStrategy;
import org.jbox2d.collision.broadphase.DefaultBroadPhaseBuffer;
import org.jbox2d.collision.broadphase.DynamicTree;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.JBoxSettings;
import org.jbox2d.common.JBoxUtils;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Timer;
import org.jbox2d.common.Transform;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.ContactManager;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.Island;
import org.jbox2d.dynamics.Profile;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.WorldQueryWrapper;
import org.jbox2d.dynamics.WorldRayCastWrapper;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.contacts.ContactRegister;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointEdge;
import org.jbox2d.particle.ParticleBodyContact;
import org.jbox2d.particle.ParticleColor;
import org.jbox2d.particle.ParticleContact;
import org.jbox2d.particle.ParticleDef;
import org.jbox2d.particle.ParticleGroup;
import org.jbox2d.particle.ParticleGroupDef;
import org.jbox2d.particle.ParticleSystem;
import org.jbox2d.pooling.IDynamicStack;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.normal.DefaultWorldPool;

public class World {
    private static final int WORLD_POOL_SIZE = 100;
    private static final int WORLD_POOL_CONTAINER_SIZE = 10;
    private boolean newFixture = false;
    private boolean locked = false;
    private boolean autoClearForces = true;
    protected ContactManager m_contactManager;
    private Body m_bodyList = null;
    private Joint m_jointList = null;
    private int bodyCount = 0;
    private int jointCount = 0;
    private final Vec2 m_gravity = new Vec2();
    private boolean allowSleep = true;
    private DestructionListener destructionListener = null;
    private ParticleDestructionListener particleDestructionListener = null;
    private final IWorldPool pool;
    private float dtInverse = 0.0f;
    private boolean warmStarting = true;
    private boolean continuousPhysics = true;
    private boolean subStepping = false;
    private boolean stepComplete = true;
    private Profile profile = new Profile();
    private final ParticleSystem particleSystem;
    private ContactRegister[][] contactStacks = new ContactRegister[ShapeType.values().length][ShapeType.values().length];
    private final TimeStep step = new TimeStep();
    private final Timer stepTimer = new Timer();
    private final Timer tempTimer = new Timer();
    private final WorldQueryWrapper wqwrapper = new WorldQueryWrapper();
    private final WorldRayCastWrapper wrcwrapper = new WorldRayCastWrapper();
    private final RayCastInput input = new RayCastInput();
    private final Island island = new Island();
    private Body[] stack = new Body[10];
    private final Timer broadphaseTimer = new Timer();
    private final Island toiIsland = new Island();
    private final TimeOfImpact.TOIInput toiInput = new TimeOfImpact.TOIInput();
    private final TimeOfImpact.TOIOutput toiOutput = new TimeOfImpact.TOIOutput();
    private final TimeStep subStep = new TimeStep();
    private final Body[] tempBodies = new Body[2];
    private final Sweep backup1 = new Sweep();
    private final Sweep backup2 = new Sweep();

    void notifyNewFixture() {
        this.newFixture = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    void assertNotLocked() {
        if (this.isLocked()) {
            throw new IllegalStateException("Physics world is locked during time step");
        }
    }

    public void setAutoClearForces(boolean flag) {
        this.autoClearForces = flag;
    }

    public boolean getAutoClearForces() {
        return this.autoClearForces;
    }

    public boolean isAllowSleep() {
        return this.allowSleep;
    }

    public void setAllowSleep(boolean flag) {
        if (flag == this.allowSleep) {
            return;
        }
        this.allowSleep = flag;
        if (!this.allowSleep) {
            Body b = this.m_bodyList;
            while (b != null) {
                b.setAwake(true);
                b = b.m_next;
            }
        }
    }

    public DestructionListener getDestructionListener() {
        return this.destructionListener;
    }

    public void setDestructionListener(DestructionListener listener) {
        this.destructionListener = listener;
    }

    public ParticleDestructionListener getParticleDestructionListener() {
        return this.particleDestructionListener;
    }

    public void setParticleDestructionListener(ParticleDestructionListener listener) {
        this.particleDestructionListener = listener;
    }

    public IWorldPool getPool() {
        return this.pool;
    }

    public void setSubStepping(boolean subStepping) {
        this.subStepping = subStepping;
    }

    public boolean isSubStepping() {
        return this.subStepping;
    }

    public ParticleSystem getParticleSystem() {
        return this.particleSystem;
    }

    public World(Vec2 gravity) {
        this(gravity, new DefaultWorldPool(100, 10));
    }

    public World(Vec2 gravity, IWorldPool pool) {
        this(gravity, pool, new DynamicTree());
    }

    public World(Vec2 gravity, IWorldPool pool, BroadPhaseStrategy strategy) {
        this(gravity, pool, new DefaultBroadPhaseBuffer(strategy));
    }

    public World(Vec2 gravity, IWorldPool pool, BroadPhase broadPhase) {
        this.pool = pool;
        this.m_gravity.set(gravity);
        this.m_contactManager = new ContactManager(this, broadPhase);
        this.particleSystem = new ParticleSystem(this);
        this.initializeRegisters();
    }

    private void addType(IDynamicStack<Contact> creator, ShapeType type1, ShapeType type2) {
        ContactRegister register = new ContactRegister();
        register.creator = creator;
        register.primary = true;
        this.contactStacks[type1.ordinal()][type2.ordinal()] = register;
        if (type1 != type2) {
            ContactRegister register2 = new ContactRegister();
            register2.creator = creator;
            register2.primary = false;
            this.contactStacks[type2.ordinal()][type1.ordinal()] = register2;
        }
    }

    private void initializeRegisters() {
        this.addType(this.pool.getCircleContactStack(), ShapeType.CIRCLE, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyCircleContactStack(), ShapeType.POLYGON, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyContactStack(), ShapeType.POLYGON, ShapeType.POLYGON);
        this.addType(this.pool.getEdgeCircleContactStack(), ShapeType.EDGE, ShapeType.CIRCLE);
        this.addType(this.pool.getEdgePolyContactStack(), ShapeType.EDGE, ShapeType.POLYGON);
        this.addType(this.pool.getChainCircleContactStack(), ShapeType.CHAIN, ShapeType.CIRCLE);
        this.addType(this.pool.getChainPolyContactStack(), ShapeType.CHAIN, ShapeType.POLYGON);
    }

    public Contact popContact(Fixture fixtureA, int indexA, Fixture fixtureB, int indexB) {
        ShapeType type1 = fixtureA.getType();
        ShapeType type2 = fixtureB.getType();
        ContactRegister reg = this.contactStacks[type1.ordinal()][type2.ordinal()];
        if (reg != null) {
            if (reg.primary) {
                Contact c = reg.creator.pop();
                c.init(fixtureA, indexA, fixtureB, indexB);
                return c;
            }
            Contact c = reg.creator.pop();
            c.init(fixtureB, indexB, fixtureA, indexA);
            return c;
        }
        return null;
    }

    public void pushContact(Contact contact) {
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        if (contact.m_manifold.pointCount > 0 && !fixtureA.isSensor() && !fixtureB.isSensor()) {
            fixtureA.getBody().setAwake(true);
            fixtureB.getBody().setAwake(true);
        }
        ShapeType type1 = fixtureA.getType();
        ShapeType type2 = fixtureB.getType();
        IDynamicStack<Contact> creator = this.contactStacks[type1.ordinal()][type2.ordinal()].creator;
        creator.push(contact);
    }

    public void setContactFilter(ContactFilter filter) {
        this.m_contactManager.m_contactFilter = filter;
    }

    public void setContactListener(ContactListener listener) {
        this.m_contactManager.m_contactListener = listener;
    }

    public Body createBody(BodyDef def) {
        this.assertNotLocked();
        Body b = new Body(def, this);
        b.m_prev = null;
        b.m_next = this.m_bodyList;
        if (this.m_bodyList != null) {
            this.m_bodyList.m_prev = b;
        }
        this.m_bodyList = b;
        ++this.bodyCount;
        return b;
    }

    public void destroyBody(Body body) {
        assert (this.bodyCount > 0);
        this.assertNotLocked();
        JointEdge je = body.m_jointList;
        while (je != null) {
            JointEdge je0 = je;
            je = je.next;
            if (this.destructionListener != null) {
                this.destructionListener.onDestroy(je0.joint);
            }
            this.destroyJoint(je0.joint);
            body.m_jointList = je;
        }
        body.m_jointList = null;
        ContactEdge ce = body.m_contactList;
        while (ce != null) {
            ContactEdge ce0 = ce;
            ce = ce.next;
            this.m_contactManager.destroy(ce0.contact);
        }
        body.m_contactList = null;
        for (Fixture f : body.getFixtures()) {
            if (this.destructionListener != null) {
                this.destructionListener.onDestroy(f);
            }
            f.destroyProxies(this.m_contactManager.m_broadPhase);
            f.destroy();
        }
        body.getFixtures().clear();
        if (body.m_prev != null) {
            body.m_prev.m_next = body.m_next;
        }
        if (body.m_next != null) {
            body.m_next.m_prev = body.m_prev;
        }
        if (body == this.m_bodyList) {
            this.m_bodyList = body.m_next;
        }
        --this.bodyCount;
    }

    public Joint createJoint(JointDef def) {
        this.assertNotLocked();
        Joint j = Joint.create(this, def);
        j.m_prev = null;
        j.m_next = this.m_jointList;
        if (this.m_jointList != null) {
            this.m_jointList.m_prev = j;
        }
        this.m_jointList = j;
        ++this.jointCount;
        j.m_edgeA.joint = j;
        j.m_edgeA.other = j.getBodyB();
        j.m_edgeA.prev = null;
        j.m_edgeA.next = j.getBodyA().m_jointList;
        if (j.getBodyA().m_jointList != null) {
            j.getBodyA().m_jointList.prev = j.m_edgeA;
        }
        j.getBodyA().m_jointList = j.m_edgeA;
        j.m_edgeB.joint = j;
        j.m_edgeB.other = j.getBodyA();
        j.m_edgeB.prev = null;
        j.m_edgeB.next = j.getBodyB().m_jointList;
        if (j.getBodyB().m_jointList != null) {
            j.getBodyB().m_jointList.prev = j.m_edgeB;
        }
        j.getBodyB().m_jointList = j.m_edgeB;
        Body bodyA = def.bodyA;
        Body bodyB = def.bodyB;
        if (!def.collideConnected) {
            ContactEdge edge = bodyB.getContactList();
            while (edge != null) {
                if (edge.other == bodyA) {
                    edge.contact.flagForFiltering();
                }
                edge = edge.next;
            }
        }
        return j;
    }

    public void destroyJoint(Joint j) {
        this.assertNotLocked();
        boolean collideConnected = j.getCollideConnected();
        if (j.m_prev != null) {
            j.m_prev.m_next = j.m_next;
        }
        if (j.m_next != null) {
            j.m_next.m_prev = j.m_prev;
        }
        if (j == this.m_jointList) {
            this.m_jointList = j.m_next;
        }
        Body bodyA = j.getBodyA();
        Body bodyB = j.getBodyB();
        bodyA.setAwake(true);
        bodyB.setAwake(true);
        if (j.m_edgeA.prev != null) {
            j.m_edgeA.prev.next = j.m_edgeA.next;
        }
        if (j.m_edgeA.next != null) {
            j.m_edgeA.next.prev = j.m_edgeA.prev;
        }
        if (j.m_edgeA == bodyA.m_jointList) {
            bodyA.m_jointList = j.m_edgeA.next;
        }
        j.m_edgeA.prev = null;
        j.m_edgeA.next = null;
        if (j.m_edgeB.prev != null) {
            j.m_edgeB.prev.next = j.m_edgeB.next;
        }
        if (j.m_edgeB.next != null) {
            j.m_edgeB.next.prev = j.m_edgeB.prev;
        }
        if (j.m_edgeB == bodyB.m_jointList) {
            bodyB.m_jointList = j.m_edgeB.next;
        }
        j.m_edgeB.prev = null;
        j.m_edgeB.next = null;
        Joint.destroy(j);
        assert (this.jointCount > 0);
        --this.jointCount;
        if (!collideConnected) {
            ContactEdge edge = bodyB.getContactList();
            while (edge != null) {
                if (edge.other == bodyA) {
                    edge.contact.flagForFiltering();
                }
                edge = edge.next;
            }
        }
    }

    public void step(float dt, int velocityIterations, int positionIterations) {
        this.stepTimer.reset();
        this.tempTimer.reset();
        if (this.newFixture) {
            this.m_contactManager.findNewContacts();
            this.newFixture = false;
        }
        this.locked = true;
        this.step.dt = dt;
        this.step.velocityIterations = velocityIterations;
        this.step.positionIterations = positionIterations;
        this.step.inv_dt = dt > 0.0f ? 1.0f / dt : 0.0f;
        this.step.dtRatio = this.dtInverse * dt;
        this.step.warmStarting = this.warmStarting;
        this.profile.stepInit.record(this.tempTimer.getMilliseconds());
        this.tempTimer.reset();
        this.m_contactManager.collide();
        this.profile.collide.record(this.tempTimer.getMilliseconds());
        if (this.stepComplete && this.step.dt > 0.0f) {
            this.tempTimer.reset();
            this.particleSystem.solve(this.step);
            this.profile.solveParticleSystem.record(this.tempTimer.getMilliseconds());
            this.tempTimer.reset();
            this.solve(this.step);
            this.profile.solve.record(this.tempTimer.getMilliseconds());
        }
        if (this.continuousPhysics && this.step.dt > 0.0f) {
            this.tempTimer.reset();
            this.solveTOI(this.step);
            this.profile.solveTOI.record(this.tempTimer.getMilliseconds());
        }
        if (this.step.dt > 0.0f) {
            this.dtInverse = this.step.inv_dt;
        }
        if (this.getAutoClearForces()) {
            this.clearForces();
        }
        this.locked = false;
        this.profile.step.record(this.stepTimer.getMilliseconds());
    }

    public void clearForces() {
        for (Body body = this.m_bodyList; body != null; body = body.getNext()) {
            body.m_force.setZero();
            body.m_torque = 0.0f;
        }
    }

    public void queryAABB(QueryCallback callback, AABB aabb) {
        this.wqwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wqwrapper.callback = callback;
        this.m_contactManager.m_broadPhase.query(this.wqwrapper, aabb);
    }

    public void queryAABB(QueryCallback callback, ParticleQueryCallback particleCallback, AABB aabb) {
        this.wqwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wqwrapper.callback = callback;
        this.m_contactManager.m_broadPhase.query(this.wqwrapper, aabb);
        this.particleSystem.queryAABB(particleCallback, aabb);
    }

    public void queryAABB(ParticleQueryCallback particleCallback, AABB aabb) {
        this.particleSystem.queryAABB(particleCallback, aabb);
    }

    public void raycast(RayCastCallback callback, Vec2 point1, Vec2 point2) {
        this.wrcwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wrcwrapper.callback = callback;
        this.input.maxFraction = 1.0f;
        this.input.p1.set(point1);
        this.input.p2.set(point2);
        this.m_contactManager.m_broadPhase.raycast(this.wrcwrapper, this.input);
    }

    public void raycast(RayCastCallback callback, ParticleRaycastCallback particleCallback, Vec2 point1, Vec2 point2) {
        this.wrcwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wrcwrapper.callback = callback;
        this.input.maxFraction = 1.0f;
        this.input.p1.set(point1);
        this.input.p2.set(point2);
        this.m_contactManager.m_broadPhase.raycast(this.wrcwrapper, this.input);
        this.particleSystem.raycast(particleCallback, point1, point2);
    }

    public void raycast(ParticleRaycastCallback particleCallback, Vec2 point1, Vec2 point2) {
        this.particleSystem.raycast(particleCallback, point1, point2);
    }

    public Body getBodyList() {
        return this.m_bodyList;
    }

    public Joint getJointList() {
        return this.m_jointList;
    }

    public Contact getContactList() {
        return this.m_contactManager.m_contactList;
    }

    public boolean isSleepingAllowed() {
        return this.allowSleep;
    }

    public void setSleepingAllowed(boolean sleepingAllowed) {
        this.allowSleep = sleepingAllowed;
    }

    public void setWarmStarting(boolean flag) {
        this.warmStarting = flag;
    }

    public boolean isWarmStarting() {
        return this.warmStarting;
    }

    public void setContinuousPhysics(boolean flag) {
        this.continuousPhysics = flag;
    }

    public boolean isContinuousPhysics() {
        return this.continuousPhysics;
    }

    public int getProxyCount() {
        return this.m_contactManager.m_broadPhase.getProxyCount();
    }

    public int getBodyCount() {
        return this.bodyCount;
    }

    public int getJointCount() {
        return this.jointCount;
    }

    public int getContactCount() {
        return this.m_contactManager.m_contactCount;
    }

    public int getTreeHeight() {
        return this.m_contactManager.m_broadPhase.getTreeHeight();
    }

    public int getTreeBalance() {
        return this.m_contactManager.m_broadPhase.getTreeBalance();
    }

    public float getTreeQuality() {
        return this.m_contactManager.m_broadPhase.getTreeQuality();
    }

    public void setGravity(Vec2 gravity) {
        this.m_gravity.set(gravity);
    }

    public Vec2 getGravity() {
        return this.m_gravity;
    }

    public ContactManager getContactManager() {
        return this.m_contactManager;
    }

    public Profile getProfile() {
        return this.profile;
    }

    private void solve(TimeStep step) {
        this.profile.solveInit.startAccum();
        this.profile.solveVelocity.startAccum();
        this.profile.solvePosition.startAccum();
        Body b = this.m_bodyList;
        while (b != null) {
            b.m_xf0.set(b.m_xf);
            b = b.m_next;
        }
        this.island.init(this.bodyCount, this.m_contactManager.m_contactCount, this.jointCount, this.m_contactManager.m_contactListener);
        b = this.m_bodyList;
        while (b != null) {
            b.m_flags &= 0xFFFFFFFE;
            b = b.m_next;
        }
        Contact c = this.m_contactManager.m_contactList;
        while (c != null) {
            c.m_flags &= 0xFFFFFFFE;
            c = c.m_next;
        }
        Joint j = this.m_jointList;
        while (j != null) {
            j.m_islandFlag = false;
            j = j.m_next;
        }
        int stackSize = this.bodyCount;
        if (this.stack.length < stackSize) {
            this.stack = new Body[stackSize];
        }
        Body seed = this.m_bodyList;
        while (seed != null) {
            if ((seed.m_flags & 1) != 1 && seed.isAwake() && seed.isActive() && seed.getType() != BodyType.STATIC) {
                this.island.clear();
                int stackCount = 0;
                this.stack[stackCount++] = seed;
                seed.m_flags |= 1;
                while (stackCount > 0) {
                    Body b2 = this.stack[--stackCount];
                    assert (b2.isActive());
                    this.island.add(b2);
                    b2.setAwake(true);
                    if (b2.getType() == BodyType.STATIC) continue;
                    ContactEdge ce = b2.m_contactList;
                    while (ce != null) {
                        Contact contact = ce.contact;
                        if ((contact.m_flags & 1) != 1 && contact.isEnabled() && contact.isTouching()) {
                            boolean sensorA = contact.m_fixtureA.isSensor();
                            boolean sensorB = contact.m_fixtureB.isSensor();
                            if (!sensorA && !sensorB) {
                                this.island.add(contact);
                                contact.m_flags |= 1;
                                Body other = ce.other;
                                if ((other.m_flags & 1) != 1) {
                                    assert (stackCount < stackSize);
                                    this.stack[stackCount++] = other;
                                    other.m_flags |= 1;
                                }
                            }
                        }
                        ce = ce.next;
                    }
                    JointEdge je = b2.m_jointList;
                    while (je != null) {
                        Body other;
                        if (!je.joint.m_islandFlag && (other = je.other).isActive()) {
                            this.island.add(je.joint);
                            je.joint.m_islandFlag = true;
                            if ((other.m_flags & 1) != 1) {
                                assert (stackCount < stackSize);
                                this.stack[stackCount++] = other;
                                other.m_flags |= 1;
                            }
                        }
                        je = je.next;
                    }
                }
                this.island.solve(this.profile, step, this.m_gravity, this.allowSleep);
                for (int i = 0; i < this.island.m_bodyCount; ++i) {
                    Body b3 = this.island.m_bodies[i];
                    if (b3.getType() != BodyType.STATIC) continue;
                    b3.m_flags &= 0xFFFFFFFE;
                }
            }
            seed = seed.m_next;
        }
        this.profile.solveInit.endAccum();
        this.profile.solveVelocity.endAccum();
        this.profile.solvePosition.endAccum();
        this.broadphaseTimer.reset();
        for (Body b4 = this.m_bodyList; b4 != null; b4 = b4.getNext()) {
            if ((b4.m_flags & 1) == 0 || b4.getType() == BodyType.STATIC) continue;
            b4.synchronizeFixtures();
        }
        this.m_contactManager.findNewContacts();
        this.profile.broadphase.record(this.broadphaseTimer.getMilliseconds());
    }

    private void solveTOI(TimeStep step) {
        block30: {
            Island island = this.toiIsland;
            island.init(2 * JBoxSettings.maxTOIContacts, JBoxSettings.maxTOIContacts, 0, this.m_contactManager.m_contactListener);
            if (this.stepComplete) {
                Body b = this.m_bodyList;
                while (b != null) {
                    b.m_flags &= 0xFFFFFFFE;
                    b.m_sweep.alpha0 = 0.0f;
                    b = b.m_next;
                }
                Contact c = this.m_contactManager.m_contactList;
                while (c != null) {
                    c.m_flags &= 0xFFFFFFDE;
                    c.m_toiCount = 0.0f;
                    c.m_toi = 1.0f;
                    c = c.m_next;
                }
            }
            while (true) {
                ContactEdge ce;
                Body body;
                int i;
                Contact minContact = null;
                float minAlpha = 1.0f;
                Contact c = this.m_contactManager.m_contactList;
                while (c != null) {
                    block31: {
                        float alpha;
                        block33: {
                            boolean collideB;
                            boolean activeB;
                            block32: {
                                if (!c.isEnabled() || c.m_toiCount > (float)JBoxSettings.maxSubSteps) break block31;
                                alpha = 1.0f;
                                if ((c.m_flags & 0x20) == 0) break block32;
                                alpha = c.m_toi;
                                break block33;
                            }
                            Fixture fA = c.getFixtureA();
                            Fixture fB = c.getFixtureB();
                            if (fA.isSensor() || fB.isSensor()) break block31;
                            Body bA = fA.getBody();
                            Body bB = fB.getBody();
                            BodyType typeA = bA.getType();
                            BodyType typeB = bB.getType();
                            assert (typeA == BodyType.DYNAMIC || typeB == BodyType.DYNAMIC);
                            boolean activeA = bA.isAwake() && typeA != BodyType.STATIC;
                            boolean bl = activeB = bB.isAwake() && typeB != BodyType.STATIC;
                            if (!activeA && !activeB) break block31;
                            boolean collideA = bA.isBullet() || typeA != BodyType.DYNAMIC;
                            boolean bl2 = collideB = bB.isBullet() || typeB != BodyType.DYNAMIC;
                            if (!collideA && !collideB) break block31;
                            float alpha0 = bA.m_sweep.alpha0;
                            if (bA.m_sweep.alpha0 < bB.m_sweep.alpha0) {
                                alpha0 = bB.m_sweep.alpha0;
                                bA.m_sweep.advance(alpha0);
                            } else if (bB.m_sweep.alpha0 < bA.m_sweep.alpha0) {
                                alpha0 = bA.m_sweep.alpha0;
                                bB.m_sweep.advance(alpha0);
                            }
                            assert (alpha0 < 1.0f);
                            int indexA = c.getChildIndexA();
                            int indexB = c.getChildIndexB();
                            TimeOfImpact.TOIInput input = this.toiInput;
                            input.proxyA.set(fA.getShape(), indexA);
                            input.proxyB.set(fB.getShape(), indexB);
                            input.sweepA.set(bA.m_sweep);
                            input.sweepB.set(bB.m_sweep);
                            input.tMax = 1.0f;
                            this.pool.getTimeOfImpact().timeOfImpact(this.toiOutput, input);
                            float beta = this.toiOutput.t;
                            alpha = this.toiOutput.state == TimeOfImpact.TOIOutputState.TOUCHING ? JBoxUtils.min(alpha0 + (1.0f - alpha0) * beta, 1.0f) : 1.0f;
                            c.m_toi = alpha;
                            c.m_flags |= 0x20;
                        }
                        if (alpha < minAlpha) {
                            minContact = c;
                            minAlpha = alpha;
                        }
                    }
                    c = c.m_next;
                }
                if (minContact == null || 0.9999988f < minAlpha) {
                    this.stepComplete = true;
                    break block30;
                }
                Fixture fA = minContact.getFixtureA();
                Fixture fB = minContact.getFixtureB();
                Body bA = fA.getBody();
                Body bB = fB.getBody();
                this.backup1.set(bA.m_sweep);
                this.backup2.set(bB.m_sweep);
                bA.advance(minAlpha);
                bB.advance(minAlpha);
                minContact.update(this.m_contactManager.m_contactListener);
                minContact.m_flags &= 0xFFFFFFDF;
                minContact.m_toiCount += 1.0f;
                if (!minContact.isEnabled() || !minContact.isTouching()) {
                    minContact.setEnabled(false);
                    bA.m_sweep.set(this.backup1);
                    bB.m_sweep.set(this.backup2);
                    bA.synchronizeTransform();
                    bB.synchronizeTransform();
                    continue;
                }
                bA.setAwake(true);
                bB.setAwake(true);
                island.clear();
                island.add(bA);
                island.add(bB);
                island.add(minContact);
                bA.m_flags |= 1;
                bB.m_flags |= 1;
                minContact.m_flags |= 1;
                this.tempBodies[0] = bA;
                this.tempBodies[1] = bB;
                for (i = 0; i < 2; ++i) {
                    body = this.tempBodies[i];
                    if (body.getType() != BodyType.DYNAMIC) continue;
                    ce = body.m_contactList;
                    while (ce != null && island.m_bodyCount != island.m_bodyCapacity && island.m_contactCount != island.m_contactCapacity) {
                        Body other;
                        Contact contact = ce.contact;
                        if ((contact.m_flags & 1) == 0 && ((other = ce.other).getType() != BodyType.DYNAMIC || body.isBullet() || other.isBullet())) {
                            boolean sensorA = contact.m_fixtureA.isSensor();
                            boolean sensorB = contact.m_fixtureB.isSensor();
                            if (!sensorA && !sensorB) {
                                this.backup1.set(other.m_sweep);
                                if ((other.m_flags & 1) == 0) {
                                    other.advance(minAlpha);
                                }
                                contact.update(this.m_contactManager.m_contactListener);
                                if (!contact.isEnabled()) {
                                    other.m_sweep.set(this.backup1);
                                    other.synchronizeTransform();
                                } else if (!contact.isTouching()) {
                                    other.m_sweep.set(this.backup1);
                                    other.synchronizeTransform();
                                } else {
                                    contact.m_flags |= 1;
                                    island.add(contact);
                                    if ((other.m_flags & 1) == 0) {
                                        other.m_flags |= 1;
                                        if (other.getType() != BodyType.STATIC) {
                                            other.setAwake(true);
                                        }
                                        island.add(other);
                                    }
                                }
                            }
                        }
                        ce = ce.next;
                    }
                }
                this.subStep.dt = (1.0f - minAlpha) * step.dt;
                this.subStep.inv_dt = 1.0f / this.subStep.dt;
                this.subStep.dtRatio = 1.0f;
                this.subStep.positionIterations = 20;
                this.subStep.velocityIterations = step.velocityIterations;
                this.subStep.warmStarting = false;
                island.solveTOI(this.subStep, bA.m_islandIndex, bB.m_islandIndex);
                for (i = 0; i < island.m_bodyCount; ++i) {
                    body = island.m_bodies[i];
                    body.m_flags &= 0xFFFFFFFE;
                    if (body.getType() != BodyType.DYNAMIC) continue;
                    body.synchronizeFixtures();
                    ce = body.m_contactList;
                    while (ce != null) {
                        ce.contact.m_flags &= 0xFFFFFFDE;
                        ce = ce.next;
                    }
                }
                this.m_contactManager.findNewContacts();
                if (this.subStepping) break;
            }
            this.stepComplete = false;
        }
    }

    public int createParticle(ParticleDef def) {
        this.assertNotLocked();
        return this.particleSystem.createParticle(def);
    }

    public void destroyParticle(int index) {
        this.destroyParticle(index, false);
    }

    public void destroyParticle(int index, boolean callDestructionListener) {
        this.particleSystem.destroyParticle(index, callDestructionListener);
    }

    public int destroyParticlesInShape(Shape shape, Transform xf) {
        return this.destroyParticlesInShape(shape, xf, false);
    }

    public int destroyParticlesInShape(Shape shape, Transform xf, boolean callDestructionListener) {
        this.assertNotLocked();
        return this.particleSystem.destroyParticlesInShape(shape, xf, callDestructionListener);
    }

    public ParticleGroup createParticleGroup(ParticleGroupDef def) {
        this.assertNotLocked();
        return this.particleSystem.createParticleGroup(def);
    }

    public void joinParticleGroups(ParticleGroup groupA, ParticleGroup groupB) {
        this.assertNotLocked();
        this.particleSystem.joinParticleGroups(groupA, groupB);
    }

    public void destroyParticlesInGroup(ParticleGroup group, boolean callDestructionListener) {
        this.assertNotLocked();
        this.particleSystem.destroyParticlesInGroup(group, callDestructionListener);
    }

    public void destroyParticlesInGroup(ParticleGroup group) {
        this.destroyParticlesInGroup(group, false);
    }

    public ParticleGroup[] getParticleGroupList() {
        return this.particleSystem.getParticleGroupList();
    }

    public int getParticleGroupCount() {
        return this.particleSystem.getParticleGroupCount();
    }

    public int getParticleCount() {
        return this.particleSystem.getParticleCount();
    }

    public int getParticleMaxCount() {
        return this.particleSystem.getParticleMaxCount();
    }

    public void setParticleMaxCount(int count) {
        this.particleSystem.setParticleMaxCount(count);
    }

    public void setParticleDensity(float density) {
        this.particleSystem.setParticleDensity(density);
    }

    public float getParticleDensity() {
        return this.particleSystem.getParticleDensity();
    }

    public void setParticleGravityScale(float gravityScale) {
        this.particleSystem.setParticleGravityScale(gravityScale);
    }

    public float getParticleGravityScale() {
        return this.particleSystem.getParticleGravityScale();
    }

    public void setParticleDamping(float damping) {
        this.particleSystem.setParticleDamping(damping);
    }

    public float getParticleDamping() {
        return this.particleSystem.getParticleDamping();
    }

    public void setParticleRadius(float radius) {
        this.particleSystem.setParticleRadius(radius);
    }

    public float getParticleRadius() {
        return this.particleSystem.getParticleRadius();
    }

    public int[] getParticleFlagsBuffer() {
        return this.particleSystem.getParticleFlagsBuffer();
    }

    public Vec2[] getParticlePositionBuffer() {
        return this.particleSystem.getParticlePositionBuffer();
    }

    public Vec2[] getParticleVelocityBuffer() {
        return this.particleSystem.getParticleVelocityBuffer();
    }

    public ParticleColor[] getParticleColorBuffer() {
        return this.particleSystem.getParticleColorBuffer();
    }

    public ParticleGroup[] getParticleGroupBuffer() {
        return this.particleSystem.getParticleGroupBuffer();
    }

    public Object[] getParticleUserDataBuffer() {
        return this.particleSystem.getParticleUserDataBuffer();
    }

    public void setParticleFlagsBuffer(int[] buffer, int capacity) {
        this.particleSystem.setParticleFlagsBuffer(buffer, capacity);
    }

    public void setParticlePositionBuffer(Vec2[] buffer, int capacity) {
        this.particleSystem.setParticlePositionBuffer(buffer, capacity);
    }

    public void setParticleVelocityBuffer(Vec2[] buffer, int capacity) {
        this.particleSystem.setParticleVelocityBuffer(buffer, capacity);
    }

    public void setParticleColorBuffer(ParticleColor[] buffer, int capacity) {
        this.particleSystem.setParticleColorBuffer(buffer, capacity);
    }

    public void setParticleUserDataBuffer(Object[] buffer, int capacity) {
        this.particleSystem.setParticleUserDataBuffer(buffer, capacity);
    }

    public ParticleContact[] getParticleContacts() {
        return this.particleSystem.m_contactBuffer;
    }

    public int getParticleContactCount() {
        return this.particleSystem.m_contactCount;
    }

    public ParticleBodyContact[] getParticleBodyContacts() {
        return this.particleSystem.m_bodyContactBuffer;
    }

    public int getParticleBodyContactCount() {
        return this.particleSystem.m_bodyContactCount;
    }

    public float computeParticleCollisionEnergy() {
        return this.particleSystem.computeParticleCollisionEnergy();
    }
}

