/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import com.almasb.gameutils.math.Vec2;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.broadphase.BroadPhase;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.JBoxUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Filter;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.FixtureProxy;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;

public class Fixture {
    private final Body body;
    private final Shape shape;
    private final Filter filter = new Filter();
    private Object userData = null;
    private float density = 0.0f;
    private float friction = 0.0f;
    private float restitution = 0.0f;
    private boolean isSensor = false;
    public FixtureProxy[] m_proxies;
    private int proxyCount = 0;
    private final AABB pool1 = new AABB();
    private final AABB pool2 = new AABB();
    private final Vec2 displacement = new Vec2();

    Fixture(Body body, FixtureDef def) {
        this.body = body;
        this.userData = def.getUserData();
        this.friction = def.getFriction();
        this.restitution = def.getRestitution();
        this.density = def.getDensity();
        this.isSensor = def.isSensor();
        this.filter.set(def.getFilter());
        this.shape = def.getShape().clone();
        int childCount = this.shape.getChildCount();
        this.m_proxies = new FixtureProxy[childCount];
        for (int i = 0; i < childCount; ++i) {
            this.m_proxies[i] = new FixtureProxy();
            this.m_proxies[i].fixture = null;
            this.m_proxies[i].proxyId = -1;
        }
        if (this.m_proxies.length < childCount) {
            FixtureProxy[] old = this.m_proxies;
            int newLen = JBoxUtils.max(old.length * 2, childCount);
            this.m_proxies = new FixtureProxy[newLen];
            System.arraycopy(old, 0, this.m_proxies, 0, old.length);
            for (int i = 0; i < newLen; ++i) {
                if (i >= old.length) {
                    this.m_proxies[i] = new FixtureProxy();
                }
                this.m_proxies[i].fixture = null;
                this.m_proxies[i].proxyId = -1;
            }
        }
        this.proxyCount = 0;
    }

    public ShapeType getType() {
        return this.shape.getType();
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isSensor() {
        return this.isSensor;
    }

    public void setSensor(boolean sensor) {
        if (sensor != this.isSensor) {
            this.body.setAwake(true);
            this.isSensor = sensor;
        }
    }

    public void setFilterData(Filter filter) {
        this.filter.set(filter);
        this.refilter();
    }

    public Filter getFilterData() {
        return this.filter;
    }

    public int getProxyCount() {
        return this.proxyCount;
    }

    public FixtureProxy[] getProxies() {
        return this.m_proxies;
    }

    public void refilter() {
        ContactEdge edge = this.body.getContactList();
        while (edge != null) {
            Contact contact = edge.contact;
            Fixture fixtureA = contact.getFixtureA();
            Fixture fixtureB = contact.getFixtureB();
            if (fixtureA == this || fixtureB == this) {
                contact.flagForFiltering();
            }
            edge = edge.next;
        }
        World world = this.body.getWorld();
        if (world == null) {
            return;
        }
        BroadPhase broadPhase = world.m_contactManager.m_broadPhase;
        for (int i = 0; i < this.proxyCount; ++i) {
            broadPhase.touchProxy(this.m_proxies[i].proxyId);
        }
    }

    public Body getBody() {
        return this.body;
    }

    public void setDensity(float density) {
        assert (density >= 0.0f);
        this.density = density;
    }

    public float getDensity() {
        return this.density;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public boolean containsPoint(Vec2 p) {
        return this.shape.testPoint(this.body.m_xf, p);
    }

    public boolean raycast(RayCastOutput output, RayCastInput input, int childIndex) {
        return this.shape.raycast(output, input, this.body.m_xf, childIndex);
    }

    public void getMassData(MassData massData) {
        this.shape.computeMass(massData, this.density);
    }

    public float getFriction() {
        return this.friction;
    }

    public void setFriction(float friction) {
        this.friction = friction;
    }

    public float getRestitution() {
        return this.restitution;
    }

    public void setRestitution(float restitution) {
        this.restitution = restitution;
    }

    public AABB getAABB(int childIndex) {
        assert (childIndex >= 0 && childIndex < this.proxyCount);
        return this.m_proxies[childIndex].aabb;
    }

    public float computeDistance(Vec2 p, int childIndex, Vec2 normalOut) {
        return this.shape.computeDistanceToOut(this.body.getTransform(), p, childIndex, normalOut);
    }

    void destroy() {
        assert (this.proxyCount == 0);
        this.m_proxies = null;
    }

    public void createProxies(BroadPhase broadPhase, Transform xf) {
        assert (this.proxyCount == 0);
        this.proxyCount = this.shape.getChildCount();
        int i = 0;
        while (i < this.proxyCount) {
            FixtureProxy proxy = this.m_proxies[i];
            this.shape.computeAABB(proxy.aabb, xf, i);
            proxy.proxyId = broadPhase.createProxy(proxy.aabb, proxy);
            proxy.fixture = this;
            proxy.childIndex = i++;
        }
    }

    void destroyProxies(BroadPhase broadPhase) {
        for (int i = 0; i < this.proxyCount; ++i) {
            FixtureProxy proxy = this.m_proxies[i];
            broadPhase.destroyProxy(proxy.proxyId);
            proxy.proxyId = -1;
        }
        this.proxyCount = 0;
    }

    void synchronize(BroadPhase broadPhase, Transform transform1, Transform transform2) {
        if (this.proxyCount == 0) {
            return;
        }
        for (int i = 0; i < this.proxyCount; ++i) {
            FixtureProxy proxy = this.m_proxies[i];
            AABB aabb1 = this.pool1;
            AABB aab = this.pool2;
            this.shape.computeAABB(aabb1, transform1, proxy.childIndex);
            this.shape.computeAABB(aab, transform2, proxy.childIndex);
            proxy.aabb.lowerBound.x = aabb1.lowerBound.x < aab.lowerBound.x ? aabb1.lowerBound.x : aab.lowerBound.x;
            proxy.aabb.lowerBound.y = aabb1.lowerBound.y < aab.lowerBound.y ? aabb1.lowerBound.y : aab.lowerBound.y;
            proxy.aabb.upperBound.x = aabb1.upperBound.x > aab.upperBound.x ? aabb1.upperBound.x : aab.upperBound.x;
            proxy.aabb.upperBound.y = aabb1.upperBound.y > aab.upperBound.y ? aabb1.upperBound.y : aab.upperBound.y;
            this.displacement.x = transform2.p.x - transform1.p.x;
            this.displacement.y = transform2.p.y - transform1.p.y;
            broadPhase.moveProxy(proxy.proxyId, proxy.aabb, this.displacement);
        }
    }
}

