/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import com.almasb.gameutils.math.Vec2;
import java.io.Serializable;
import org.jbox2d.common.JBoxUtils;

public class Rotation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public float s;
    public float c;

    public Rotation() {
        this.setIdentity();
    }

    public Rotation(float angle) {
        this.set(angle);
    }

    public float getSin() {
        return this.s;
    }

    public float getCos() {
        return this.c;
    }

    public Rotation set(float angle) {
        this.s = JBoxUtils.sin(angle);
        this.c = JBoxUtils.cos(angle);
        return this;
    }

    public Rotation set(Rotation other) {
        this.s = other.s;
        this.c = other.c;
        return this;
    }

    public Rotation setIdentity() {
        this.s = 0.0f;
        this.c = 1.0f;
        return this;
    }

    public float getAngle() {
        return JBoxUtils.atan2(this.s, this.c);
    }

    public void getXAxis(Vec2 xAxis) {
        xAxis.set(this.c, this.s);
    }

    public void getYAxis(Vec2 yAxis) {
        yAxis.set(-this.s, this.c);
    }

    public Rotation clone() {
        Rotation copy = new Rotation();
        copy.s = this.s;
        copy.c = this.c;
        return copy;
    }

    public String toString() {
        return "Rot(s:" + this.s + ", c:" + this.c + ")";
    }

    public static final void mul(Rotation q, Rotation r, Rotation out) {
        float tempc = q.c * r.c - q.s * r.s;
        out.s = q.s * r.c + q.c * r.s;
        out.c = tempc;
    }

    public static final void mulUnsafe(Rotation q, Rotation r, Rotation out) {
        assert (r != out);
        assert (q != out);
        out.s = q.s * r.c + q.c * r.s;
        out.c = q.c * r.c - q.s * r.s;
    }

    public static final void mulTrans(Rotation q, Rotation r, Rotation out) {
        float tempc = q.c * r.c + q.s * r.s;
        out.s = q.c * r.s - q.s * r.c;
        out.c = tempc;
    }

    public static final void mulTransUnsafe(Rotation q, Rotation r, Rotation out) {
        out.s = q.c * r.s - q.s * r.c;
        out.c = q.c * r.c + q.s * r.s;
    }

    public static final void mulToOut(Rotation q, Vec2 v, Vec2 out) {
        float tempy = q.s * v.x + q.c * v.y;
        out.x = q.c * v.x - q.s * v.y;
        out.y = tempy;
    }

    public static final void mulToOutUnsafe(Rotation q, Vec2 v, Vec2 out) {
        out.x = q.c * v.x - q.s * v.y;
        out.y = q.s * v.x + q.c * v.y;
    }

    public static final void mulTrans(Rotation q, Vec2 v, Vec2 out) {
        float tempy = -q.s * v.x + q.c * v.y;
        out.x = q.c * v.x + q.s * v.y;
        out.y = tempy;
    }

    public static final void mulTransUnsafe(Rotation q, Vec2 v, Vec2 out) {
        out.x = q.c * v.x + q.s * v.y;
        out.y = -q.s * v.x + q.c * v.y;
    }
}

