/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.gameutils.math;

import com.almasb.gameutils.math.GameMath;
import java.io.Serializable;

public final class Vec2
implements Serializable {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vec2() {
        this(0.0f, 0.0f);
    }

    public Vec2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vec2(Vec2 toCopy) {
        this(toCopy.x, toCopy.y);
    }

    public void setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vec2 set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vec2 set(Vec2 v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vec2 add(Vec2 v) {
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    public Vec2 sub(Vec2 v) {
        return new Vec2(this.x - v.x, this.y - v.y);
    }

    public Vec2 mul(float a) {
        return new Vec2(this.x * a, this.y * a);
    }

    public Vec2 negate() {
        return new Vec2(-this.x, -this.y);
    }

    public Vec2 negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vec2 addLocal(Vec2 v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vec2 addLocal(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vec2 subLocal(Vec2 v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vec2 mulLocal(float a) {
        this.x *= a;
        this.y *= a;
        return this;
    }

    public Vec2 skew() {
        return new Vec2(-this.y, this.x);
    }

    public void skew(Vec2 out) {
        out.x = -this.y;
        out.y = this.x;
    }

    public float length() {
        return GameMath.sqrt(this.x * this.x + this.y * this.y);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distance(float otherX, float otherY) {
        float dx = otherX - this.x;
        float dy = otherY - this.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public float distanceSquared(float otherX, float otherY) {
        float dx = otherX - this.x;
        float dy = otherY - this.y;
        return dx * dx + dy * dy;
    }

    public boolean distanceLessThanOrEqual(float otherX, float otherY, float distance) {
        return this.distanceSquared(otherX, otherY) <= distance * distance;
    }

    public boolean distanceGreaterThanOrEqual(float otherX, float otherY, float distance) {
        return this.distanceSquared(otherX, otherY) >= distance * distance;
    }

    public float normalize() {
        float length = this.length();
        if (length < 1.1920929E-7f) {
            return 0.0f;
        }
        float invLength = 1.0f / length;
        this.x *= invLength;
        this.y *= invLength;
        return length;
    }

    public Vec2 normalizeLocal() {
        this.normalize();
        return this;
    }

    public boolean isValid() {
        return !Float.isNaN(this.x) && !Float.isInfinite(this.x) && !Float.isNaN(this.y) && !Float.isInfinite(this.y);
    }

    public Vec2 abs() {
        return new Vec2(GameMath.abs(this.x), GameMath.abs(this.y));
    }

    public Vec2 absLocal() {
        this.x = GameMath.abs(this.x);
        this.y = GameMath.abs(this.y);
        return this;
    }

    public float angle() {
        return this.angle(1.0f, 0.0f);
    }

    public float angle(Vec2 other) {
        return this.angle(other.x, other.y);
    }

    public float angle(float otherX, float otherY) {
        double angle1 = Math.toDegrees(Math.atan2(this.y, this.x));
        double angle2 = Math.toDegrees(Math.atan2(otherY, otherX));
        return (float)(angle1 - angle2);
    }

    public Vec2 clone() {
        return new Vec2(this.x, this.y);
    }

    public Vec2 copy() {
        return this.clone();
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public static Vec2 abs(Vec2 a) {
        return new Vec2(GameMath.abs(a.x), GameMath.abs(a.y));
    }

    public static void absToOut(Vec2 a, Vec2 out) {
        out.x = GameMath.abs(a.x);
        out.y = GameMath.abs(a.y);
    }

    public static float dot(Vec2 a, Vec2 b) {
        return a.x * b.x + a.y * b.y;
    }

    public static float cross(Vec2 a, Vec2 b) {
        return a.x * b.y - a.y * b.x;
    }

    public static Vec2 cross(Vec2 a, float s) {
        return new Vec2(s * a.y, -s * a.x);
    }

    public static void crossToOut(Vec2 a, float s, Vec2 out) {
        float tempy = -s * a.x;
        out.x = s * a.y;
        out.y = tempy;
    }

    public static void crossToOutUnsafe(Vec2 a, float s, Vec2 out) {
        assert (out != a);
        out.x = s * a.y;
        out.y = -s * a.x;
    }

    public static Vec2 cross(float s, Vec2 a) {
        return new Vec2(-s * a.y, s * a.x);
    }

    public static void crossToOut(float s, Vec2 a, Vec2 out) {
        float tempY = s * a.x;
        out.x = -s * a.y;
        out.y = tempY;
    }

    public static void crossToOutUnsafe(float s, Vec2 a, Vec2 out) {
        assert (out != a);
        out.x = -s * a.y;
        out.y = s * a.x;
    }

    public static void negateToOut(Vec2 a, Vec2 out) {
        out.x = -a.x;
        out.y = -a.y;
    }

    public static Vec2 min(Vec2 a, Vec2 b) {
        return new Vec2(a.x < b.x ? a.x : b.x, a.y < b.y ? a.y : b.y);
    }

    public static Vec2 max(Vec2 a, Vec2 b) {
        return new Vec2(a.x > b.x ? a.x : b.x, a.y > b.y ? a.y : b.y);
    }

    public static void minToOut(Vec2 a, Vec2 b, Vec2 out) {
        out.x = a.x < b.x ? a.x : b.x;
        out.y = a.y < b.y ? a.y : b.y;
    }

    public static void maxToOut(Vec2 a, Vec2 b, Vec2 out) {
        out.x = a.x > b.x ? a.x : b.x;
        out.y = a.y > b.y ? a.y : b.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec2 other = (Vec2)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }
}

