/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.ents.component;

import com.almasb.easyio.serialization.Bundle;
import com.almasb.ents.AbstractComponent;
import com.almasb.ents.serialization.SerializableComponent;
import java.io.Serializable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.jetbrains.annotations.NotNull;

public abstract class IntegerComponent
extends AbstractComponent
implements SerializableComponent {
    private IntegerProperty property;

    public IntegerComponent() {
        this(0);
    }

    public IntegerComponent(int initialValue) {
        this.property = new SimpleIntegerProperty(initialValue);
    }

    public final IntegerProperty valueProperty() {
        return this.property;
    }

    public final int getValue() {
        return this.property.get();
    }

    public final void setValue(int value) {
        this.property.set(value);
    }

    public void write(@NotNull Bundle bundle) {
        bundle.put("value", (Serializable)Integer.valueOf(this.getValue()));
    }

    public void read(@NotNull Bundle bundle) {
        this.setValue((Integer)bundle.get("value"));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[value=" + this.getValue() + "]";
    }
}

