/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.ents;

import com.almasb.ents.Component;
import com.almasb.ents.Entity;
import com.almasb.ents.EntityWorldListener;
import com.almasb.gameutils.collection.Array;
import com.almasb.gameutils.collection.ObjectMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityWorld {
    private static final Logger log = LogManager.getLogger(EntityWorld.class);
    protected List<Entity> entities;
    private List<Entity> addQueue;
    private List<Entity> removeQueue;
    private ObjectMap<Class<? extends Component>, Array<Entity>> componentMap = new ObjectMap();
    private Array<EntityWorldListener> worldListeners = new Array(true, 16);
    private static final Array<Entity> EMPTY = new Array(0);

    public EntityWorld() {
        this(32);
    }

    public EntityWorld(int initialCapacity) {
        this.entities = new ArrayList<Entity>(initialCapacity);
        this.addQueue = new ArrayList<Entity>(initialCapacity);
        this.removeQueue = new ArrayList<Entity>(initialCapacity);
    }

    public final void addEntity(Entity entity) {
        if (this.entities.contains(entity)) {
            throw new IllegalArgumentException("Entity is already attached to world");
        }
        this.addQueue.add(entity);
    }

    public final void addEntities(Entity ... entitiesToAdd) {
        for (Entity e : entitiesToAdd) {
            this.addEntity(e);
        }
    }

    public final void removeEntity(Entity entity) {
        if (!this.entities.contains(entity)) {
            log.warn("Attempted to remove entity not attached to world");
            return;
        }
        this.removeQueue.add(entity);
    }

    public final void removeEntities(Entity ... entitiesToRemove) {
        for (Entity e : entitiesToRemove) {
            this.removeEntity(e);
        }
    }

    public final void addWorldListener(EntityWorldListener listener) {
        this.worldListeners.add((Object)listener);
    }

    public final void removeWorldListener(EntityWorldListener listener) {
        this.worldListeners.removeValue((Object)listener, true);
    }

    private void notifyEntityAdded(Entity e) {
        for (EntityWorldListener l : this.worldListeners) {
            l.onEntityAdded(e);
        }
    }

    private void notifyEntityRemoved(Entity e) {
        for (EntityWorldListener l : this.worldListeners) {
            l.onEntityRemoved(e);
        }
    }

    private void notifyWorldUpdated(double tpf) {
        for (EntityWorldListener l : this.worldListeners) {
            l.onWorldUpdate(tpf);
        }
    }

    private void notifyWorldReset() {
        for (EntityWorldListener l : this.worldListeners) {
            l.onWorldReset();
        }
    }

    private void registerAndInitPendingEntities() {
        this.entities.addAll(this.addQueue);
        for (int i = 0; i < this.addQueue.size(); ++i) {
            Entity e = this.addQueue.get(i);
            for (Class type : e.components.keys()) {
                this.addComponentMap(type, e);
            }
            e.init(this);
            this.notifyEntityAdded(e);
        }
        this.addQueue.clear();
    }

    private void removeAndCleanPendingEntities() {
        this.entities.removeAll(this.removeQueue);
        for (int i = 0; i < this.removeQueue.size(); ++i) {
            Entity e = this.removeQueue.get(i);
            for (Class type : e.components.keys()) {
                this.removeComponentMap(type, e);
            }
            this.notifyEntityRemoved(e);
            e.clean();
        }
        this.removeQueue.clear();
    }

    protected void reset() {
        log.trace("Resetting entity world");
        this.registerAndInitPendingEntities();
        this.removeAndCleanPendingEntities();
        this.entities.forEach(Entity::clean);
        this.entities.clear();
        this.componentMap.clear();
        this.notifyWorldReset();
    }

    protected void update(double tpf) {
        this.registerAndInitPendingEntities();
        this.removeAndCleanPendingEntities();
        for (int i = 0; i < this.entities.size(); ++i) {
            this.entities.get(i).update(tpf);
        }
        this.notifyWorldUpdated(tpf);
    }

    private void addComponentMap(Class<? extends Component> type, Entity e) {
        Array array = (Array)this.componentMap.get(type);
        if (array == null) {
            array = new Array(false, 128);
            this.componentMap.put(type, (Object)array);
        }
        array.add((Object)e);
    }

    private void removeComponentMap(Class<? extends Component> type, Entity e) {
        Array array = (Array)this.componentMap.get(type);
        array.removeValue((Object)e, true);
    }

    public final List<Entity> getEntities() {
        return this.entities;
    }

    public final List<Entity> getEntitiesCopy() {
        return new ArrayList<Entity>(this.entities);
    }

    public final Array<Entity> getEntitiesByComponent(Class<? extends Component> type) {
        return (Array)this.componentMap.get(type, EMPTY);
    }

    void onComponentAdded(Component component, Entity e) {
        this.addComponentMap(component.getClass(), e);
    }

    void onComponentRemoved(Component component, Entity e) {
        this.removeComponentMap(component.getClass(), e);
    }
}

