/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.ents;

import com.almasb.easyio.serialization.Bundle;
import com.almasb.ents.AbstractComponent;
import com.almasb.ents.AbstractControl;
import com.almasb.ents.Component;
import com.almasb.ents.ComponentListener;
import com.almasb.ents.Control;
import com.almasb.ents.ControlListener;
import com.almasb.ents.CopyableComponent;
import com.almasb.ents.CopyableControl;
import com.almasb.ents.EntityWorld;
import com.almasb.ents.component.Required;
import com.almasb.ents.serialization.SerializableComponent;
import com.almasb.ents.serialization.SerializableControl;
import com.almasb.gameutils.collection.Array;
import com.almasb.gameutils.collection.ObjectMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Entity {
    private static final Logger log = LogManager.getLogger(Entity.class);
    ObjectMap<Class<? extends Control>, Control> controls = new ObjectMap();
    private List<ControlListener> controlListeners = new ArrayList<ControlListener>();
    ObjectMap<Class<? extends Component>, Component> components = new ObjectMap();
    private List<ComponentListener> componentListeners = new ArrayList<ComponentListener>();
    private boolean controlsEnabled = true;
    private ReadOnlyBooleanWrapper active = new ReadOnlyBooleanWrapper(false);
    private EntityWorld world;
    private boolean cleaning = false;

    public final boolean hasControl(Class<? extends Control> type) {
        return this.controls.containsKey(type);
    }

    public final <T extends Control> Optional<T> getControl(Class<T> type) {
        return Optional.ofNullable(this.getControlUnsafe(type));
    }

    public final <T extends Control> T getControlUnsafe(Class<T> type) {
        return (T)((Control)type.cast(this.controls.get(type)));
    }

    public final Array<Control> getControls() {
        return this.controls.values().toArray();
    }

    public final void addControl(Control control) {
        Class<?> type = control.getClass();
        if (type.getCanonicalName() == null) {
            log.fatal("Adding anonymous control: " + type.getName());
            throw new IllegalArgumentException("Anonymous controls are not allowed! - " + type.getName());
        }
        if (this.hasControl(type)) {
            log.fatal("Entity already has a control with type: " + type.getCanonicalName());
            throw new IllegalArgumentException("Entity already has a control with type: " + type.getCanonicalName());
        }
        this.checkRequirementsMet(control.getClass());
        this.controls.put(control.getClass(), (Object)control);
        if (control instanceof AbstractControl) {
            ((AbstractControl)control).setEntity(this);
        }
        control.onAdded(this);
        this.notifyControlAdded(control);
    }

    public final void removeControl(Class<? extends Control> type) {
        Control control = this.getControlUnsafe(type);
        if (control == null) {
            log.warn("Attempted to remove control but entity doesn't have a control with type: " + type.getSimpleName());
        } else {
            this.controls.remove(control.getClass());
            this.removeControlImpl(control);
        }
    }

    public final void removeAllControls() {
        for (Control control : this.controls.values()) {
            this.removeControlImpl(control);
        }
        this.controls.clear();
    }

    private void removeControlImpl(Control control) {
        this.notifyControlRemoved(control);
        control.onRemoved(this);
        if (control instanceof AbstractControl) {
            ((AbstractControl)control).setEntity(null);
        }
    }

    public void addControlListener(ControlListener listener) {
        this.controlListeners.add(listener);
    }

    public void removeControlListener(ControlListener listener) {
        this.controlListeners.remove(listener);
    }

    private void notifyControlAdded(Control control) {
        for (int i = 0; i < this.controlListeners.size(); ++i) {
            this.controlListeners.get(i).onControlAdded(control);
        }
    }

    private void notifyControlRemoved(Control control) {
        for (int i = 0; i < this.controlListeners.size(); ++i) {
            this.controlListeners.get(i).onControlRemoved(control);
        }
    }

    public final boolean hasComponent(Class<? extends Component> type) {
        return this.components.containsKey(type);
    }

    public final <T extends Component> Optional<T> getComponent(Class<T> type) {
        return Optional.ofNullable(this.getComponentUnsafe(type));
    }

    public final <T extends Component> T getComponentUnsafe(Class<T> type) {
        return (T)((Component)type.cast(this.components.get(type)));
    }

    public final Array<Component> getComponents() {
        return this.components.values().toArray();
    }

    public final void addComponent(Component component) {
        Class<?> type = component.getClass();
        if (type.getCanonicalName() == null) {
            throw new IllegalArgumentException("Anonymous components are not allowed! - " + type.getName());
        }
        if (this.hasComponent(type)) {
            throw new IllegalArgumentException("Entity already has a component with type: " + type.getCanonicalName());
        }
        if (component instanceof AbstractComponent) {
            AbstractComponent c = (AbstractComponent)component;
            c.setEntity(this);
        }
        this.checkRequirementsMet(component.getClass());
        this.components.put(component.getClass(), (Object)component);
        component.onAdded(this);
        if (this.isActive()) {
            this.world.onComponentAdded(component, this);
        }
        this.notifyComponentAdded(component);
    }

    public final void removeComponent(Class<? extends Component> type) {
        Component component = this.getComponentUnsafe(type);
        if (component == null) {
            log.warn("Attempted to remove component but entity doesn't have a component with type: " + type.getSimpleName());
        } else {
            if (!this.cleaning) {
                this.checkNotRequiredByAny(type);
            }
            this.components.remove(component.getClass());
            if (this.isActive()) {
                this.world.onComponentRemoved(component, this);
            }
            this.removeComponentImpl(component);
        }
    }

    public final void removeAllComponents() {
        for (Component component : this.components.values()) {
            this.removeComponentImpl(component);
        }
        this.components.clear();
    }

    private void removeComponentImpl(Component component) {
        this.notifyComponentRemoved(component);
        component.onRemoved(this);
        if (component instanceof AbstractComponent) {
            AbstractComponent c = (AbstractComponent)component;
            c.setEntity(null);
        }
    }

    public void addComponentListener(ComponentListener listener) {
        this.componentListeners.add(listener);
    }

    public void removeComponentListener(ComponentListener listener) {
        this.componentListeners.remove(listener);
    }

    private void notifyComponentAdded(Component component) {
        for (int i = 0; i < this.componentListeners.size(); ++i) {
            this.componentListeners.get(i).onComponentAdded(component);
        }
    }

    private void notifyComponentRemoved(Component component) {
        for (int i = 0; i < this.componentListeners.size(); ++i) {
            this.componentListeners.get(i).onComponentRemoved(component);
        }
    }

    private void checkRequirementsMet(Class<?> type) {
        Required[] required;
        for (Required r : required = (Required[])type.getAnnotationsByType(Required.class)) {
            if (this.hasComponent(r.value())) continue;
            throw new IllegalStateException("Required component: [" + r.value().getSimpleName() + "] for: " + type.getSimpleName() + " is missing");
        }
    }

    private void checkNotRequiredByAny(Class<? extends Component> type) {
        for (Class t : this.components.keys()) {
            for (Required required : (Required[])t.getAnnotationsByType(Required.class)) {
                if (!required.value().equals(type)) continue;
                throw new IllegalArgumentException("Required component: [" + required.value().getSimpleName() + "] by: " + t.getSimpleName());
            }
        }
        for (Class t : this.controls.keys()) {
            for (Required required : (Required[])t.getAnnotationsByType(Required.class)) {
                if (!required.value().equals(type)) continue;
                throw new IllegalArgumentException("Required component: [" + required.value().getSimpleName() + "] by: " + t.getSimpleName());
            }
        }
    }

    public final void setControlsEnabled(boolean b) {
        this.controlsEnabled = b;
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.active.getReadOnlyProperty();
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public EntityWorld getWorld() {
        return this.world;
    }

    void init(EntityWorld world) {
        this.world = world;
        this.active.set(true);
    }

    void update(double tpf) {
        if (this.controlsEnabled) {
            for (Control c : this.controls.values()) {
                if (c.isPaused()) continue;
                c.onUpdate(this, tpf);
            }
        }
    }

    void clean() {
        this.cleaning = true;
        this.active.set(false);
        this.removeAllControls();
        this.removeAllComponents();
        this.controlListeners.clear();
        this.componentListeners.clear();
        this.controlsEnabled = true;
        this.world = null;
    }

    public final void removeFromWorld() {
        this.world.removeEntity(this);
    }

    public Entity copy() {
        Entity copy = new Entity();
        for (Component component : this.components.values()) {
            if (!(component instanceof CopyableComponent)) continue;
            copy.addComponent((Component)((CopyableComponent)((Object)component)).copy());
        }
        for (Control control : this.controls.values()) {
            if (!(control instanceof CopyableControl)) continue;
            copy.addControl((Control)((CopyableControl)((Object)control)).copy());
        }
        return copy;
    }

    public void save(Bundle bundle) {
        Bundle componentsBundle = new Bundle("components");
        for (Component component : this.components.values()) {
            if (!(component instanceof SerializableComponent)) continue;
            Bundle b = new Bundle(component.getClass().getCanonicalName());
            ((SerializableComponent)((Object)component)).write(b);
            componentsBundle.put(b.getName(), (Serializable)b);
        }
        Bundle controlsBundle = new Bundle("controls");
        for (Control control : this.controls.values()) {
            if (!(control instanceof SerializableControl)) continue;
            Bundle b = new Bundle(control.getClass().getCanonicalName());
            ((SerializableControl)((Object)control)).write(b);
            controlsBundle.put(b.getName(), (Serializable)b);
        }
        bundle.put("components", (Serializable)componentsBundle);
        bundle.put("controls", (Serializable)controlsBundle);
    }

    public void load(Bundle bundle) {
        Bundle componentsBundle = (Bundle)bundle.get("components");
        for (Component component : this.components.values()) {
            if (!(component instanceof SerializableComponent)) continue;
            Bundle b = (Bundle)componentsBundle.get(component.getClass().getCanonicalName());
            if (b != null) {
                ((SerializableComponent)((Object)component)).read(b);
                continue;
            }
            log.warn("Bundle " + componentsBundle + " does not have SerializableComponent: " + component);
        }
        Bundle controlsBundle = (Bundle)bundle.get("controls");
        for (Control control : this.controls.values()) {
            if (!(control instanceof SerializableControl)) continue;
            Bundle b = (Bundle)controlsBundle.get(control.getClass().getCanonicalName());
            if (b != null) {
                ((SerializableControl)((Object)control)).read(b);
                continue;
            }
            log.warn("Bundle " + componentsBundle + " does not have SerializableControl: " + control);
        }
    }

    public String toString() {
        return "Entity(" + String.join((CharSequence)"\n", "components=" + this.components.values(), "controls=" + this.controls.values()) + ")";
    }
}

