/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.astar;

import com.almasb.astar.AStarLogic;
import com.almasb.astar.AStarNode;
import com.almasb.astar.NodeState;
import java.util.List;

public class AStarGrid {
    private AStarLogic logic = new AStarLogic();
    private AStarNode[][] grid;

    public AStarGrid(int width, int height) {
        this.grid = new AStarNode[width][height];
        for (int y = 0; y < this.grid[0].length; ++y) {
            for (int x = 0; x < this.grid.length; ++x) {
                this.grid[x][y] = new AStarNode(x, y, NodeState.WALKABLE);
            }
        }
    }

    public final int getWidth() {
        return this.grid.length;
    }

    public final int getHeight() {
        return this.grid[0].length;
    }

    public final boolean isWithin(int x, int y) {
        return x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight();
    }

    public final void setStateForAllNodes(NodeState state) {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.getNode(x, y).setState(state);
            }
        }
    }

    public final void setNodeState(int x, int y, NodeState state) {
        this.getNode(x, y).setState(state);
    }

    public final NodeState getNodeState(int x, int y) {
        return this.getNode(x, y).getState();
    }

    public final List<AStarNode> getPath(int startX, int startY, int targetX, int targetY) {
        return this.logic.getPath(this.grid, this.getNode(startX, startY), this.getNode(targetX, targetY), new AStarNode[0]);
    }

    public final AStarNode getNode(int x, int y) {
        return this.grid[x][y];
    }

    public AStarNode[][] getGrid() {
        return this.grid;
    }
}

