/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.time_sources;

import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import io.tempo.TimeSource;
import io.tempo.TimeSourceConfig;
import io.tempo.internal.AndroidSntpClient;
import io.tempo.internal.SntpClient;
import io.tempo.time_sources.SlackSntpTimeSource;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u001e\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/tempo/time_sources/SlackSntpTimeSource;", "Lio/tempo/TimeSource;", "id", "", "priority", "", "ntpPool", "maxRoundTripMs", "timeoutMs", "(Ljava/lang/String;ILjava/lang/String;II)V", "getId", "()Ljava/lang/String;", "config", "Lio/tempo/TimeSourceConfig;", "requestTime", "Lio/reactivex/Single;", "", "requestTimeToAddress", "Lio/tempo/internal/SntpClient$Result;", "kotlin.jvm.PlatformType", "address", "Ljava/net/InetAddress;", "turnSlowRequestsIntoFailure", "", "rawResults", "AllRequestsFailure", "tempo_release"})
public final class SlackSntpTimeSource
implements TimeSource {
    @NotNull
    private final String id;
    private final int priority;
    private final String ntpPool;
    private final int maxRoundTripMs;
    private final int timeoutMs;

    @Override
    @NotNull
    public TimeSourceConfig config() {
        return new TimeSourceConfig(this.id, this.priority);
    }

    @Override
    @NotNull
    public Single<Long> requestTime() {
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this){
            final /* synthetic */ SlackSntpTimeSource this$0;

            public final void subscribe(@NotNull SingleEmitter<InetAddress> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                try {
                    InetAddress result = AndroidSntpClient.INSTANCE.queryHostAddress(SlackSntpTimeSource.access$getNtpPool$p(this.this$0));
                    if (!emitter.isDisposed()) {
                        emitter.onSuccess((Object)result);
                    }
                }
                catch (Throwable t) {
                    emitter.tryOnError(t);
                }
            }
            {
                this.this$0 = slackSntpTimeSource;
            }
        }).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).flatMap(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ SlackSntpTimeSource this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Single<List<SntpClient.Result>> apply(@NotNull InetAddress address) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
                int n = 1;
                Iterable $this$map$iv = (Iterable)new IntRange(n, 5);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Single single = SlackSntpTimeSource.access$requestTimeToAddress(this.this$0, address);
                    collection.add(single);
                }
                List requests = (List)destination$iv$iv;
                return Single.zip((Iterable)requests, (Function)requestTime.1.INSTANCE);
            }
            {
                this.this$0 = slackSntpTimeSource;
            }
        }).map(new Function<T, R>(this){
            final /* synthetic */ SlackSntpTimeSource this$0;

            /*
             * WARNING - void declaration
             */
            public final long apply(@NotNull List<? extends SntpClient.Result> rawResults) {
                Collection destination$iv$iv2;
                int $i$f$map;
                Iterable $this$map$iv;
                boolean bl;
                Iterable $this$mapNotNullTo$iv$iv;
                Intrinsics.checkParameterIsNotNull(rawResults, (String)"rawResults");
                List results = SlackSntpTimeSource.access$turnSlowRequestsIntoFailure(this.this$0, rawResults);
                Iterable $this$mapNotNull$iv = results;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Iterable<SntpClient.Result.Success> destination$iv$iv32 = new ArrayList<E>();
                boolean $i$f$mapNotNullTo2 = false;
                Iterator<T> $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    SntpClient.Result.Success success;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl2 = false;
                    SntpClient.Result it = (SntpClient.Result)element$iv$iv;
                    boolean bl3 = false;
                    SntpClient.Result result = it;
                    if (!(result instanceof SntpClient.Result.Success)) {
                        result = null;
                    }
                    if ((SntpClient.Result.Success)result == null) continue;
                    boolean bl4 = false;
                    bl = false;
                    SntpClient.Result.Success it$iv$iv = success;
                    boolean bl5 = false;
                    destination$iv$iv32.add(it$iv$iv);
                }
                List successes = (List)destination$iv$iv32;
                $this$mapNotNull$iv = successes;
                $i$f$mapNotNull = false;
                if (!$this$mapNotNull$iv.isEmpty()) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$sortedBy$iv = successes;
                    boolean $i$f$sortedBy = false;
                    $this$mapNotNullTo$iv$iv = $this$sortedBy$iv;
                    boolean destination$iv$iv32 = false;
                    Comparator $i$f$mapNotNullTo2 = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            SntpClient.Result.Success it = (SntpClient.Result.Success)a;
                            boolean bl2 = false;
                            Comparable comparable = Long.valueOf(it.getRoundTripTimeMs());
                            it = (SntpClient.Result.Success)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Long l = it.getRoundTripTimeMs();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                        }
                    };
                    $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$mapNotNullTo$iv$iv, (Comparator)$i$f$mapNotNullTo2);
                    $i$f$map = 0;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        object = (SntpClient.Result.Success)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl6 = false;
                        Long l = it.getNtpTimeMs();
                        collection.add(l);
                    }
                } else {
                    void $this$mapNotNullTo$iv$iv2;
                    Iterable $this$mapNotNull$iv2 = results;
                    boolean $i$f$mapNotNull2 = false;
                    destination$iv$iv32 = $this$mapNotNull$iv2;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo3 = false;
                    void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                    boolean $i$f$forEach2 = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv2.iterator();
                    while (iterator.hasNext()) {
                        SntpClient.Result.Failure failure;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl7 = false;
                        SntpClient.Result it = (SntpClient.Result)element$iv$iv;
                        boolean bl8 = false;
                        SntpClient.Result result = it;
                        if (!(result instanceof SntpClient.Result.Failure)) {
                            result = null;
                        }
                        if ((SntpClient.Result.Failure)result == null) continue;
                        bl = false;
                        boolean bl9 = false;
                        SntpClient.Result.Failure it$iv$iv = failure;
                        boolean bl10 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List failures = (List)destination$iv$iv;
                    String msgs2 = CollectionsKt.joinToString$default((Iterable)failures, (CharSequence)"; ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)requestTime.msgs.1.INSTANCE, (int)24, null);
                    String errorMsg = "All NTP requests failed: " + msgs2;
                    SntpClient.Result.Failure failure = (SntpClient.Result.Failure)CollectionsKt.firstOrNull((List)failures);
                    Throwable cause = failure != null ? failure.getError() : null;
                    throw (Throwable)new AllRequestsFailure(errorMsg, cause);
                }
                $this$map$iv = (List)destination$iv$iv2;
                $i$f$map = successes.size() / 2;
                boolean $this$mapTo$iv$iv = false;
                return ((Number)$this$map$iv.get($i$f$map)).longValue();
            }
            {
                this.this$0 = slackSntpTimeSource;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single\n            .crea\u2026          }\n            }");
        return single;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SntpClient.Result> turnSlowRequestsIntoFailure(List<? extends SntpClient.Result> rawResults) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = rawResults;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            SntpClient.Result result = (SntpClient.Result)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = it;
            if (var11_11 instanceof SntpClient.Result.Success) {
                boolean bl2;
                boolean bl3 = bl2 = ((SntpClient.Result.Success)it).getRoundTripTimeMs() > (long)this.maxRoundTripMs;
                object = bl2 ? (SntpClient.Result)new SntpClient.Result.Failure(null, "RoundTrip time exceeded allowed threshold:" + " took " + ((SntpClient.Result.Success)it).getRoundTripTimeMs() + ", but max is " + this.maxRoundTripMs) : it;
            } else {
                object = it;
            }
            void var14_14 = object;
            collection.add(var14_14);
        }
        return (List)destination$iv$iv;
    }

    private final Single<SntpClient.Result> requestTimeToAddress(InetAddress address) {
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this, address){
            final /* synthetic */ SlackSntpTimeSource this$0;
            final /* synthetic */ InetAddress $address;

            public final void subscribe(@NotNull SingleEmitter<SntpClient.Result> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                try {
                    SntpClient.Result result = AndroidSntpClient.INSTANCE.requestTime(this.$address, AndroidSntpClient.INSTANCE.getNTP_PORT(), SlackSntpTimeSource.access$getTimeoutMs$p(this.this$0));
                    if (!emitter.isDisposed()) {
                        emitter.onSuccess((Object)result);
                    }
                }
                catch (Throwable t) {
                    emitter.tryOnError(t);
                }
            }
            {
                this.this$0 = slackSntpTimeSource;
                this.$address = inetAddress;
            }
        }).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).onErrorReturn((Function)requestTimeToAddress.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single\n            .crea\u2026error, msg)\n            }");
        return single;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public SlackSntpTimeSource(@NotNull String id, int priority, @NotNull String ntpPool, int maxRoundTripMs, int timeoutMs) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)ntpPool, (String)"ntpPool");
        this.id = id;
        this.priority = priority;
        this.ntpPool = ntpPool;
        this.maxRoundTripMs = maxRoundTripMs;
        this.timeoutMs = timeoutMs;
    }

    public /* synthetic */ SlackSntpTimeSource(String string, int n, String string2, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = "default-slack-sntp";
        }
        if ((n4 & 2) != 0) {
            n = 10;
        }
        if ((n4 & 4) != 0) {
            string2 = "time.google.com";
        }
        if ((n4 & 8) != 0) {
            n2 = 1000;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 10000;
        }
        this(string, n, string2, n2, n3);
    }

    public SlackSntpTimeSource() {
        this(null, 0, null, 0, 0, 31, null);
    }

    public static final /* synthetic */ String access$getNtpPool$p(SlackSntpTimeSource $this) {
        return $this.ntpPool;
    }

    public static final /* synthetic */ Single access$requestTimeToAddress(SlackSntpTimeSource $this, InetAddress address) {
        return $this.requestTimeToAddress(address);
    }

    public static final /* synthetic */ List access$turnSlowRequestsIntoFailure(SlackSntpTimeSource $this, List rawResults) {
        return $this.turnSlowRequestsIntoFailure(rawResults);
    }

    public static final /* synthetic */ int access$getTimeoutMs$p(SlackSntpTimeSource $this) {
        return $this.timeoutMs;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/tempo/time_sources/SlackSntpTimeSource$AllRequestsFailure;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "errorMsg", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "tempo_release"})
    public static final class AllRequestsFailure
    extends RuntimeException {
        public AllRequestsFailure(@NotNull String errorMsg, @Nullable Throwable cause) {
            Intrinsics.checkParameterIsNotNull((Object)errorMsg, (String)"errorMsg");
            super(errorMsg, cause);
        }
    }
}

