/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.internal;

import android.os.SystemClock;
import io.tempo.internal.AndroidSntpClient;
import io.tempo.internal.SntpClient;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0018\u0010#\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0002J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0016J \u0010)\u001a\u00020*2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/tempo/internal/AndroidSntpClient;", "Lio/tempo/internal/SntpClient;", "()V", "NTP_LEAP_NOSYNC", "", "NTP_MODE_BROADCAST", "NTP_MODE_CLIENT", "NTP_MODE_SERVER", "NTP_PACKET_SIZE", "NTP_PORT", "getNTP_PORT", "()I", "NTP_STRATUM_DEATH", "NTP_STRATUM_MAX", "NTP_VERSION", "OFFSET_1900_TO_1970", "", "ORIGINATE_TIME_OFFSET", "RECEIVE_TIME_OFFSET", "TRANSMIT_TIME_OFFSET", "checkValidServerReply", "Lio/tempo/internal/SntpClient$Result$Failure;", "leap", "", "mode", "stratum", "transmitTime", "queryHostAddress", "Ljava/net/InetAddress;", "host", "", "read32", "buffer", "", "offset", "readTimeStamp", "requestTime", "Lio/tempo/internal/SntpClient$Result;", "address", "port", "timeoutMs", "writeTimeStamp", "", "time", "InetException", "tempo_release"})
public final class AndroidSntpClient
implements SntpClient {
    private static final int NTP_PORT = 123;
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_MODE_SERVER = 4;
    private static final int NTP_MODE_BROADCAST = 5;
    private static final int NTP_VERSION = 3;
    private static final int NTP_LEAP_NOSYNC = 3;
    private static final int NTP_STRATUM_DEATH = 0;
    private static final int NTP_STRATUM_MAX = 15;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    public static final AndroidSntpClient INSTANCE;

    public final int getNTP_PORT() {
        return NTP_PORT;
    }

    @NotNull
    public final InetAddress queryHostAddress(@NotNull String host) {
        InetAddress inetAddress;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        try {
            InetAddress inetAddress2 = Inet4Address.getByName(host);
            Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress2, (String)"Inet4Address.getByName(host)");
            inetAddress = inetAddress2;
        }
        catch (Exception e) {
            String errorMsg = "Error getting the host (" + host + ") inet address.";
            throw (Throwable)new InetException(errorMsg);
        }
        return inetAddress;
    }

    @Override
    @NotNull
    public SntpClient.Result requestTime(@NotNull InetAddress address, int port, int timeoutMs) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Function1<Function1<? super DatagramSocket, ? extends Unit>, SntpClient.Result> $fun$useSocket$1 = new Function1<Function1<? super DatagramSocket, ? extends Unit>, SntpClient.Result>(timeoutMs){
            final /* synthetic */ int $timeoutMs;

            @Nullable
            public final SntpClient.Result invoke(@NotNull Function1<? super DatagramSocket, Unit> use) {
                SntpClient.Result.Failure failure;
                Intrinsics.checkParameterIsNotNull(use, (String)"use");
                DatagramSocket socket = new DatagramSocket();
                try {
                    socket.setSoTimeout(this.$timeoutMs);
                    use.invoke((Object)socket);
                    failure = null;
                }
                catch (Exception e) {
                    String errorMsg = "Error transmitting request/response";
                    failure = new SntpClient.Result.Failure(e, errorMsg);
                }
                SntpClient.Result.Failure result = failure;
                socket.close();
                return result;
            }
            {
                this.$timeoutMs = n;
                super(1);
            }
        };
        byte[] buffer = new byte[NTP_PACKET_SIZE];
        buffer[0] = (byte)(NTP_MODE_CLIENT | NTP_VERSION << 3);
        long requestTime2 = System.currentTimeMillis();
        long requestTicks = SystemClock.elapsedRealtime();
        this.writeTimeStamp(buffer, TRANSMIT_TIME_OFFSET, requestTime2);
        SntpClient.Result result = $fun$useSocket$1.invoke((Function1<? super DatagramSocket, Unit>)((Function1)new Function1<DatagramSocket, Unit>(buffer, address, port){
            final /* synthetic */ byte[] $buffer;
            final /* synthetic */ InetAddress $address;
            final /* synthetic */ int $port;

            public final void invoke(@NotNull DatagramSocket $this$useSocket) {
                Intrinsics.checkParameterIsNotNull((Object)$this$useSocket, (String)"$receiver");
                DatagramPacket request = new DatagramPacket(this.$buffer, this.$buffer.length, this.$address, this.$port);
                $this$useSocket.send(request);
                DatagramPacket response = new DatagramPacket(this.$buffer, this.$buffer.length);
                $this$useSocket.receive(response);
            }
            {
                this.$buffer = byArray;
                this.$address = inetAddress;
                this.$port = n;
                super(1);
            }
        }));
        if (result != null) {
            SntpClient.Result result2 = result;
            boolean bl = false;
            boolean bl2 = false;
            SntpClient.Result failure = result2;
            boolean bl3 = false;
            return failure;
        }
        long responseTicks = SystemClock.elapsedRealtime();
        long responseTime = requestTime2 + (responseTicks - requestTicks);
        byte leap = (byte)(buffer[0] >> 6 & 3);
        byte mode = (byte)(buffer[0] & 7);
        int stratum = buffer[1] & 0xFF;
        long originateTime = this.readTimeStamp(buffer, ORIGINATE_TIME_OFFSET);
        long receiveTime = this.readTimeStamp(buffer, RECEIVE_TIME_OFFSET);
        long transmitTime = this.readTimeStamp(buffer, TRANSMIT_TIME_OFFSET);
        SntpClient.Result.Failure failure = this.checkValidServerReply(leap, mode, stratum, transmitTime);
        if (failure != null) {
            SntpClient.Result.Failure failure2 = failure;
            boolean bl = false;
            boolean bl4 = false;
            SntpClient.Result.Failure failure3 = failure2;
            boolean bl5 = false;
            return failure3;
        }
        long roundTripTime = responseTicks - requestTicks - (transmitTime - receiveTime);
        long clockOffset = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
        return new SntpClient.Result.Success(responseTime + clockOffset, responseTicks, roundTripTime);
    }

    private final SntpClient.Result.Failure checkValidServerReply(byte leap, byte mode, int stratum, long transmitTime) {
        SntpClient.Result.Failure failure;
        String errorMsg;
        String string = errorMsg = leap == (byte)NTP_LEAP_NOSYNC ? "Unsynchronized server" : (mode != (byte)NTP_MODE_SERVER && mode != (byte)NTP_MODE_BROADCAST ? "Untrusted mode: " + mode : (stratum == NTP_STRATUM_DEATH || stratum > NTP_STRATUM_MAX ? "Untrusted stratum: " + stratum : (transmitTime == 0L ? "Zero transmit time" : null)));
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            failure = new SntpClient.Result.Failure(null, it);
        } else {
            failure = null;
        }
        return failure;
    }

    private final long read32(byte[] buffer, int offset) {
        byte b0 = buffer[offset];
        byte b1 = buffer[offset + 1];
        byte b2 = buffer[offset + 2];
        byte b3 = buffer[offset + 3];
        Function1 signedToUnsigned2 = read32.signedToUnsigned.1.INSTANCE;
        long i0 = ((Number)signedToUnsigned2.invoke((Object)b0)).longValue();
        long i1 = ((Number)signedToUnsigned2.invoke((Object)b1)).longValue();
        long i2 = ((Number)signedToUnsigned2.invoke((Object)b2)).longValue();
        long i3 = ((Number)signedToUnsigned2.invoke((Object)b3)).longValue();
        return (i0 << 24) + (i1 << 16) + (i2 << 8) + i3;
    }

    private final long readTimeStamp(byte[] buffer, int offset) {
        long seconds = this.read32(buffer, offset);
        long fraction = this.read32(buffer, offset + 4);
        if (seconds == 0L && fraction == 0L) {
            return 0L;
        }
        return (seconds - OFFSET_1900_TO_1970) * 1000L + fraction * 1000L / 0x100000000L;
    }

    private final void writeTimeStamp(byte[] buffer, int offset, long time) {
        if (time == 0L) {
            Arrays.fill(buffer, offset, offset + 8, (byte)0);
            return;
        }
        long milliseconds = time - time / 1000L * 1000L;
        long seconds = time / 1000L + OFFSET_1900_TO_1970;
        int o = offset;
        buffer[o++] = (byte)(seconds >> 24);
        buffer[o++] = (byte)(seconds >> 16);
        buffer[o++] = (byte)(seconds >> 8);
        buffer[o++] = (byte)(seconds >> 0);
        long fraction = milliseconds * 0x100000000L / 1000L;
        buffer[o++] = (byte)(fraction >> 24);
        buffer[o++] = (byte)(fraction >> 16);
        buffer[o++] = (byte)(fraction >> 8);
        buffer[o] = (byte)(Math.random() * 255.0);
    }

    private AndroidSntpClient() {
    }

    static {
        AndroidSntpClient androidSntpClient;
        INSTANCE = androidSntpClient = new AndroidSntpClient();
        NTP_PORT = 123;
        ORIGINATE_TIME_OFFSET = 24;
        RECEIVE_TIME_OFFSET = 32;
        TRANSMIT_TIME_OFFSET = 40;
        NTP_PACKET_SIZE = 48;
        NTP_MODE_CLIENT = 3;
        NTP_MODE_SERVER = 4;
        NTP_MODE_BROADCAST = 5;
        NTP_VERSION = 3;
        NTP_LEAP_NOSYNC = 3;
        NTP_STRATUM_MAX = 15;
        OFFSET_1900_TO_1970 = 2208988800L;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/tempo/internal/AndroidSntpClient$InetException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "errorMsg", "", "(Ljava/lang/String;)V", "tempo_release"})
    public static final class InetException
    extends RuntimeException {
        public InetException(@NotNull String errorMsg) {
            Intrinsics.checkParameterIsNotNull((Object)errorMsg, (String)"errorMsg");
            super(errorMsg);
        }
    }
}

