/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.internal;

import android.annotation.SuppressLint;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.ReplayProcessor;
import io.reactivex.schedulers.Schedulers;
import io.tempo.DeviceClocks;
import io.tempo.Scheduler;
import io.tempo.Storage;
import io.tempo.SyncRetryStrategy;
import io.tempo.TempoConfig;
import io.tempo.TempoEvent;
import io.tempo.TimeSource;
import io.tempo.TimeSourceCache;
import io.tempo.TimeSourceConfig;
import io.tempo.TimeSourceWrapper;
import io.tempo.internal.TempoInstance;
import io.tempo.schedulers.NoOpScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eJ\b\u0010 \u001a\u00020!H\u0003J\r\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140&J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0(2\u0006\u0010)\u001a\u00020\u0004H\u0002J\b\u0010*\u001a\u00020!H\u0002J\b\u0010+\u001a\u00020!H\u0002J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140&J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00010&2\u0006\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020!H\u0002R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/tempo/internal/TempoInstance;", "", "timeSources", "", "Lio/tempo/TimeSource;", "config", "Lio/tempo/TempoConfig;", "storage", "Lio/tempo/Storage;", "deviceClocks", "Lio/tempo/DeviceClocks;", "scheduler", "Lio/tempo/Scheduler;", "(Ljava/util/List;Lio/tempo/TempoConfig;Lio/tempo/Storage;Lio/tempo/DeviceClocks;Lio/tempo/Scheduler;)V", "activeTimeSourceName", "", "getConfig", "()Lio/tempo/TempoConfig;", "eventsSubject", "Lio/reactivex/processors/ReplayProcessor;", "Lio/tempo/TempoEvent;", "kotlin.jvm.PlatformType", "initialized", "", "getInitialized", "()Z", "getTimeSources", "()Ljava/util/List;", "timeWrappers", "", "Lio/tempo/TimeSourceWrapper;", "activeTimeWrapper", "fireUpFirstSyncFlow", "", "now", "", "()Ljava/lang/Long;", "observeEvents", "Lio/reactivex/Flowable;", "requestTime", "Lio/reactivex/Single;", "timeSource", "restoreCache", "setupScheduler", "syncFlow", "syncRetryStratFlow", "strat", "Lio/tempo/SyncRetryStrategy;", "updateActiveTimeWrapper", "tempo_release"})
public final class TempoInstance {
    private String activeTimeSourceName;
    private final Map<String, TimeSourceWrapper> timeWrappers;
    private final ReplayProcessor<TempoEvent> eventsSubject;
    @NotNull
    private final List<TimeSource> timeSources;
    @NotNull
    private final TempoConfig config;
    private final Storage storage;
    private final DeviceClocks deviceClocks;
    private final Scheduler scheduler;

    public final boolean getInitialized() {
        return this.activeTimeWrapper() != null;
    }

    @NotNull
    public final Flowable<TempoEvent> observeEvents() {
        Flowable flowable = this.eventsSubject.onBackpressureLatest();
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"eventsSubject.onBackpressureLatest()");
        return flowable;
    }

    @Nullable
    public final Long now() {
        TimeSourceWrapper timeSourceWrapper = this.activeTimeWrapper();
        return timeSourceWrapper != null ? Long.valueOf(timeSourceWrapper.nowFromCache(this.deviceClocks.uptime())) : null;
    }

    @Nullable
    public final TimeSourceWrapper activeTimeWrapper() {
        TimeSourceWrapper timeSourceWrapper;
        String string = this.activeTimeSourceName;
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            timeSourceWrapper = this.timeWrappers.get(it);
        } else {
            timeSourceWrapper = null;
        }
        return timeSourceWrapper;
    }

    @NotNull
    public final Flowable<TempoEvent> syncFlow() {
        Flowable flowable = Flowable.fromIterable((Iterable)this.timeSources).observeOn(Schedulers.io()).flatMap(new Function<T, Publisher<? extends R>>(this){
            final /* synthetic */ TempoInstance this$0;

            @NotNull
            public final Flowable<TempoEvent> apply(@NotNull TimeSource source) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                return TempoInstance.access$requestTime(this.this$0, source).timeout(this.this$0.getConfig().getSyncTimeoutMs(), TimeUnit.MILLISECONDS).toFlowable().map((Function)syncFlow.1.INSTANCE).startWith((Object)new TempoEvent.TSSyncRequest(source)).onErrorReturn((Function)new Function<Throwable, TempoEvent>(source){
                    final /* synthetic */ TimeSource $source;

                    @NotNull
                    public final TempoEvent.TSSyncFailure apply(@NotNull Throwable error) {
                        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                        String defaultMsg = "Error requesting time to '" + this.$source.config().getId() + '\'';
                        TimeSource timeSource = this.$source;
                        Intrinsics.checkExpressionValueIsNotNull((Object)timeSource, (String)"source");
                        String string = error.getMessage();
                        if (string == null) {
                            string = defaultMsg;
                        }
                        return new TempoEvent.TSSyncFailure(timeSource, error, string);
                    }
                    {
                        this.$source = timeSource;
                    }
                });
            }
            {
                this.this$0 = tempoInstance;
            }
        }).publish(new Function<Flowable<T>, Publisher<R>>(this){
            final /* synthetic */ TempoInstance this$0;

            @NotNull
            public final Flowable<TempoEvent> apply(@NotNull Flowable<TempoEvent> flow) {
                Intrinsics.checkParameterIsNotNull(flow, (String)"flow");
                Flowable flowable = flow.buffer(this.this$0.getTimeSources().size() * 2).take(1L).map((Function)syncFlow.endFlow.1.INSTANCE).map((Function)new Function<T, R>(this){
                    final /* synthetic */ syncFlow.2 this$0;

                    @NotNull
                    public final TempoEvent apply(@NotNull Boolean hasSuccess) {
                        Intrinsics.checkParameterIsNotNull((Object)hasSuccess, (String)"hasSuccess");
                        TimeSourceWrapper activeTw = this.this$0.this$0.activeTimeWrapper();
                        return hasSuccess != false && activeTw != null ? (TempoEvent)new TempoEvent.SyncSuccess(activeTw) : (TempoEvent)new TempoEvent.SyncFail();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"flow\n                   \u2026  }\n                    }");
                Flowable endFlow2 = flowable;
                Flowable initializedFlow2 = Flowable.fromCallable((Callable)new Callable<T>(this){
                    final /* synthetic */ syncFlow.2 this$0;

                    public final boolean call() {
                        return this.this$0.this$0.getInitialized();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).flatMap((Function)syncFlow.initializedFlow.2.INSTANCE);
                return flow.mergeWith((Publisher)endFlow2).concatWith((Publisher)initializedFlow2);
            }
            {
                this.this$0 = tempoInstance;
            }
        }).startWith((Object)new TempoEvent.SyncStart()).doOnNext((Consumer)new Consumer<TempoEvent>(this){
            final /* synthetic */ TempoInstance this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void accept(TempoEvent event) {
                TempoInstance.access$getEventsSubject$p(this.this$0).onNext((Object)event);
                if (event instanceof TempoEvent.TSSyncSuccess) {
                    String name = ((TempoEvent.TSSyncSuccess)event).getWrapper().getTimeSource().config().getId();
                    TimeSourceCache cache = ((TempoEvent.TSSyncSuccess)event).getWrapper().getCache();
                    Map map = TempoInstance.access$getTimeWrappers$p(this.this$0);
                    synchronized (map) {
                        boolean bl = false;
                        TempoInstance.access$getStorage$p(this.this$0).putCache(cache);
                        Map map2 = TempoInstance.access$getTimeWrappers$p(this.this$0);
                        String string = name;
                        TimeSourceWrapper timeSourceWrapper = ((TempoEvent.TSSyncSuccess)event).getWrapper();
                        map2.put(string, timeSourceWrapper);
                        TempoInstance.access$updateActiveTimeWrapper(this.this$0);
                        map2 = Unit.INSTANCE;
                    }
                    TempoInstance.access$getEventsSubject$p(this.this$0).onNext((Object)new TempoEvent.CacheSaved(cache));
                }
            }
            {
                this.this$0 = tempoInstance;
            }
        }).repeatWhen(new Function<Flowable<Object>, Publisher<?>>(this){
            final /* synthetic */ TempoInstance this$0;

            @NotNull
            public final Flowable<Boolean> apply(@NotNull Flowable<Object> completed) {
                Intrinsics.checkParameterIsNotNull(completed, (String)"completed");
                Flowable retryFlow = TempoInstance.access$syncRetryStratFlow(this.this$0, this.this$0.getConfig().getSyncRetryStrategy());
                return completed.zipWith((Publisher)retryFlow, (BiFunction)new BiFunction<Object, Object, Boolean>(this){
                    final /* synthetic */ syncFlow.4 this$0;

                    public final boolean apply(@NotNull Object $noName_0, @NotNull Object $noName_1) {
                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                        Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                        return this.this$0.this$0.getInitialized();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).takeWhile((Predicate)syncFlow.2.INSTANCE);
            }
            {
                this.this$0 = tempoInstance;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.fromIterable(ti\u2026ile { !it }\n            }");
        return flowable;
    }

    private final Single<TimeSourceWrapper> requestTime(TimeSource timeSource) {
        Single single = timeSource.requestTime().map(new Function<T, R>(this, timeSource){
            final /* synthetic */ TempoInstance this$0;
            final /* synthetic */ TimeSource $timeSource;

            @NotNull
            public final TimeSourceWrapper apply(@NotNull Long reqTime) {
                Intrinsics.checkParameterIsNotNull((Object)reqTime, (String)"reqTime");
                TimeSourceCache cache = new TimeSourceCache(this.$timeSource.config().getId(), TempoInstance.access$getDeviceClocks$p(this.this$0).estimatedBootTime(), TempoInstance.access$getDeviceClocks$p(this.this$0).uptime(), reqTime);
                return new TimeSourceWrapper(this.$timeSource, cache);
            }
            {
                this.this$0 = tempoInstance;
                this.$timeSource = timeSource;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"timeSource.requestTime()\u2026rce, cache)\n            }");
        return single;
    }

    private final void updateActiveTimeWrapper() {
        TimeSourceWrapper topPriority;
        Object object;
        Object v0;
        Iterable $receiver$iv = this.timeWrappers.values();
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            TimeSourceWrapper it = (TimeSourceWrapper)maxElem$iv;
            boolean bl = false;
            int maxValue$iv = it.getTimeSource().config().getPriority();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                TimeSourceWrapper it2 = (TimeSourceWrapper)e$iv;
                $i$a$-maxBy-TempoInstance$updateActiveTimeWrapper$topPriority$1 = false;
                int v$iv = it2.getTimeSource().config().getPriority();
                if (maxValue$iv >= v$iv) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v0 = maxElem$iv;
        }
        this.activeTimeSourceName = (object = (topPriority = (TimeSourceWrapper)v0)) != null && (object = ((TimeSourceWrapper)object).getTimeSource()) != null && (object = object.config()) != null ? ((TimeSourceConfig)object).getId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void restoreCache() {
        List list;
        TimeSourceCache $i$f$mapTo;
        Pair it;
        Pair pair;
        Collection collection;
        TimeSource timeSource;
        Iterable $receiver$iv$iv;
        Function1<TimeSourceCache, Boolean> isCacheValid$ = new Function1<TimeSourceCache, Boolean>(this){
            final /* synthetic */ TempoInstance this$0;

            public final boolean invoke(@NotNull TimeSourceCache cache) {
                Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
                long estimatedBootTime = TempoInstance.access$getDeviceClocks$p(this.this$0).estimatedBootTime();
                long cacheEstimatedBootTime = cache.getEstimatedBootTime();
                return Math.abs(cacheEstimatedBootTime - estimatedBootTime) <= 5000L;
            }
            {
                this.this$0 = tempoInstance;
                super(1);
            }
        };
        Iterable $receiver$iv = this.timeSources;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void source;
            timeSource = (TimeSource)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pair = TuplesKt.to((Object)source, (Object)this.storage.getCache(source.config().getId()));
            collection.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((TimeSourceCache)it.getSecond() != null) {
                TimeSourceCache p1 = $i$f$mapTo;
                boolean bl3 = false;
                bl = isCacheValid$.invoke(p1);
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable $receiver$iv2 = $receiver$iv$iv = $receiver$iv;
        for (Object element$iv : $receiver$iv2) {
            it = (Pair)element$iv;
            boolean bl = false;
            if ((TimeSourceCache)it.getSecond() == null) continue;
            TimeSourceCache it2 = $i$f$mapTo;
            boolean bl4 = false;
            this.eventsSubject.onNext((Object)new TempoEvent.CacheRestored(it2));
        }
        $receiver$iv = $receiver$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = ((TimeSource)it.getFirst()).config().getId();
            TimeSource timeSource2 = (TimeSource)it.getFirst();
            Object object = it.getSecond();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            pair = TuplesKt.to((Object)string, (Object)new TimeSourceWrapper(timeSource2, (TimeSourceCache)object));
            collection.add(pair);
        }
        List it3 = list = (List)destination$iv$iv;
        boolean bl = false;
        Map<String, TimeSourceWrapper> map = this.timeWrappers;
        synchronized (map) {
            boolean bl5 = false;
            MapsKt.putAll(this.timeWrappers, (Iterable)it3);
            this.updateActiveTimeWrapper();
            timeSource = Unit.INSTANCE;
        }
    }

    private final void setupScheduler() {
        if (!(this.scheduler instanceof NoOpScheduler)) {
            this.eventsSubject.onNext((Object)new TempoEvent.SchedulerSetupStart());
            try {
                this.scheduler.setup();
                this.eventsSubject.onNext((Object)new TempoEvent.SchedulerSetupComplete());
            }
            catch (Exception e) {
                this.eventsSubject.onNext((Object)new TempoEvent.SchedulerSetupFailure(e, "Error while setting up scheduler."));
            }
        } else {
            this.eventsSubject.onNext((Object)new TempoEvent.SchedulerSetupSkip());
        }
    }

    private final Flowable<Object> syncRetryStratFlow(SyncRetryStrategy strat) {
        Flowable flowable;
        SyncRetryStrategy syncRetryStrategy = strat;
        if (syncRetryStrategy instanceof SyncRetryStrategy.None) {
            Flowable flowable2 = Flowable.empty();
            flowable = flowable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)flowable2, (String)"Flowable.empty()");
        } else if (syncRetryStrategy instanceof SyncRetryStrategy.ConstantInterval) {
            Flowable interval2 = Flowable.interval((long)((SyncRetryStrategy.ConstantInterval)strat).getTimerMs(), (long)((SyncRetryStrategy.ConstantInterval)strat).getIntervalMs(), (TimeUnit)TimeUnit.MILLISECONDS);
            Flowable tries = Flowable.range((int)1, (int)((SyncRetryStrategy.ConstantInterval)strat).getRetries());
            Flowable flowable3 = Flowable.zip((Publisher)((Publisher)interval2), (Publisher)((Publisher)tries), (BiFunction)syncRetryStratFlow.1.INSTANCE);
            flowable = flowable3;
            Intrinsics.checkExpressionValueIsNotNull((Object)flowable3, (String)"Flowable.zip<Long, Int, \u2026BiFunction { _, _ -> 0 })");
        } else if (syncRetryStrategy instanceof SyncRetryStrategy.ExpBackoff) {
            Flowable tries = Flowable.range((int)1, (int)((SyncRetryStrategy.ExpBackoff)strat).getRetries());
            Function1 interval3 = (Function1)new Function1<Integer, Flowable<Long>>(strat){
                final /* synthetic */ SyncRetryStrategy $strat;

                public final Flowable<Long> invoke(int idx) {
                    double backoff = Math.pow(2.0, idx) * ((SyncRetryStrategy.ExpBackoff)this.$strat).getMultiplier();
                    long timer = RangesKt.coerceAtMost((long)((long)((double)((SyncRetryStrategy.ExpBackoff)this.$strat).getTimerMs() + backoff)), (long)((SyncRetryStrategy.ExpBackoff)this.$strat).getMaxIntervalMs());
                    return Flowable.timer((long)timer, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                {
                    this.$strat = syncRetryStrategy;
                    super(1);
                }
            };
            Flowable flowable4 = tries.concatMap(new Function<T, Publisher<? extends R>>(interval3){
                final /* synthetic */ Function1 $interval;

                public final Flowable<Long> apply(@NotNull Integer idx) {
                    Intrinsics.checkParameterIsNotNull((Object)idx, (String)"idx");
                    return (Flowable)this.$interval.invoke((Object)idx);
                }
                {
                    this.$interval = function1;
                }
            });
            flowable = flowable4;
            Intrinsics.checkExpressionValueIsNotNull((Object)flowable4, (String)"tries.concatMap { idx -> interval(idx) }");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return flowable;
    }

    @SuppressLint(value={"CheckResult"})
    private final void fireUpFirstSyncFlow() {
        Flowable.just(this.timeSources).doOnNext((Consumer)new Consumer<List<? extends TimeSource>>(this){
            final /* synthetic */ TempoInstance this$0;

            public final void accept(List<? extends TimeSource> it) {
                TempoInstance.access$getEventsSubject$p(this.this$0).onNext((Object)new TempoEvent.Initializing());
            }
            {
                this.this$0 = tempoInstance;
            }
        }).observeOn(Schedulers.io()).doOnNext((Consumer)new Consumer<List<? extends TimeSource>>(this){
            final /* synthetic */ TempoInstance this$0;

            public final void accept(List<? extends TimeSource> it) {
                TempoInstance.access$restoreCache(this.this$0);
            }
            {
                this.this$0 = tempoInstance;
            }
        }).doOnNext((Consumer)new Consumer<List<? extends TimeSource>>(this){
            final /* synthetic */ TempoInstance this$0;

            public final void accept(List<? extends TimeSource> it) {
                TempoInstance.access$setupScheduler(this.this$0);
            }
            {
                this.this$0 = tempoInstance;
            }
        }).flatMap(new Function<T, Publisher<? extends R>>(this){
            final /* synthetic */ TempoInstance this$0;

            @NotNull
            public final Flowable<TempoEvent> apply(@NotNull List<? extends TimeSource> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.this$0.syncFlow();
            }
            {
                this.this$0 = tempoInstance;
            }
        }).subscribe((Consumer)fireUpFirstSyncFlow.5.INSTANCE, (Consumer)fireUpFirstSyncFlow.6.INSTANCE, (Action)fireUpFirstSyncFlow.7.INSTANCE);
    }

    @NotNull
    public final List<TimeSource> getTimeSources() {
        return this.timeSources;
    }

    @NotNull
    public final TempoConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    public TempoInstance(@NotNull List<? extends TimeSource> timeSources, @NotNull TempoConfig config, @NotNull Storage storage, @NotNull DeviceClocks deviceClocks, @NotNull Scheduler scheduler) {
        boolean bl;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull(timeSources, (String)"timeSources");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)deviceClocks, (String)"deviceClocks");
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        this.timeSources = timeSources;
        this.config = config;
        this.storage = storage;
        this.deviceClocks = deviceClocks;
        this.scheduler = scheduler;
        Object object = this;
        Object object2 = new LinkedHashMap();
        ((TempoInstance)object).timeWrappers = object2;
        ReplayProcessor replayProcessor = ReplayProcessor.createWithTime((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS, (io.reactivex.Scheduler)Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)replayProcessor, (String)"ReplayProcessor.createWi\u2026SECONDS, Schedulers.io())");
        this.eventsSubject = replayProcessor;
        Collection collection = this.timeSources;
        boolean bl3 = bl2 = !collection.isEmpty();
        if (!bl2) {
            boolean bl4 = false;
            String string = "'timeSources' must not be empty.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable bl4 = $receiver$iv = (Iterable)this.timeSources;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TimeSource timeSource = (TimeSource)item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            object2 = it.config().getId();
            object.add(object2);
        }
        boolean bl6 = bl = CollectionsKt.distinct((Iterable)((List)destination$iv$iv)).size() == this.timeSources.size();
        if (!bl) {
            boolean bl7 = false;
            String string = "Duplicate ids in 'timeSources' aren't allowed.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.fireUpFirstSyncFlow();
    }

    public static final /* synthetic */ Single access$requestTime(TempoInstance $this, TimeSource timeSource) {
        return $this.requestTime(timeSource);
    }

    public static final /* synthetic */ ReplayProcessor access$getEventsSubject$p(TempoInstance $this) {
        return $this.eventsSubject;
    }

    public static final /* synthetic */ Map access$getTimeWrappers$p(TempoInstance $this) {
        return $this.timeWrappers;
    }

    public static final /* synthetic */ Storage access$getStorage$p(TempoInstance $this) {
        return $this.storage;
    }

    public static final /* synthetic */ void access$updateActiveTimeWrapper(TempoInstance $this) {
        $this.updateActiveTimeWrapper();
    }

    public static final /* synthetic */ Flowable access$syncRetryStratFlow(TempoInstance $this, SyncRetryStrategy strat) {
        return $this.syncRetryStratFlow(strat);
    }

    public static final /* synthetic */ DeviceClocks access$getDeviceClocks$p(TempoInstance $this) {
        return $this.deviceClocks;
    }

    public static final /* synthetic */ void access$restoreCache(TempoInstance $this) {
        $this.restoreCache();
    }

    public static final /* synthetic */ void access$setupScheduler(TempoInstance $this) {
        $this.setupScheduler();
    }
}

