/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.schedulers.internal;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import io.tempo.schedulers.internal.SyncFlowWorker;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lio/tempo/schedulers/internal/SetupWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "Companion", "tempo-android-workmanager-scheduler_release"})
public final class SetupWorker
extends Worker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String WORK_NAME_PKEY = "tag-pkey";
    @NotNull
    private static final String INTERNAL_MINUTES_PKEY = "interval-minutes-pkey";

    public SetupWorker(@NotNull Context context, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workerParameters, (String)"workerParameters");
        super(context, workerParameters);
    }

    @NotNull
    public ListenableWorker.Result doWork() {
        String string;
        String string2 = this.getInputData().getString(WORK_NAME_PKEY);
        Intrinsics.checkNotNull((Object)string2);
        String workName = string = string2;
        long intervalInMinutes = this.getInputData().getLong(INTERNAL_MINUTES_PKEY, 60L);
        WorkRequest workRequest = ((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(SyncFlowWorker.class, intervalInMinutes, TimeUnit.MINUTES).setInputData(SyncFlowWorker.Companion.params(intervalInMinutes))).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(\n                SyncFlowWorker::class.java,\n                intervalInMinutes,\n                TimeUnit.MINUTES\n            )\n            .setInputData(\n                SyncFlowWorker.params(intervalInMinutes)\n            )\n            .build()");
        PeriodicWorkRequest request = (PeriodicWorkRequest)workRequest;
        WorkManager.getInstance((Context)this.getApplicationContext()).enqueueUniquePeriodicWork(workName, ExistingPeriodicWorkPolicy.KEEP, request);
        workRequest = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"success()");
        return workRequest;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/tempo/schedulers/internal/SetupWorker$Companion;", "", "()V", "INTERNAL_MINUTES_PKEY", "", "WORK_NAME_PKEY", "params", "Landroidx/work/Data;", "workName", "intervalInMinutes", "", "tempo-android-workmanager-scheduler_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Data params(@NotNull String workName, long intervalInMinutes) {
            Intrinsics.checkNotNullParameter((Object)workName, (String)"workName");
            Data data = new Data.Builder().putString(SetupWorker.WORK_NAME_PKEY, workName).putLong(SetupWorker.INTERNAL_MINUTES_PKEY, intervalInMinutes).build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder()\n                .putString(WORK_NAME_PKEY, workName)\n                .putLong(INTERNAL_MINUTES_PKEY, intervalInMinutes)\n                .build()");
            return data;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

