/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.login.serverbound;

import io.netty.buffer.ByteBuf;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundKeyPacket
implements MinecraftPacket {
    private final byte @lombok.NonNull [] sharedKey;
    private final byte @lombok.NonNull [] encryptedChallenge;

    public ServerboundKeyPacket(PublicKey publicKey, SecretKey secretKey, byte[] encryptedChallenge) {
        this.sharedKey = ServerboundKeyPacket.cipherData(1, publicKey, secretKey.getEncoded());
        this.encryptedChallenge = ServerboundKeyPacket.cipherData(1, publicKey, encryptedChallenge);
    }

    public SecretKey getSecretKey(PrivateKey privateKey) {
        return new SecretKeySpec(ServerboundKeyPacket.cipherData(2, privateKey, this.sharedKey), "AES");
    }

    public byte[] getDecryptedChallenge(PrivateKey privateKey) {
        return ServerboundKeyPacket.cipherData(2, privateKey, this.encryptedChallenge);
    }

    public ServerboundKeyPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.sharedKey = helper.readByteArray(in);
        this.encryptedChallenge = helper.readByteArray(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeByteArray(out, this.sharedKey);
        helper.writeByteArray(out, this.encryptedChallenge);
    }

    private static byte[] cipherData(int mode, Key key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            cipher.init(mode, key);
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Failed to cipher data.", e);
        }
    }

    public @NonNull String toString() {
        return "ServerboundKeyPacket(sharedKey=" + Arrays.toString(this.sharedKey) + ", encryptedChallenge=" + Arrays.toString(this.encryptedChallenge) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundKeyPacket)) {
            return false;
        }
        ServerboundKeyPacket other = (ServerboundKeyPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.sharedKey, other.sharedKey)) {
            return false;
        }
        return Arrays.equals(this.encryptedChallenge, other.encryptedChallenge);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundKeyPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.sharedKey);
        result = result * 59 + Arrays.hashCode(this.encryptedChallenge);
        return result;
    }
}

