/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundEntityTagQuery
implements MinecraftPacket {
    private final int transactionId;
    private final int entityId;

    public ServerboundEntityTagQuery(ByteBuf in, MinecraftCodecHelper helper) {
        this.transactionId = helper.readVarInt(in);
        this.entityId = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.transactionId);
        helper.writeVarInt(out, this.entityId);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundEntityTagQuery)) {
            return false;
        }
        ServerboundEntityTagQuery other = (ServerboundEntityTagQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        return this.getEntityId() == other.getEntityId();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundEntityTagQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + this.getEntityId();
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundEntityTagQuery(transactionId=" + this.getTransactionId() + ", entityId=" + this.getEntityId() + ")";
    }

    public @NonNull ServerboundEntityTagQuery withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ServerboundEntityTagQuery(transactionId, this.entityId);
    }

    public @NonNull ServerboundEntityTagQuery withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerboundEntityTagQuery(this.transactionId, entityId);
    }

    public ServerboundEntityTagQuery(int transactionId, int entityId) {
        this.transactionId = transactionId;
        this.entityId = entityId;
    }
}

