/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.scoreboard;

import io.netty.buffer.ByteBuf;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.NumberFormat;

public class ClientboundSetScorePacket
implements MinecraftPacket {
    @lombok.NonNull
    private final String owner;
    @lombok.NonNull
    private final String objective;
    private final int value;
    private final @Nullable Component display;
    private final @Nullable NumberFormat numberFormat;

    public ClientboundSetScorePacket(@lombok.NonNull String owner, @lombok.NonNull String objective, int value) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.owner = owner;
        this.objective = objective;
        this.value = value;
        this.display = null;
        this.numberFormat = null;
    }

    public ClientboundSetScorePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.owner = helper.readString(in);
        this.objective = helper.readString(in);
        this.value = helper.readVarInt(in);
        this.display = helper.readNullable(in, helper::readComponent);
        this.numberFormat = helper.readNullable(in, helper::readNumberFormat);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeString(out, this.owner);
        helper.writeString(out, this.objective);
        helper.writeVarInt(out, this.value);
        helper.writeNullable(out, this.display, helper::writeComponent);
        helper.writeNullable(out, this.numberFormat, helper::writeNumberFormat);
    }

    @lombok.NonNull
    public String getOwner() {
        return this.owner;
    }

    @lombok.NonNull
    public String getObjective() {
        return this.objective;
    }

    public int getValue() {
        return this.value;
    }

    public @Nullable Component getDisplay() {
        return this.display;
    }

    public @Nullable NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetScorePacket)) {
            return false;
        }
        ClientboundSetScorePacket other = (ClientboundSetScorePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$objective = this.getObjective();
        String other$objective = other.getObjective();
        if (this$objective == null ? other$objective != null : !this$objective.equals(other$objective)) {
            return false;
        }
        Component this$display = this.getDisplay();
        Component other$display = other.getDisplay();
        if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
            return false;
        }
        NumberFormat this$numberFormat = this.getNumberFormat();
        NumberFormat other$numberFormat = other.getNumberFormat();
        return !(this$numberFormat == null ? other$numberFormat != null : !this$numberFormat.equals(other$numberFormat));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetScorePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValue();
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $objective = this.getObjective();
        result = result * 59 + ($objective == null ? 43 : $objective.hashCode());
        Component $display = this.getDisplay();
        result = result * 59 + ($display == null ? 43 : $display.hashCode());
        NumberFormat $numberFormat = this.getNumberFormat();
        result = result * 59 + ($numberFormat == null ? 43 : $numberFormat.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetScorePacket(owner=" + this.getOwner() + ", objective=" + this.getObjective() + ", value=" + this.getValue() + ", display=" + this.getDisplay() + ", numberFormat=" + this.getNumberFormat() + ")";
    }

    public @NonNull ClientboundSetScorePacket withOwner(@lombok.NonNull String owner) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        return this.owner == owner ? this : new ClientboundSetScorePacket(owner, this.objective, this.value, this.display, this.numberFormat);
    }

    public @NonNull ClientboundSetScorePacket withObjective(@lombok.NonNull String objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        return this.objective == objective ? this : new ClientboundSetScorePacket(this.owner, objective, this.value, this.display, this.numberFormat);
    }

    public @NonNull ClientboundSetScorePacket withValue(int value) {
        return this.value == value ? this : new ClientboundSetScorePacket(this.owner, this.objective, value, this.display, this.numberFormat);
    }

    public @NonNull ClientboundSetScorePacket withDisplay(@Nullable Component display) {
        return this.display == display ? this : new ClientboundSetScorePacket(this.owner, this.objective, this.value, display, this.numberFormat);
    }

    public @NonNull ClientboundSetScorePacket withNumberFormat(@Nullable NumberFormat numberFormat) {
        return this.numberFormat == numberFormat ? this : new ClientboundSetScorePacket(this.owner, this.objective, this.value, this.display, numberFormat);
    }

    private ClientboundSetScorePacket(@lombok.NonNull String owner, @lombok.NonNull String objective, int value, @Nullable Component display, @Nullable NumberFormat numberFormat) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.owner = owner;
        this.objective = objective;
        this.value = value;
        this.display = display;
        this.numberFormat = numberFormat;
    }
}

