/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetTimePacket
implements MinecraftPacket {
    private final long worldAge;
    private final long time;

    public ClientboundSetTimePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.worldAge = in.readLong();
        this.time = in.readLong();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeLong(this.worldAge);
        out.writeLong(this.time);
    }

    public long getWorldAge() {
        return this.worldAge;
    }

    public long getTime() {
        return this.time;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetTimePacket)) {
            return false;
        }
        ClientboundSetTimePacket other = (ClientboundSetTimePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorldAge() != other.getWorldAge()) {
            return false;
        }
        return this.getTime() == other.getTime();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetTimePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $worldAge = this.getWorldAge();
        result = result * 59 + (int)($worldAge >>> 32 ^ $worldAge);
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetTimePacket(worldAge=" + this.getWorldAge() + ", time=" + this.getTime() + ")";
    }

    public @NonNull ClientboundSetTimePacket withWorldAge(long worldAge) {
        return this.worldAge == worldAge ? this : new ClientboundSetTimePacket(worldAge, this.time);
    }

    public @NonNull ClientboundSetTimePacket withTime(long time) {
        return this.time == time ? this : new ClientboundSetTimePacket(this.worldAge, time);
    }

    public ClientboundSetTimePacket(long worldAge, long time) {
        this.worldAge = worldAge;
        this.time = time;
    }
}

