/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetDefaultSpawnPositionPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Vector3i position;
    private final float angle;

    public ClientboundSetDefaultSpawnPositionPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.position = helper.readPosition(in);
        this.angle = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writePosition(out, this.position);
        out.writeFloat(this.angle);
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetDefaultSpawnPositionPacket)) {
            return false;
        }
        ClientboundSetDefaultSpawnPositionPacket other = (ClientboundSetDefaultSpawnPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getAngle(), other.getAngle()) != 0) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !this$position.equals(other$position));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetDefaultSpawnPositionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getAngle());
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetDefaultSpawnPositionPacket(position=" + this.getPosition() + ", angle=" + this.getAngle() + ")";
    }

    public @NonNull ClientboundSetDefaultSpawnPositionPacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundSetDefaultSpawnPositionPacket(position, this.angle);
    }

    public @NonNull ClientboundSetDefaultSpawnPositionPacket withAngle(float angle) {
        return this.angle == angle ? this : new ClientboundSetDefaultSpawnPositionPacket(this.position, angle);
    }

    public ClientboundSetDefaultSpawnPositionPacket(@lombok.NonNull Vector3i position, float angle) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.position = position;
        this.angle = angle;
    }
}

