/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.Particle;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleType;

public class ClientboundLevelParticlesPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Particle particle;
    private final boolean longDistance;
    private final double x;
    private final double y;
    private final double z;
    private final float offsetX;
    private final float offsetY;
    private final float offsetZ;
    private final float velocityOffset;
    private final int amount;

    public ClientboundLevelParticlesPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.longDistance = in.readBoolean();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.offsetX = in.readFloat();
        this.offsetY = in.readFloat();
        this.offsetZ = in.readFloat();
        this.velocityOffset = in.readFloat();
        this.amount = in.readInt();
        ParticleType type = helper.readParticleType(in);
        this.particle = new Particle(type, helper.readParticleData(in, type));
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeBoolean(this.longDistance);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.offsetX);
        out.writeFloat(this.offsetY);
        out.writeFloat(this.offsetZ);
        out.writeFloat(this.velocityOffset);
        out.writeInt(this.amount);
        helper.writeParticleType(out, this.particle.getType());
        helper.writeParticleData(out, this.particle.getType(), this.particle.getData());
    }

    @lombok.NonNull
    public Particle getParticle() {
        return this.particle;
    }

    public boolean isLongDistance() {
        return this.longDistance;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getOffsetZ() {
        return this.offsetZ;
    }

    public float getVelocityOffset() {
        return this.velocityOffset;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLevelParticlesPacket)) {
            return false;
        }
        ClientboundLevelParticlesPacket other = (ClientboundLevelParticlesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLongDistance() != other.isLongDistance()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetX(), other.getOffsetX()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetY(), other.getOffsetY()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffsetZ(), other.getOffsetZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getVelocityOffset(), other.getVelocityOffset()) != 0) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        Particle this$particle = this.getParticle();
        Particle other$particle = other.getParticle();
        return !(this$particle == null ? other$particle != null : !((Object)this$particle).equals(other$particle));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundLevelParticlesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLongDistance() ? 79 : 97);
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getOffsetX());
        result = result * 59 + Float.floatToIntBits(this.getOffsetY());
        result = result * 59 + Float.floatToIntBits(this.getOffsetZ());
        result = result * 59 + Float.floatToIntBits(this.getVelocityOffset());
        result = result * 59 + this.getAmount();
        Particle $particle = this.getParticle();
        result = result * 59 + ($particle == null ? 43 : ((Object)$particle).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundLevelParticlesPacket(particle=" + this.getParticle() + ", longDistance=" + this.isLongDistance() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", offsetX=" + this.getOffsetX() + ", offsetY=" + this.getOffsetY() + ", offsetZ=" + this.getOffsetZ() + ", velocityOffset=" + this.getVelocityOffset() + ", amount=" + this.getAmount() + ")";
    }

    public @NonNull ClientboundLevelParticlesPacket withParticle(@lombok.NonNull Particle particle) {
        if (particle == null) {
            throw new NullPointerException("particle is marked non-null but is null");
        }
        return this.particle == particle ? this : new ClientboundLevelParticlesPacket(particle, this.longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public @NonNull ClientboundLevelParticlesPacket withLongDistance(boolean longDistance) {
        return this.longDistance == longDistance ? this : new ClientboundLevelParticlesPacket(this.particle, longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public @NonNull ClientboundLevelParticlesPacket withX(double x) {
        return this.x == x ? this : new ClientboundLevelParticlesPacket(this.particle, this.longDistance, x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public @NonNull ClientboundLevelParticlesPacket withY(double y) {
        return this.y == y ? this : new ClientboundLevelParticlesPacket(this.particle, this.longDistance, this.x, y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public @NonNull ClientboundLevelParticlesPacket withZ(double z) {
        return this.z == z ? this : new ClientboundLevelParticlesPacket(this.particle, this.longDistance, this.x, this.y, z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public @NonNull ClientboundLevelParticlesPacket withOffsetX(float offsetX) {
        return this.offsetX == offsetX ? this : new ClientboundLevelParticlesPacket(this.particle, this.longDistance, this.x, this.y, this.z, offsetX, this.offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public @NonNull ClientboundLevelParticlesPacket withOffsetY(float offsetY) {
        return this.offsetY == offsetY ? this : new ClientboundLevelParticlesPacket(this.particle, this.longDistance, this.x, this.y, this.z, this.offsetX, offsetY, this.offsetZ, this.velocityOffset, this.amount);
    }

    public @NonNull ClientboundLevelParticlesPacket withOffsetZ(float offsetZ) {
        return this.offsetZ == offsetZ ? this : new ClientboundLevelParticlesPacket(this.particle, this.longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, offsetZ, this.velocityOffset, this.amount);
    }

    public @NonNull ClientboundLevelParticlesPacket withVelocityOffset(float velocityOffset) {
        return this.velocityOffset == velocityOffset ? this : new ClientboundLevelParticlesPacket(this.particle, this.longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, velocityOffset, this.amount);
    }

    public @NonNull ClientboundLevelParticlesPacket withAmount(int amount) {
        return this.amount == amount ? this : new ClientboundLevelParticlesPacket(this.particle, this.longDistance, this.x, this.y, this.z, this.offsetX, this.offsetY, this.offsetZ, this.velocityOffset, amount);
    }

    public ClientboundLevelParticlesPacket(@lombok.NonNull Particle particle, boolean longDistance, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float velocityOffset, int amount) {
        if (particle == null) {
            throw new NullPointerException("particle is marked non-null but is null");
        }
        this.particle = particle;
        this.longDistance = longDistance;
        this.x = x;
        this.y = y;
        this.z = z;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.velocityOffset = velocityOffset;
        this.amount = amount;
    }
}

