/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.BlockBreakStage;

public class ClientboundBlockDestructionPacket
implements MinecraftPacket {
    private final int breakerEntityId;
    @lombok.NonNull
    private final Vector3i position;
    @lombok.NonNull
    private final BlockBreakStage stage;

    public ClientboundBlockDestructionPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.breakerEntityId = helper.readVarInt(in);
        this.position = helper.readPosition(in);
        this.stage = helper.readBlockBreakStage(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.breakerEntityId);
        helper.writePosition(out, this.position);
        helper.writeBlockBreakStage(out, this.stage);
    }

    public int getBreakerEntityId() {
        return this.breakerEntityId;
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @lombok.NonNull
    public BlockBreakStage getStage() {
        return this.stage;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockDestructionPacket)) {
            return false;
        }
        ClientboundBlockDestructionPacket other = (ClientboundBlockDestructionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBreakerEntityId() != other.getBreakerEntityId()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        BlockBreakStage this$stage = this.getStage();
        BlockBreakStage other$stage = other.getStage();
        return !(this$stage == null ? other$stage != null : !((Object)((Object)this$stage)).equals((Object)other$stage));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundBlockDestructionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBreakerEntityId();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        BlockBreakStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : ((Object)((Object)$stage)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundBlockDestructionPacket(breakerEntityId=" + this.getBreakerEntityId() + ", position=" + this.getPosition() + ", stage=" + this.getStage() + ")";
    }

    public @NonNull ClientboundBlockDestructionPacket withBreakerEntityId(int breakerEntityId) {
        return this.breakerEntityId == breakerEntityId ? this : new ClientboundBlockDestructionPacket(breakerEntityId, this.position, this.stage);
    }

    public @NonNull ClientboundBlockDestructionPacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundBlockDestructionPacket(this.breakerEntityId, position, this.stage);
    }

    public @NonNull ClientboundBlockDestructionPacket withStage(@lombok.NonNull BlockBreakStage stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return this.stage == stage ? this : new ClientboundBlockDestructionPacket(this.breakerEntityId, this.position, stage);
    }

    public ClientboundBlockDestructionPacket(int breakerEntityId, @lombok.NonNull Vector3i position, @lombok.NonNull BlockBreakStage stage) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        this.breakerEntityId = breakerEntityId;
        this.position = position;
        this.stage = stage;
    }
}

