/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatType;

public class ClientboundDisguisedChatPacket
implements MinecraftPacket {
    private final Component message;
    private final Holder<ChatType> chatType;
    private final Component name;
    private final @Nullable Component targetName;

    public ClientboundDisguisedChatPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.message = helper.readComponent(in);
        this.chatType = helper.readHolder(in, helper::readChatType);
        this.name = helper.readComponent(in);
        this.targetName = helper.readNullable(in, helper::readComponent);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeComponent(out, this.message);
        helper.writeHolder(out, this.chatType, helper::writeChatType);
        helper.writeComponent(out, this.name);
        helper.writeNullable(out, this.targetName, helper::writeComponent);
    }

    public Component getMessage() {
        return this.message;
    }

    public Holder<ChatType> getChatType() {
        return this.chatType;
    }

    public Component getName() {
        return this.name;
    }

    public @Nullable Component getTargetName() {
        return this.targetName;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundDisguisedChatPacket)) {
            return false;
        }
        ClientboundDisguisedChatPacket other = (ClientboundDisguisedChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Component this$message = this.getMessage();
        Component other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Holder<ChatType> this$chatType = this.getChatType();
        Holder<ChatType> other$chatType = other.getChatType();
        if (this$chatType == null ? other$chatType != null : !this$chatType.equals(other$chatType)) {
            return false;
        }
        Component this$name = this.getName();
        Component other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Component this$targetName = this.getTargetName();
        Component other$targetName = other.getTargetName();
        return !(this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundDisguisedChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Holder<ChatType> $chatType = this.getChatType();
        result = result * 59 + ($chatType == null ? 43 : $chatType.hashCode());
        Component $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Component $targetName = this.getTargetName();
        result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundDisguisedChatPacket(message=" + this.getMessage() + ", chatType=" + this.getChatType() + ", name=" + this.getName() + ", targetName=" + this.getTargetName() + ")";
    }

    public @NonNull ClientboundDisguisedChatPacket withMessage(Component message) {
        return this.message == message ? this : new ClientboundDisguisedChatPacket(message, this.chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundDisguisedChatPacket withChatType(Holder<ChatType> chatType) {
        return this.chatType == chatType ? this : new ClientboundDisguisedChatPacket(this.message, chatType, this.name, this.targetName);
    }

    public @NonNull ClientboundDisguisedChatPacket withName(Component name) {
        return this.name == name ? this : new ClientboundDisguisedChatPacket(this.message, this.chatType, name, this.targetName);
    }

    public @NonNull ClientboundDisguisedChatPacket withTargetName(@Nullable Component targetName) {
        return this.targetName == targetName ? this : new ClientboundDisguisedChatPacket(this.message, this.chatType, this.name, targetName);
    }

    public ClientboundDisguisedChatPacket(Component message, Holder<ChatType> chatType, Component name, @Nullable Component targetName) {
        this.message = message;
        this.chatType = chatType;
        this.name = name;
        this.targetName = targetName;
    }
}

