/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.KnownPack;

public class ServerboundSelectKnownPacks
implements MinecraftPacket {
    private final List<KnownPack> knownPacks;

    public ServerboundSelectKnownPacks(ByteBuf in, MinecraftCodecHelper helper) {
        this.knownPacks = new ArrayList<KnownPack>();
        int entryCount = Math.min(helper.readVarInt(in), 64);
        for (int i = 0; i < entryCount; ++i) {
            this.knownPacks.add(new KnownPack(helper.readString(in), helper.readString(in), helper.readString(in)));
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        if (this.knownPacks.size() > 64) {
            throw new IllegalArgumentException("KnownPacks is longer than maximum allowed length");
        }
        helper.writeVarInt(out, this.knownPacks.size());
        for (KnownPack entry : this.knownPacks) {
            helper.writeString(out, entry.getNamespace());
            helper.writeString(out, entry.getId());
            helper.writeString(out, entry.getVersion());
        }
    }

    public List<KnownPack> getKnownPacks() {
        return this.knownPacks;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSelectKnownPacks)) {
            return false;
        }
        ServerboundSelectKnownPacks other = (ServerboundSelectKnownPacks)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<KnownPack> this$knownPacks = this.getKnownPacks();
        List<KnownPack> other$knownPacks = other.getKnownPacks();
        return !(this$knownPacks == null ? other$knownPacks != null : !((Object)this$knownPacks).equals(other$knownPacks));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSelectKnownPacks;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<KnownPack> $knownPacks = this.getKnownPacks();
        result = result * 59 + ($knownPacks == null ? 43 : ((Object)$knownPacks).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSelectKnownPacks(knownPacks=" + this.getKnownPacks() + ")";
    }

    public @NonNull ServerboundSelectKnownPacks withKnownPacks(List<KnownPack> knownPacks) {
        return this.knownPacks == knownPacks ? this : new ServerboundSelectKnownPacks(knownPacks);
    }

    public ServerboundSelectKnownPacks(List<KnownPack> knownPacks) {
        this.knownPacks = knownPacks;
    }
}

