/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.common.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundCustomReportDetailsPacket
implements MinecraftPacket {
    private final Map<String, String> details;

    public ClientboundCustomReportDetailsPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.details = new HashMap<String, String>();
        int count = helper.readVarInt(in);
        for (int i = 0; i < count; ++i) {
            this.details.put(helper.readString(in, 128), helper.readString(in, 4096));
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.details.size());
        for (Map.Entry<String, String> entry : this.details.entrySet()) {
            helper.writeString(out, entry.getKey());
            helper.writeString(out, entry.getValue());
        }
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCustomReportDetailsPacket)) {
            return false;
        }
        ClientboundCustomReportDetailsPacket other = (ClientboundCustomReportDetailsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$details = this.getDetails();
        Map<String, String> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundCustomReportDetailsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundCustomReportDetailsPacket(details=" + this.getDetails() + ")";
    }

    public @NonNull ClientboundCustomReportDetailsPacket withDetails(Map<String, String> details) {
        return this.details == details ? this : new ClientboundCustomReportDetailsPacket(details);
    }

    public ClientboundCustomReportDetailsPacket(Map<String, String> details) {
        this.details = details;
    }
}

