/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.metadata;

import io.netty.buffer.ByteBuf;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class IntMetadataType
extends MetadataType<Integer> {
    private final IntReader primitiveReader;
    private final IntWriter primitiveWriter;
    private final IntEntityMetadataFactory primitiveFactory;

    protected IntMetadataType(IntReader reader, IntWriter writer, IntEntityMetadataFactory metadataFactory) {
        super(reader, writer, metadataFactory);
        this.primitiveReader = reader;
        this.primitiveWriter = writer;
        this.primitiveFactory = metadataFactory;
    }

    @Override
    public EntityMetadata<Integer, IntMetadataType> readMetadata(MinecraftCodecHelper helper, ByteBuf input, int id) {
        return this.primitiveFactory.createPrimitive(id, this, this.primitiveReader.readPrimitive(helper, input));
    }

    public void writeMetadataPrimitive(MinecraftCodecHelper helper, ByteBuf output, int value) {
        this.primitiveWriter.writePrimitive(helper, output, value);
    }

    @FunctionalInterface
    public static interface IntReader
    extends MetadataType.Reader<Integer> {
        public int readPrimitive(MinecraftCodecHelper var1, ByteBuf var2);

        @Override
        @Deprecated
        default public Integer read(MinecraftCodecHelper helper, ByteBuf input) {
            return this.readPrimitive(helper, input);
        }
    }

    @FunctionalInterface
    public static interface IntWriter
    extends MetadataType.Writer<Integer> {
        public void writePrimitive(MinecraftCodecHelper var1, ByteBuf var2, int var3);

        @Override
        @Deprecated
        default public void write(MinecraftCodecHelper helper, ByteBuf output, Integer value) {
            this.writePrimitive(helper, output, value);
        }
    }

    @FunctionalInterface
    public static interface IntEntityMetadataFactory
    extends MetadataType.EntityMetadataFactory<Integer> {
        public IntEntityMetadata createPrimitive(int var1, IntMetadataType var2, int var3);

        @Override
        @Deprecated
        default public EntityMetadata<Integer, IntMetadataType> create(int id, MetadataType<Integer> type, Integer value) {
            throw new UnsupportedOperationException("Unsupported read method! Use primitive createPrimitive!");
        }
    }
}

